/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entityfishingdrops.util;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import net.poe.entityfishingdrops.Entityfishingdrops;
import net.poe.entityfishingdrops.config.FishingDropsConfigManager;
import net.poe.entityfishingdrops.config.model.CustomDropEntry;

public class FishingDropProcessor {
    private static final Map<String, Long> commandCooldowns = new HashMap<String, Long>();
    private static final Map<String, Long> dropCommandCooldowns = new HashMap<String, Long>();

    public static void processFishingCatch(ServerPlayer player, ItemStack caughtItem, ServerLevel world, BlockPos pos) {
        List<CustomDropEntry> allDrops = FishingDropsConfigManager.getAllDropEntries();
        String caughtItemId = ForgeRegistries.ITEMS.getKey((Object)caughtItem.m_41720_()).toString();
        Entityfishingdrops.LOGGER.debug("Processing fishing catch: {} at {}", (Object)caughtItemId, (Object)pos);
        for (CustomDropEntry dropEntry : allDrops) {
            if (!FishingDropProcessor.checkAllConditions(dropEntry, player, world, pos)) continue;
            FishingDropProcessor.processGlobalCommand(dropEntry, player, world);
            FishingDropProcessor.processItemDrop(dropEntry, player, world, pos, caughtItemId);
        }
    }

    private static void processGlobalCommand(CustomDropEntry dropEntry, ServerPlayer player, ServerLevel world) {
        long lastExecution;
        if (dropEntry.getCommand() == null || dropEntry.getCommand().isEmpty()) {
            return;
        }
        if (Math.random() * 100.0 > (double)dropEntry.getCommandChance().floatValue()) {
            Entityfishingdrops.LOGGER.debug("Global command failed chance check: {}%", (Object)dropEntry.getCommandChance());
            return;
        }
        String cooldownKey = String.valueOf(player.m_20148_()) + ":" + dropEntry.getCommand();
        long currentTime = System.currentTimeMillis() / 1000L;
        if (commandCooldowns.containsKey(cooldownKey) && currentTime - (lastExecution = commandCooldowns.get(cooldownKey).longValue()) < (long)dropEntry.getCommandCooldown().intValue()) {
            Entityfishingdrops.LOGGER.debug("Global command on cooldown for {} more seconds", (Object)((long)dropEntry.getCommandCooldown().intValue() - (currentTime - lastExecution)));
            return;
        }
        FishingDropProcessor.executeCommand(dropEntry.getCommand(), player, world);
        commandCooldowns.put(cooldownKey, currentTime);
        Entityfishingdrops.LOGGER.debug("Executed global command: {}", (Object)dropEntry.getCommand());
    }

    private static void processItemDrop(CustomDropEntry dropEntry, ServerPlayer player, ServerLevel world, BlockPos pos, String caughtItemId) {
        if (dropEntry.getItemId() == null || dropEntry.getItemId().isEmpty()) {
            return;
        }
        if (dropEntry.getCatchId() != null && !dropEntry.getCatchId().isEmpty() && !dropEntry.getCatchId().equals(caughtItemId)) {
            return;
        }
        if (Math.random() * 100.0 > (double)dropEntry.getDropChance().floatValue()) {
            Entityfishingdrops.LOGGER.debug("Item drop failed chance check: {}%", (Object)dropEntry.getDropChance());
            return;
        }
        ResourceLocation itemLocation = new ResourceLocation(dropEntry.getItemId());
        Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
        if (item == null) {
            Entityfishingdrops.LOGGER.warn("Invalid item ID: {}", (Object)dropEntry.getItemId());
            return;
        }
        int amount = dropEntry.getMinAmount();
        if (dropEntry.getMaxAmount() > dropEntry.getMinAmount()) {
            amount = dropEntry.getMinAmount() + world.f_46441_.m_188503_(dropEntry.getMaxAmount() - dropEntry.getMinAmount() + 1);
        }
        ItemStack dropStack = new ItemStack((ItemLike)item, amount);
        if (dropEntry.getNbtData() != null && !dropEntry.getNbtData().isEmpty()) {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)dropEntry.getNbtData());
                dropStack.m_41751_(nbt);
            }
            catch (Exception e) {
                Entityfishingdrops.LOGGER.error("Error parsing NBT data '{}': {}", (Object)dropEntry.getNbtData(), (Object)e.getMessage());
            }
        }
        ItemEntity itemEntity = new ItemEntity((Level)world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, dropStack);
        world.m_7967_((Entity)itemEntity);
        Entityfishingdrops.LOGGER.debug("Dropped {} x{} at {}", new Object[]{dropEntry.getItemId(), amount, pos});
        FishingDropProcessor.processExtraDrops(dropEntry, player, world, pos);
        FishingDropProcessor.processDropCommand(dropEntry, player, world);
    }

    private static void processExtraDrops(CustomDropEntry dropEntry, ServerPlayer player, ServerLevel world, BlockPos pos) {
        ResourceLocation itemLocation;
        Item item;
        if (dropEntry.getExtraDropChance().floatValue() <= 0.0f || dropEntry.getItemId() == null) {
            return;
        }
        if (Math.random() * 100.0 <= (double)dropEntry.getExtraDropChance().floatValue() && (item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation = new ResourceLocation(dropEntry.getItemId()))) != null) {
            int extraAmount = dropEntry.getExtraAmountMin();
            if (dropEntry.getExtraAmountMax() > dropEntry.getExtraAmountMin()) {
                extraAmount = dropEntry.getExtraAmountMin() + world.f_46441_.m_188503_(dropEntry.getExtraAmountMax() - dropEntry.getExtraAmountMin() + 1);
            }
            ItemStack extraStack = new ItemStack((ItemLike)item, extraAmount);
            ItemEntity itemEntity = new ItemEntity((Level)world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, extraStack);
            world.m_7967_((Entity)itemEntity);
            Entityfishingdrops.LOGGER.debug("Dropped extra {} x{}", (Object)dropEntry.getItemId(), (Object)extraAmount);
        }
    }

    private static void processDropCommand(CustomDropEntry dropEntry, ServerPlayer player, ServerLevel world) {
        long lastExecution;
        if (dropEntry.getDropCommand() == null || dropEntry.getDropCommand().isEmpty()) {
            return;
        }
        if (Math.random() * 100.0 > (double)dropEntry.getDropCommandChance().floatValue()) {
            Entityfishingdrops.LOGGER.debug("Drop command failed chance check: {}%", (Object)dropEntry.getDropCommandChance());
            return;
        }
        String cooldownKey = String.valueOf(player.m_20148_()) + ":" + dropEntry.getDropCommand();
        long currentTime = System.currentTimeMillis() / 1000L;
        if (dropCommandCooldowns.containsKey(cooldownKey) && currentTime - (lastExecution = dropCommandCooldowns.get(cooldownKey).longValue()) < (long)dropEntry.getDropCommandCooldown().intValue()) {
            Entityfishingdrops.LOGGER.debug("Drop command on cooldown for {} more seconds", (Object)((long)dropEntry.getDropCommandCooldown().intValue() - (currentTime - lastExecution)));
            return;
        }
        FishingDropProcessor.executeCommand(dropEntry.getDropCommand(), player, world);
        dropCommandCooldowns.put(cooldownKey, currentTime);
        Entityfishingdrops.LOGGER.debug("Executed drop command: {}", (Object)dropEntry.getDropCommand());
    }

    private static void executeCommand(String command, ServerPlayer player, ServerLevel world) {
        if (command == null || command.isEmpty()) {
            return;
        }
        try {
            String processedCommand = command.replace("{player}", player.m_7755_().getString()).replace("{x}", String.valueOf(player.m_146903_())).replace("{y}", String.valueOf(player.m_146904_())).replace("{z}", String.valueOf(player.m_146907_())).replace("{world}", world.m_46472_().m_135782_().toString()).replace("{biome}", ((ResourceKey)world.m_204166_(player.m_20183_()).m_203543_().orElse(null)).m_135782_().toString());
            CommandSourceStack commandSource = world.m_7654_().m_129893_().m_81329_((Entity)player).m_81327_(world).m_81348_(player.m_20182_()).m_81325_(4);
            world.m_7654_().m_129892_().m_230957_(commandSource, processedCommand);
            Entityfishingdrops.LOGGER.debug("Executed command: {}", (Object)processedCommand);
        }
        catch (Exception e) {
            Entityfishingdrops.LOGGER.error("Error executing command '{}': {}", (Object)command, (Object)e.getMessage());
        }
    }

    private static boolean checkAllConditions(CustomDropEntry dropEntry, ServerPlayer player, ServerLevel world, BlockPos pos) {
        if (dropEntry.getRequiredDimensions() != null && !dropEntry.getRequiredDimensions().isEmpty()) {
            String currentDimension = world.m_46472_().m_135782_().toString();
            if (!dropEntry.getRequiredDimensions().contains(currentDimension)) {
                return false;
            }
        }
        if (dropEntry.getRequiredBiomes() != null && !dropEntry.getRequiredBiomes().isEmpty()) {
            String currentBiome = ((ResourceKey)world.m_204166_(pos).m_203543_().orElse(null)).m_135782_().toString();
            if (!dropEntry.getRequiredBiomes().contains(currentBiome)) {
                return false;
            }
        }
        if (dropEntry.getRequiredWeather() != null && !dropEntry.getRequiredWeather().isEmpty()) {
            boolean isRaining = world.m_46471_();
            boolean isThundering = world.m_46470_();
            switch (dropEntry.getRequiredWeather().toLowerCase()) {
                case "clear": {
                    if (!isRaining) break;
                    return false;
                }
                case "rain": {
                    if (isRaining && !isThundering) break;
                    return false;
                }
                case "thunder": {
                    if (isThundering) break;
                    return false;
                }
            }
        }
        if (dropEntry.getRequiredTimeOfDay() != null && !dropEntry.getRequiredTimeOfDay().isEmpty()) {
            long timeOfDay = world.m_46468_() % 24000L;
            boolean isDay = timeOfDay >= 0L && timeOfDay < 12000L;
            switch (dropEntry.getRequiredTimeOfDay().toLowerCase()) {
                case "day": {
                    if (isDay) break;
                    return false;
                }
                case "night": {
                    if (!isDay) break;
                    return false;
                }
            }
        }
        return true;
    }
}

