/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entityfishingdrops.event;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.poe.entityfishingdrops.Entityfishingdrops;
import net.poe.entityfishingdrops.config.EventMessagesConfig;

public class EventManager {
    private static final String CONFIG_DIR_NAME = "EntityFishingDrops";
    private static final String EVENT_DROPS_DIR = "Event Drops";
    private static final String ACTIVE_EVENTS_FILE = "Active_Events.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static Set<String> activeEvents = new HashSet<String>();
    private static File configRootDir;
    private static File activeEventsFile;

    public static void init() {
        configRootDir = new File(FMLPaths.CONFIGDIR.get().toFile(), CONFIG_DIR_NAME);
        activeEventsFile = new File(configRootDir, ACTIVE_EVENTS_FILE);
        EventManager.loadActiveEvents();
    }

    private static void loadActiveEvents() {
        activeEvents.clear();
        if (activeEventsFile.exists()) {
            try (FileReader reader = new FileReader(activeEventsFile);){
                Type setType = new TypeToken<Set<String>>(){}.getType();
                Set loadedEvents = (Set)GSON.fromJson((Reader)reader, setType);
                if (loadedEvents != null) {
                    activeEvents.addAll(loadedEvents);
                }
                Entityfishingdrops.LOGGER.info("Loaded {} active fishing events", (Object)activeEvents.size());
            }
            catch (IOException e) {
                Entityfishingdrops.LOGGER.error("Failed to load active events file", (Throwable)e);
            }
        } else {
            EventManager.createDefaultActiveEventsFile();
        }
    }

    private static void createDefaultActiveEventsFile() {
        try (FileWriter writer = new FileWriter(activeEventsFile);){
            HashSet defaultEvents = new HashSet();
            GSON.toJson(defaultEvents, (Appendable)writer);
            Entityfishingdrops.LOGGER.info("Created default Active_Events.json file");
        }
        catch (IOException e) {
            Entityfishingdrops.LOGGER.error("Failed to create active events file", (Throwable)e);
        }
    }

    private static void saveActiveEvents() {
        try (FileWriter writer = new FileWriter(activeEventsFile);){
            GSON.toJson(activeEvents, (Appendable)writer);
            Entityfishingdrops.LOGGER.debug("Saved Active_Events.json file");
        }
        catch (IOException e) {
            Entityfishingdrops.LOGGER.error("Failed to save active events file", (Throwable)e);
        }
    }

    public static boolean enableEvent(String eventName) {
        if (!EventManager.eventExists(eventName)) {
            return false;
        }
        if (activeEvents.add(eventName)) {
            EventManager.saveActiveEvents();
            Entityfishingdrops.LOGGER.info("Enabled fishing event: {}", (Object)eventName);
            String message = EventMessagesConfig.getEnableMessage(eventName);
            EventManager.notifyAllPlayers((Component)Component.m_237113_((String)message));
        }
        return true;
    }

    public static void disableEvent(String eventName) {
        if (activeEvents.remove(eventName)) {
            EventManager.saveActiveEvents();
            Entityfishingdrops.LOGGER.info("Disabled fishing event: {}", (Object)eventName);
            String message = EventMessagesConfig.getDisableMessage(eventName);
            EventManager.notifyAllPlayers((Component)Component.m_237113_((String)message));
        }
    }

    private static void notifyAllPlayers(Component message) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            for (ServerPlayer player : server.m_6846_().m_11314_()) {
                player.m_213846_(message);
            }
        }
    }

    public static boolean isEventEnabled(String eventName) {
        return activeEvents.contains(eventName);
    }

    public static boolean eventExists(String eventName) {
        File eventDropsDir = new File(configRootDir, EVENT_DROPS_DIR);
        File eventDir = new File(eventDropsDir, eventName);
        return eventDir.exists() && eventDir.isDirectory();
    }

    public static Set<String> getActiveEvents() {
        return new HashSet<String>(activeEvents);
    }

    public static List<String> getAllEvents() {
        File[] eventDirs;
        ArrayList<String> allEvents = new ArrayList<String>();
        File eventDropsDir = new File(configRootDir, EVENT_DROPS_DIR);
        if (eventDropsDir.exists() && eventDropsDir.isDirectory() && (eventDirs = eventDropsDir.listFiles(File::isDirectory)) != null) {
            for (File eventDir : eventDirs) {
                allEvents.add(eventDir.getName());
            }
        }
        Collections.sort(allEvents);
        return allEvents;
    }

    public static void reload() {
        EventManager.loadActiveEvents();
    }
}

