/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entityfishingdrops.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import net.poe.entityfishingdrops.Entityfishingdrops;
import net.poe.entityfishingdrops.config.model.CustomDropEntry;
import net.poe.entityfishingdrops.event.EventManager;

public class FishingDropsConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String GLOBAL_FILE_NAME = "Global_Fishing_Drops.json";
    private static final String EXAMPLE_FILE_NAME = "Global_Fishing_Drops.example";
    private static File configDir;
    private static File normalDropsDir;
    private static File eventDropsDir;
    private static List<CustomDropEntry> allDropEntries;

    public static void init() {
        FishingDropsConfigManager.setupDirectories();
        FishingDropsConfigManager.generateExampleFiles();
        FishingDropsConfigManager.loadAllConfigurations();
    }

    public static void reload() {
        allDropEntries.clear();
        FishingDropsConfigManager.loadAllConfigurations();
        Entityfishingdrops.LOGGER.info("Reloaded fishing drops configuration");
    }

    public static List<CustomDropEntry> getAllDropEntries() {
        return new ArrayList<CustomDropEntry>(allDropEntries);
    }

    private static void setupDirectories() {
        configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), "EntityFishingDrops");
        normalDropsDir = new File(configDir, "Normal Drops");
        eventDropsDir = new File(configDir, "Event Drops");
        configDir.mkdirs();
        normalDropsDir.mkdirs();
        eventDropsDir.mkdirs();
        new File(normalDropsDir, "Drops").mkdirs();
    }

    private static void generateExampleFiles() {
        File globalFile = new File(normalDropsDir, GLOBAL_FILE_NAME);
        if (!globalFile.exists()) {
            FishingDropsConfigManager.generateGlobalDropsFile(globalFile);
        }
        File globalExampleFile = new File(normalDropsDir, EXAMPLE_FILE_NAME);
        FishingDropsConfigManager.generateGlobalDropsExampleFile(globalExampleFile);
        File dropsDir = new File(normalDropsDir, "Drops");
        File codFile = new File(dropsDir, "minecraft_cod.json");
        if (!codFile.exists()) {
            FishingDropsConfigManager.generateCodDropsFile(codFile);
        }
        FishingDropsConfigManager.generateAllEventExamples();
    }

    private static void generateAllEventExamples() {
        String[] events;
        for (String eventName : events = new String[]{"Easter", "Winter", "Summer", "Halloween", "Christmas"}) {
            File eventDir = new File(eventDropsDir, eventName);
            if (eventDir.exists()) continue;
            eventDir.mkdirs();
            new File(eventDir, "Drops").mkdirs();
            FishingDropsConfigManager.generateEventGlobalFile(eventDir, eventName);
            FishingDropsConfigManager.generateEventSpecificDrops(eventDir, eventName);
        }
    }

    private static void generateGlobalDropsFile(File file) {
        ArrayList<CustomDropEntry> globalDrops = new ArrayList<CustomDropEntry>();
        CustomDropEntry globalCommand = new CustomDropEntry();
        globalCommand.setCommand("effect give {player} minecraft:luck 10 0");
        globalCommand.setCommandChance(Float.valueOf(10.0f));
        globalCommand.setCommandCooldown(60);
        globalCommand.setComment("Global command - gives luck effect on any fishing catch");
        globalDrops.add(globalCommand);
        CustomDropEntry globalItem = new CustomDropEntry();
        globalItem.setItemId("minecraft:experience_bottle");
        globalItem.setDropChance(Float.valueOf(5.0f));
        globalItem.setMinAmount(1);
        globalItem.setMaxAmount(1);
        globalItem.setCommandChance(Float.valueOf(100.0f));
        globalItem.setCommandCooldown(0);
        globalItem.setDropCommand("tellraw {player} {\"text\":\"Bonus XP bottle!\",\"color\":\"green\"}");
        globalItem.setDropCommandChance(Float.valueOf(100.0f));
        globalItem.setDropCommandCooldown(0);
        globalItem.setExtraDropChance(Float.valueOf(0.0f));
        globalItem.setExtraAmountMin(1);
        globalItem.setExtraAmountMax(1);
        globalItem.setComment("5% chance for experience bottle on any fishing catch");
        globalDrops.add(globalItem);
        FishingDropsConfigManager.saveDropsToFile(file, globalDrops);
        Entityfishingdrops.LOGGER.debug("Generated Global_Fishing_Drops.json");
    }

    private static void generateGlobalDropsExampleFile(File file) {
        ArrayList<CustomDropEntry> examples = new ArrayList<CustomDropEntry>();
        CustomDropEntry globalCommandOnly = new CustomDropEntry();
        globalCommandOnly.setCommand("effect give {player} minecraft:luck 30 0");
        globalCommandOnly.setCommandChance(Float.valueOf(10.0f));
        globalCommandOnly.setCommandCooldown(300);
        globalCommandOnly.setComment("10% chance to give luck effect on any fishing catch");
        examples.add(globalCommandOnly);
        CustomDropEntry globalDrop = new CustomDropEntry();
        globalDrop.setItemId("minecraft:experience_bottle");
        globalDrop.setDropChance(Float.valueOf(5.0f));
        globalDrop.setMinAmount(1);
        globalDrop.setMaxAmount(1);
        globalDrop.setDropCommand("tellraw {player} {\"text\":\"Bonus XP bottle!\",\"color\":\"green\"}");
        globalDrop.setDropCommandChance(Float.valueOf(100.0f));
        globalDrop.setComment("5% chance for XP bottle on any fishing catch");
        examples.add(globalDrop);
        CustomDropEntry itemSpecificDrop = new CustomDropEntry();
        itemSpecificDrop.setCatchId("minecraft:cod");
        itemSpecificDrop.setItemId("minecraft:gold_nugget");
        itemSpecificDrop.setDropChance(Float.valueOf(25.0f));
        itemSpecificDrop.setMinAmount(1);
        itemSpecificDrop.setMaxAmount(3);
        itemSpecificDrop.setDropCommand("tellraw {player} {\"text\":\"Gold found in cod!\",\"color\":\"gold\"}");
        itemSpecificDrop.setDropCommandChance(Float.valueOf(100.0f));
        itemSpecificDrop.setComment("25% chance for gold when catching cod");
        examples.add(itemSpecificDrop);
        CustomDropEntry combinedDrop = new CustomDropEntry();
        combinedDrop.setCatchId("minecraft:salmon");
        combinedDrop.setCommand("effect give {player} minecraft:regeneration 10 0");
        combinedDrop.setCommandChance(Float.valueOf(100.0f));
        combinedDrop.setCommandCooldown(60);
        combinedDrop.setItemId("minecraft:iron_nugget");
        combinedDrop.setDropChance(Float.valueOf(15.0f));
        combinedDrop.setMinAmount(1);
        combinedDrop.setMaxAmount(2);
        combinedDrop.setDropCommand("tellraw {player} {\"text\":\"Iron from salmon!\",\"color\":\"gray\"}");
        combinedDrop.setDropCommandChance(Float.valueOf(100.0f));
        combinedDrop.setComment("Always gives regen on any catch, 15% iron when catching salmon");
        examples.add(combinedDrop);
        CustomDropEntry rareDrop = new CustomDropEntry();
        rareDrop.setCatchId("minecraft:salmon");
        rareDrop.setItemId("minecraft:diamond");
        rareDrop.setDropChance(Float.valueOf(5.0f));
        rareDrop.setMinAmount(1);
        rareDrop.setMaxAmount(1);
        rareDrop.setNbtData("{display:{Name:'{\"text\":\"Lucky Diamond\",\"color\":\"aqua\"}'}}");
        rareDrop.setDropCommand("tellraw @a {\"text\":\"{player} found a Lucky Diamond!\",\"color\":\"aqua\"}");
        rareDrop.setDropCommandChance(Float.valueOf(100.0f));
        rareDrop.setRequiredWeather("rain");
        rareDrop.setRequiredTimeOfDay("night");
        rareDrop.setComment("Rare diamond only during rain at night");
        examples.add(rareDrop);
        CustomDropEntry biomeExample = new CustomDropEntry();
        biomeExample.setItemId("minecraft:prismarine_shard");
        biomeExample.setDropChance(Float.valueOf(20.0f));
        biomeExample.setMinAmount(1);
        biomeExample.setMaxAmount(2);
        biomeExample.setRequiredBiomes(Arrays.asList("minecraft:ocean", "minecraft:deep_ocean", "minecraft:warm_ocean"));
        biomeExample.setDropCommand("tellraw {player} {\"text\":\"Ocean treasure!\",\"color\":\"blue\"}");
        biomeExample.setDropCommandChance(Float.valueOf(100.0f));
        biomeExample.setComment("20% chance for prismarine shards in ocean biomes");
        examples.add(biomeExample);
        CustomDropEntry dimensionExample = new CustomDropEntry();
        dimensionExample.setItemId("minecraft:magma_cream");
        dimensionExample.setDropChance(Float.valueOf(30.0f));
        dimensionExample.setMinAmount(1);
        dimensionExample.setMaxAmount(1);
        dimensionExample.setRequiredDimensions(Arrays.asList("minecraft:nether"));
        dimensionExample.setDropCommand("tellraw {player} {\"text\":\"Nether fishing bonus!\",\"color\":\"red\"}");
        dimensionExample.setDropCommandChance(Float.valueOf(100.0f));
        dimensionExample.setComment("30% chance for magma cream when fishing in Nether");
        examples.add(dimensionExample);
        CustomDropEntry extraDropExample = new CustomDropEntry();
        extraDropExample.setCatchId("minecraft:tropical_fish");
        extraDropExample.setItemId("minecraft:emerald");
        extraDropExample.setDropChance(Float.valueOf(10.0f));
        extraDropExample.setMinAmount(1);
        extraDropExample.setMaxAmount(1);
        extraDropExample.setExtraDropChance(Float.valueOf(50.0f));
        extraDropExample.setExtraAmountMin(1);
        extraDropExample.setExtraAmountMax(2);
        extraDropExample.setComment("10% emerald from tropical fish, 50% chance for 1-2 bonus emeralds");
        examples.add(extraDropExample);
        CustomDropEntry weatherExample = new CustomDropEntry();
        weatherExample.setCommand("give {player} minecraft:trident 1");
        weatherExample.setCommandChance(Float.valueOf(1.0f));
        weatherExample.setCommandCooldown(1800);
        weatherExample.setRequiredWeather("thunder");
        weatherExample.setComment("1% chance for trident during thunderstorms (30min cooldown)");
        examples.add(weatherExample);
        CustomDropEntry timeExample = new CustomDropEntry();
        timeExample.setItemId("minecraft:phantom_membrane");
        timeExample.setDropChance(Float.valueOf(8.0f));
        timeExample.setMinAmount(1);
        timeExample.setMaxAmount(1);
        timeExample.setRequiredTimeOfDay("night");
        timeExample.setDropCommand("tellraw {player} {\"text\":\"Night fishing bonus!\",\"color\":\"dark_purple\"}");
        timeExample.setDropCommandChance(Float.valueOf(100.0f));
        timeExample.setComment("8% chance for phantom membrane during night fishing");
        examples.add(timeExample);
        CustomDropEntry nbtExample = new CustomDropEntry();
        nbtExample.setCatchId("minecraft:pufferfish");
        nbtExample.setItemId("minecraft:enchanted_book");
        nbtExample.setDropChance(Float.valueOf(3.0f));
        nbtExample.setMinAmount(1);
        nbtExample.setMaxAmount(1);
        nbtExample.setNbtData("{StoredEnchantments:[{id:\"minecraft:luck_of_the_sea\",lvl:3}]}");
        nbtExample.setDropCommand("tellraw {player} {\"text\":\"Lucky enchanted book!\",\"color\":\"purple\"}");
        nbtExample.setDropCommandChance(Float.valueOf(100.0f));
        nbtExample.setComment("3% chance for Luck of the Sea III book from pufferfish");
        examples.add(nbtExample);
        CustomDropEntry multiConditionExample = new CustomDropEntry();
        multiConditionExample.setCatchId("minecraft:cod");
        multiConditionExample.setItemId("minecraft:nautilus_shell");
        multiConditionExample.setDropChance(Float.valueOf(12.0f));
        multiConditionExample.setMinAmount(1);
        multiConditionExample.setMaxAmount(1);
        multiConditionExample.setRequiredWeather("rain");
        multiConditionExample.setRequiredBiomes(Arrays.asList("minecraft:ocean", "minecraft:deep_ocean"));
        multiConditionExample.setRequiredTimeOfDay("day");
        multiConditionExample.setDropCommand("tellraw {player} {\"text\":\"Perfect conditions shell!\",\"color\":\"yellow\"}");
        multiConditionExample.setDropCommandChance(Float.valueOf(100.0f));
        multiConditionExample.setComment("12% nautilus shell - ocean biome + rain + daytime + cod");
        examples.add(multiConditionExample);
        CustomDropEntry moddedItem = new CustomDropEntry();
        moddedItem.setCatchId("minecraft:cod");
        moddedItem.setItemId("thermal:silver_ingot");
        moddedItem.setDropChance(Float.valueOf(15.0f));
        moddedItem.setMinAmount(1);
        moddedItem.setMaxAmount(2);
        moddedItem.setComment("Works with any modded items - 15% silver ingot from cod");
        examples.add(moddedItem);
        CustomDropEntry placeholderExample = new CustomDropEntry();
        placeholderExample.setCommand("tellraw @a {\"text\":\"{player} caught something at {x}, {y}, {z} in {biome}!\",\"color\":\"green\"}");
        placeholderExample.setCommandChance(Float.valueOf(5.0f));
        placeholderExample.setCommandCooldown(120);
        placeholderExample.setComment("5% chance to announce catch with coordinates and biome");
        examples.add(placeholderExample);
        CustomDropEntry rareValueExample = new CustomDropEntry();
        rareValueExample.setItemId("minecraft:netherite_scrap");
        rareValueExample.setDropChance(Float.valueOf(0.5f));
        rareValueExample.setMinAmount(1);
        rareValueExample.setMaxAmount(1);
        rareValueExample.setDropCommand("tellraw @a {\"text\":\"{player} found ancient debris while fishing!\",\"color\":\"dark_purple\"}");
        rareValueExample.setDropCommandChance(Float.valueOf(100.0f));
        rareValueExample.setComment("Ultra rare 0.5% chance for netherite scrap");
        examples.add(rareValueExample);
        CustomDropEntry minimalExample = new CustomDropEntry();
        minimalExample.setItemId("minecraft:emerald");
        minimalExample.setDropChance(Float.valueOf(2.0f));
        minimalExample.setComment("Simple 2% emerald drop");
        examples.add(minimalExample);
        FishingDropsConfigManager.saveDropsToFile(file, examples);
        Entityfishingdrops.LOGGER.debug("Generated Global_Fishing_Drops.example");
    }

    private static void generateCodDropsFile(File file) {
        ArrayList<CustomDropEntry> codDrops = new ArrayList<CustomDropEntry>();
        CustomDropEntry codDrop = new CustomDropEntry();
        codDrop.setCatchId("minecraft:cod");
        codDrop.setItemId("minecraft:gold_ingot");
        codDrop.setDropChance(Float.valueOf(25.0f));
        codDrop.setMinAmount(1);
        codDrop.setMaxAmount(2);
        codDrop.setDropCommand("tellraw {player} {\"text\":\"You found gold in the cod!\",\"color\":\"gold\"}");
        codDrop.setDropCommandChance(Float.valueOf(100.0f));
        codDrop.setComment("25% chance for gold ingot when catching cod");
        codDrops.add(codDrop);
        FishingDropsConfigManager.saveDropsToFile(file, codDrops);
        Entityfishingdrops.LOGGER.debug("Generated minecraft_cod.json");
    }

    private static void generateEventGlobalFile(File eventDir, String eventName) {
        File globalFile = new File(eventDir, "Global_" + eventName + "_Drops.json");
        ArrayList<CustomDropEntry> eventDrops = new ArrayList<CustomDropEntry>();
        CustomDropEntry eventDrop = new CustomDropEntry();
        eventDrop.setItemId("minecraft:emerald");
        eventDrop.setDropChance(Float.valueOf(10.0f));
        eventDrop.setMinAmount(1);
        eventDrop.setMaxAmount(2);
        eventDrop.setDropCommand("tellraw {player} {\"text\":\"" + eventName + " bonus emerald!\",\"color\":\"green\"}");
        eventDrop.setDropCommandChance(Float.valueOf(100.0f));
        eventDrop.setComment(eventName + " event - 10% chance for emerald on any fishing catch");
        eventDrops.add(eventDrop);
        FishingDropsConfigManager.saveDropsToFile(globalFile, eventDrops);
        Entityfishingdrops.LOGGER.debug("Generated Global_{}_Drops.json", (Object)eventName);
    }

    private static void generateEventSpecificDrops(File eventDir, String eventName) {
        File dropsDir = new File(eventDir, "Drops");
        File salmonFile = new File(dropsDir, "minecraft_salmon.json");
        ArrayList<CustomDropEntry> salmonDrops = new ArrayList<CustomDropEntry>();
        CustomDropEntry salmonDrop = new CustomDropEntry();
        salmonDrop.setCatchId("minecraft:salmon");
        salmonDrop.setItemId("minecraft:diamond");
        salmonDrop.setDropChance(Float.valueOf(15.0f));
        salmonDrop.setMinAmount(1);
        salmonDrop.setMaxAmount(1);
        salmonDrop.setDropCommand("tellraw {player} {\"text\":\"" + eventName + " diamond from salmon!\",\"color\":\"aqua\"}");
        salmonDrop.setDropCommandChance(Float.valueOf(100.0f));
        salmonDrop.setComment(eventName + " event - 15% chance for diamond when catching salmon");
        salmonDrops.add(salmonDrop);
        FishingDropsConfigManager.saveDropsToFile(salmonFile, salmonDrops);
        Entityfishingdrops.LOGGER.debug("Generated minecraft_salmon.json for {}", (Object)eventName);
    }

    private static void loadAllConfigurations() {
        FishingDropsConfigManager.loadDropsFromDirectory(normalDropsDir, "Normal");
        Set<String> activeEvents = EventManager.getActiveEvents();
        for (String eventName : activeEvents) {
            File eventDir = new File(eventDropsDir, eventName);
            if (!eventDir.exists() || !eventDir.isDirectory()) continue;
            FishingDropsConfigManager.loadDropsFromDirectory(eventDir, "Event: " + eventName);
        }
        Entityfishingdrops.LOGGER.info("Loaded {} total drop entries", (Object)allDropEntries.size());
    }

    private static void loadDropsFromDirectory(File directory, String source) {
        File[] subdirs;
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles((dir, name) -> name.toLowerCase().endsWith(".json") && !name.toLowerCase().endsWith(".example"));
        if (files != null) {
            for (File file : files) {
                FishingDropsConfigManager.loadDropsFromFile(file, source);
            }
        }
        if ((subdirs = directory.listFiles(File::isDirectory)) != null) {
            for (File subdir : subdirs) {
                FishingDropsConfigManager.loadDropsFromDirectory(subdir, source);
            }
        }
    }

    private static void loadDropsFromFile(File file, String source) {
        try (FileReader reader = new FileReader(file);){
            Type listType = new TypeToken<List<CustomDropEntry>>(){}.getType();
            List fileDrops = (List)GSON.fromJson((Reader)reader, listType);
            if (fileDrops != null) {
                allDropEntries.addAll(fileDrops);
                Entityfishingdrops.LOGGER.debug("Loaded {} drop entries from {} ({})", new Object[]{fileDrops.size(), file.getName(), source});
            }
        }
        catch (IOException e) {
            Entityfishingdrops.LOGGER.error("Failed to load drops from {}: {}", (Object)file.getName(), (Object)e.getMessage());
        }
    }

    private static void saveDropsToFile(File file, List<CustomDropEntry> drops) {
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson(drops, (Appendable)writer);
        }
        catch (IOException e) {
            Entityfishingdrops.LOGGER.error("Failed to save drops to {}: {}", (Object)file.getName(), (Object)e.getMessage());
        }
    }

    public static boolean isValidItem(String itemId) {
        if (itemId == null || itemId.trim().isEmpty()) {
            return false;
        }
        try {
            ResourceLocation resourceLocation = new ResourceLocation(itemId);
            return ForgeRegistries.ITEMS.containsKey(resourceLocation);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ItemStack createItemStack(String itemId, int count) {
        if (!FishingDropsConfigManager.isValidItem(itemId)) {
            return ItemStack.f_41583_;
        }
        try {
            ResourceLocation resourceLocation = new ResourceLocation(itemId);
            return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(resourceLocation), count);
        }
        catch (Exception e) {
            return ItemStack.f_41583_;
        }
    }

    static {
        allDropEntries = new ArrayList<CustomDropEntry>();
    }
}

