/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entityfishingdrops.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;
import net.poe.entityfishingdrops.Entityfishingdrops;

public class EventMessagesConfig {
    private static final String CONFIG_DIR_NAME = "EntityFishingDrops";
    private static final String EVENT_MESSAGES_FILE = "Event_Messages.json";
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File configFile;
    private static EventMessages eventMessages;

    public static void init() {
        File configDir = new File(FMLPaths.CONFIGDIR.get().toFile(), CONFIG_DIR_NAME);
        configFile = new File(configDir, EVENT_MESSAGES_FILE);
        EventMessagesConfig.loadEventMessages();
    }

    private static void loadEventMessages() {
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                eventMessages = (EventMessages)GSON.fromJson((Reader)reader, EventMessages.class);
                if (eventMessages == null) {
                    EventMessagesConfig.createDefaultEventMessages();
                }
                Entityfishingdrops.LOGGER.info("Loaded event messages configuration");
            }
            catch (Exception e) {
                Entityfishingdrops.LOGGER.error("Failed to load event messages, creating default", (Throwable)e);
                EventMessagesConfig.createDefaultEventMessages();
            }
        } else {
            EventMessagesConfig.createDefaultEventMessages();
        }
    }

    private static void createDefaultEventMessages() {
        eventMessages = new EventMessages();
        EventMessagesConfig.eventMessages.enable.put("Easter", "\u00a76[Events] \u00a7d[EASTER] Easter event has been enabled!");
        EventMessagesConfig.eventMessages.enable.put("Winter", "\u00a76[Events] \u00a7b[WINTER] Winter event has been enabled!");
        EventMessagesConfig.eventMessages.enable.put("Summer", "\u00a76[Events] \u00a7e[SUMMER] Summer event has been enabled!");
        EventMessagesConfig.eventMessages.enable.put("Halloween", "\u00a76[Events] \u00a7c[HALLOWEEN] Halloween event has been enabled!");
        EventMessagesConfig.eventMessages.enable.put("Christmas", "\u00a76[Events] \u00a7a[CHRISTMAS] Christmas event has been enabled!");
        EventMessagesConfig.eventMessages.disable.put("Easter", "\u00a76[Events] \u00a77[EASTER] Easter event has been disabled!");
        EventMessagesConfig.eventMessages.disable.put("Winter", "\u00a76[Events] \u00a77[WINTER] Winter event has been disabled!");
        EventMessagesConfig.eventMessages.disable.put("Summer", "\u00a76[Events] \u00a77[SUMMER] Summer event has been disabled!");
        EventMessagesConfig.eventMessages.disable.put("Halloween", "\u00a76[Events] \u00a77[HALLOWEEN] Halloween event has been disabled!");
        EventMessagesConfig.eventMessages.disable.put("Christmas", "\u00a76[Events] \u00a77[CHRISTMAS] Christmas event has been disabled!");
        EventMessagesConfig.saveEventMessages();
    }

    private static void saveEventMessages() {
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)eventMessages, (Appendable)writer);
            Entityfishingdrops.LOGGER.info("Created Event_Messages.json file");
        }
        catch (IOException e) {
            Entityfishingdrops.LOGGER.error("Failed to save event messages file", (Throwable)e);
        }
    }

    public static String getEnableMessage(String eventName) {
        if (eventMessages != null && EventMessagesConfig.eventMessages.enable.containsKey(eventName)) {
            return EventMessagesConfig.eventMessages.enable.get(eventName);
        }
        return "\u00a76[Events] \u00a7a" + eventName + " event has been enabled!";
    }

    public static String getDisableMessage(String eventName) {
        if (eventMessages != null && EventMessagesConfig.eventMessages.disable.containsKey(eventName)) {
            return EventMessagesConfig.eventMessages.disable.get(eventName);
        }
        return "\u00a76[Events] \u00a77" + eventName + " event has been disabled!";
    }

    public static void reload() {
        EventMessagesConfig.loadEventMessages();
    }

    private static class EventMessages {
        public Map<String, String> enable = new HashMap<String, String>();
        public Map<String, String> disable = new HashMap<String, String>();

        private EventMessages() {
        }
    }
}

