/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entityfishingdrops.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.poe.entityfishingdrops.config.FishingDropsConfigManager;
import net.poe.entityfishingdrops.event.EventManager;

public class FishingDropsCommand {
    private static final SuggestionProvider<CommandSourceStack> EVENT_SUGGESTIONS = (context, builder) -> {
        List<String> allEvents = EventManager.getAllEvents();
        return SharedSuggestionProvider.m_82970_(allEvents, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"fishingdrops").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(FishingDropsCommand::executeReload))).then(Commands.m_82127_((String)"event").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"eventName", (ArgumentType)StringArgumentType.string()).suggests(EVENT_SUGGESTIONS).then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(FishingDropsCommand::executeEvent))).executes(FishingDropsCommand::executeEventStatus)))).then(Commands.m_82127_((String)"list").executes(FishingDropsCommand::executeList)));
    }

    private static int executeReload(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        try {
            FishingDropsConfigManager.reload();
            EventManager.reload();
            source.m_288197_(() -> Component.m_237113_((String)"\u00a7aFishing drops configuration reloaded successfully!"), true);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cFailed to reload fishing drops configuration: " + e.getMessage())));
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int executeEvent(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String eventName = StringArgumentType.getString(context, (String)"eventName");
        boolean enabled = BoolArgumentType.getBool(context, (String)"enabled");
        try {
            if (!enabled) {
                EventManager.disableEvent(eventName);
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7cDisabled fishing event: " + eventName)), true);
                FishingDropsConfigManager.reload();
                return 1;
            }
            if (EventManager.enableEvent(eventName)) {
                source.m_288197_(() -> Component.m_237113_((String)("\u00a7aEnabled fishing event: " + eventName)), true);
                FishingDropsConfigManager.reload();
                return 1;
            }
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cEvent folder '" + eventName + "' not found!")));
            return 0;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cFailed to toggle event: " + e.getMessage())));
            return 0;
        }
    }

    private static int executeEventStatus(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        String eventName = StringArgumentType.getString(context, (String)"eventName");
        if (!EventManager.eventExists(eventName)) {
            source.m_81352_((Component)Component.m_237113_((String)("\u00a7cEvent folder '" + eventName + "' not found!")));
            return 0;
        }
        boolean isEnabled = EventManager.isEventEnabled(eventName);
        String status = isEnabled ? "\u00a7aENABLED" : "\u00a7cDISABLED";
        source.m_288197_(() -> Component.m_237113_((String)("\u00a77Event '" + eventName + "' is " + status)), false);
        return 1;
    }

    private static int executeList(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        List<String> allEvents = EventManager.getAllEvents();
        if (allEvents.isEmpty()) {
            source.m_288197_(() -> Component.m_237113_((String)"\u00a77No event folders found."), false);
            return 1;
        }
        source.m_288197_(() -> Component.m_237113_((String)"\u00a76Available Fishing Events:"), false);
        for (String event : allEvents) {
            boolean isEnabled = EventManager.isEventEnabled(event);
            String status = isEnabled ? "\u00a7a\u2713" : "\u00a7c\u2717";
            source.m_288197_(() -> Component.m_237113_((String)("  " + status + " \u00a77" + event)), false);
        }
        return 1;
    }
}

