/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.world.item.enchantment.serialize.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fuzs.universalenchants.UniversalEnchants;
import fuzs.universalenchants.world.item.enchantment.data.BuiltInEnchantmentDataManager;
import fuzs.universalenchants.world.item.enchantment.serialize.EnchantmentHolder;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.DataEntry;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public abstract class TypeEntry
extends DataEntry<Item> {
    private static final TypeEntry EMPTY = new TypeEntry(){

        @Override
        String serialize() {
            throw new UnsupportedOperationException("serialize called on empty enchantment category entry");
        }

        @Override
        public void dissolve(Set<Item> items) throws JsonSyntaxException {
            throw new UnsupportedOperationException("dissolve called on empty enchantment category entry");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    private boolean exclude;

    public static void deserializeCategoryEntry(ResourceLocation enchantment, EnchantmentHolder holder, JsonElement jsonElement) throws JsonSyntaxException {
        String item;
        boolean exclude = false;
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject1 = jsonElement.getAsJsonObject();
            item = GsonHelper.m_13906_((JsonObject)jsonObject1, (String)"id");
            exclude = GsonHelper.m_13912_((JsonObject)jsonObject1, (String)"exclude");
        } else {
            item = GsonHelper.m_13805_((JsonElement)jsonElement, (String)"item");
        }
        try {
            TypeEntry entry = item.startsWith("$") ? CategoryEntry.deserialize(enchantment, item) : (item.startsWith("#") ? TagEntry.deserialize(enchantment, item) : ItemEntry.deserialize(enchantment, item));
            entry.setExclude(exclude);
            holder.submit(entry);
        }
        catch (Exception e) {
            UniversalEnchants.LOGGER.warn("Failed to deserialize {} enchantment config entry {}: {}", (Object)enchantment, (Object)item, (Object)e);
        }
    }

    @Override
    public final void serialize(JsonArray jsonArray) {
        if (!this.exclude) {
            jsonArray.add(this.serialize());
        } else {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", this.serialize());
            jsonObject.addProperty("exclude", Boolean.valueOf(true));
            jsonArray.add((JsonElement)jsonObject);
        }
    }

    abstract String serialize();

    public boolean isEmpty() {
        return false;
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public void setExclude(boolean exclude) {
        this.exclude = exclude;
    }

    public static class CategoryEntry
    extends TypeEntry {
        private final EnchantmentCategory category;

        CategoryEntry(EnchantmentCategory category) {
            this.category = category;
        }

        @Override
        public void dissolve(Set<Item> items) throws JsonSyntaxException {
            for (Item item : BuiltInRegistries.f_257033_) {
                if (!this.category.m_7454_(item)) continue;
                items.add(item);
            }
        }

        @Override
        String serialize() {
            Objects.requireNonNull(this.category, "category is null");
            ResourceLocation identifier = (ResourceLocation)BuiltInEnchantmentDataManager.INSTANCE.getEnchantmentCategoriesIdMap().get((Object)this.category);
            Objects.requireNonNull(identifier, "identifier for category %s is null".formatted(this.category));
            return "$" + identifier;
        }

        public static TypeEntry deserialize(ResourceLocation enchantment, String s) throws JsonSyntaxException {
            if (s.startsWith("$")) {
                s = s.substring(1);
            }
            ResourceLocation id = new ResourceLocation(s);
            EnchantmentCategory category = (EnchantmentCategory)BuiltInEnchantmentDataManager.INSTANCE.getEnchantmentCategoriesIdMap().inverse().get((Object)id);
            if (category == null) {
                JsonSyntaxException e = new JsonSyntaxException("No category with name %s found".formatted(id));
                UniversalEnchants.LOGGER.warn("Failed to deserialize {} enchantment config entry {}: {}", (Object)enchantment, (Object)id, (Object)e);
                return EMPTY;
            }
            return new CategoryEntry(category);
        }
    }

    public static class TagEntry
    extends TypeEntry {
        private final TagKey<Item> tag;

        TagEntry(TagKey<Item> tag) {
            this.tag = tag;
        }

        @Override
        public void dissolve(Set<Item> items) throws JsonSyntaxException {
            for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(this.tag)) {
                items.add((Item)holder.m_203334_());
            }
        }

        @Override
        String serialize() {
            return "#" + this.tag.f_203868_();
        }

        public static TypeEntry deserialize(ResourceLocation enchantment, String s) throws JsonSyntaxException {
            ResourceLocation id;
            TagKey tag;
            if (s.startsWith("#")) {
                s = s.substring(1);
            }
            if (BuiltInRegistries.f_257033_.m_203431_(tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)(id = new ResourceLocation(s)))).isEmpty()) {
                JsonSyntaxException e = new JsonSyntaxException("No tag with name %s found".formatted(id));
                UniversalEnchants.LOGGER.warn("Failed to deserialize {} enchantment config entry {}: {}", (Object)enchantment, (Object)id, (Object)e);
                return EMPTY;
            }
            return new TagEntry((TagKey<Item>)tag);
        }
    }

    public static class ItemEntry
    extends TypeEntry {
        private final Item item;

        ItemEntry(Item item) {
            this.item = item;
        }

        @Override
        public void dissolve(Set<Item> items) throws JsonSyntaxException {
            items.add(this.item);
        }

        @Override
        String serialize() {
            return BuiltInRegistries.f_257033_.m_7981_((Object)this.item).toString();
        }

        public static TypeEntry deserialize(ResourceLocation enchantment, String s) throws JsonSyntaxException {
            ResourceLocation id = new ResourceLocation(s);
            if (!BuiltInRegistries.f_257033_.m_7804_(id)) {
                JsonSyntaxException e = new JsonSyntaxException("No item with name %s found".formatted(id));
                UniversalEnchants.LOGGER.warn("Failed to deserialize {} enchantment config entry {}: {}", (Object)enchantment, (Object)id, (Object)e);
                return EMPTY;
            }
            return new ItemEntry((Item)BuiltInRegistries.f_257033_.m_7745_(id));
        }
    }
}

