/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.world.item.enchantment.serialize.entry;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonSyntaxException;
import fuzs.universalenchants.UniversalEnchants;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.DataEntry;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;

public class IncompatibleEntry
extends DataEntry<Enchantment> {
    public final Set<Enchantment> incompatibles = Sets.newHashSet();

    @Override
    public void dissolve(Set<Enchantment> items) throws JsonSyntaxException {
        items.addAll(this.incompatibles);
    }

    @Override
    public void serialize(JsonArray jsonArray) {
        for (Enchantment enchantment : this.incompatibles) {
            jsonArray.add(BuiltInRegistries.f_256876_.m_7981_((Object)enchantment).toString());
        }
    }

    public static IncompatibleEntry deserialize(ResourceLocation enchantment, String ... items) throws JsonSyntaxException {
        IncompatibleEntry entry = new IncompatibleEntry();
        for (String item : items) {
            ResourceLocation id = new ResourceLocation(item);
            if (!BuiltInRegistries.f_256876_.m_7804_(id)) {
                JsonSyntaxException e = new JsonSyntaxException("No enchantment with name %s found".formatted(id));
                UniversalEnchants.LOGGER.warn("Failed to deserialize {} enchantment config entry {}: {}", (Object)enchantment, (Object)item, (Object)e);
                continue;
            }
            entry.incompatibles.add((Enchantment)BuiltInRegistries.f_256876_.m_7745_(id));
        }
        return entry;
    }
}

