/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.world.item.enchantment.serialize;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import fuzs.puzzleslib.api.config.v3.json.JsonConfigFileUtil;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.universalenchants.UniversalEnchants;
import fuzs.universalenchants.world.item.enchantment.data.AdditionalEnchantmentDataProvider;
import fuzs.universalenchants.world.item.enchantment.serialize.EnchantmentHolder;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.DataEntry;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.IncompatibleEntry;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.TypeEntry;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentHoldersManager {
    private static final int SCHEMA_VERSION = 2;
    private static final Map<Enchantment, EnchantmentHolder> ENCHANTMENT_DATA_HOLDERS = Maps.newIdentityHashMap();

    public static boolean isCompatibleWith(Enchantment enchantment, Enchantment other, boolean fallback) {
        return EnchantmentHoldersManager.getEnchantmentHolder(enchantment).isCompatibleWith(other, fallback) && EnchantmentHoldersManager.getEnchantmentHolder(other).isCompatibleWith(enchantment, fallback);
    }

    public static void loadAll() {
        ENCHANTMENT_DATA_HOLDERS.values().forEach(EnchantmentHolder::invalidate);
        Path modConfigPath = ModLoaderEnvironment.INSTANCE.getConfigDirectory().resolve("universalenchants");
        JsonConfigFileUtil.mkdirs((File)modConfigPath.toFile());
        for (Map.Entry<Enchantment, List<DataEntry<?>>> entry : AdditionalEnchantmentDataProvider.INSTANCE.getEnchantmentDataEntries().entrySet()) {
            ResourceLocation id = BuiltInRegistries.f_256876_.m_7981_((Object)entry.getKey());
            Path configRootPath = modConfigPath.resolve(id.m_135827_());
            JsonConfigFileUtil.mkdirs((File)configRootPath.toFile());
            String fileName = id.m_135815_() + ".json";
            Path configFilePath = configRootPath.resolve(fileName);
            File configFile = configFilePath.toFile();
            EnchantmentHolder holder = EnchantmentHoldersManager.getEnchantmentHolder(entry.getKey());
            holder.ensureInvalidated();
            if (EnchantmentHoldersManager.loadFromFile(holder, configFilePath, configFile)) continue;
            if (JsonConfigFileUtil.saveToFile((File)configFile, (JsonElement)EnchantmentHoldersManager.serializeDataEntry((Collection)entry.getValue()))) {
                UniversalEnchants.LOGGER.info("Created new enchantment config file for {} in config directory", (Object)holder.id());
            }
            holder.initializeCategoryEntries();
            holder.submitAll((Collection)entry.getValue());
        }
        ENCHANTMENT_DATA_HOLDERS.values().forEach(EnchantmentHolder::applyEnchantmentCategory);
    }

    private static EnchantmentHolder getEnchantmentHolder(Enchantment enchantment) {
        return ENCHANTMENT_DATA_HOLDERS.computeIfAbsent(enchantment, EnchantmentHolder::new);
    }

    private static boolean loadFromFile(EnchantmentHolder holder, Path configFilePath, File configFile) {
        if (configFile.exists()) {
            boolean bl;
            FileReader reader = new FileReader(configFile);
            try {
                EnchantmentHoldersManager.deserializeDataEntry(holder, reader);
                UniversalEnchants.LOGGER.debug("Read enchantment config file for {} in config directory", (Object)holder.id());
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (JsonSyntaxException | IOException e) {
                    UniversalEnchants.LOGGER.error("Failed to read enchantment config file for {} in config directory: {}", (Object)holder.id(), (Object)e);
                    try {
                        Files.move(configFilePath, configFilePath.getParent().resolve(configFilePath.getFileName() + ".bak"), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            reader.close();
            return bl;
        }
        return false;
    }

    private static void deserializeDataEntry(EnchantmentHolder holder, FileReader reader) throws JsonSyntaxException {
        JsonElement jsonElement = (JsonElement)JsonConfigFileUtil.GSON.fromJson((Reader)reader, JsonElement.class);
        JsonObject jsonObject = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"enchantment config");
        int schemaVersion = GsonHelper.m_13927_((JsonObject)jsonObject, (String)"schemaVersion");
        if (schemaVersion != 2) {
            throw new JsonSyntaxException("Invalid config file schema %s (current format is %s) for enchantment %s".formatted(schemaVersion, 2, holder.id()));
        }
        if (jsonObject.has("items")) {
            holder.initializeCategoryEntries();
            JsonArray items = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"items");
            for (JsonElement itemElement : items) {
                TypeEntry.deserializeCategoryEntry(holder.id(), holder, itemElement);
            }
        }
        if (jsonObject.has("incompatible")) {
            JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"incompatible");
            String[] incompatibles = (String[])JsonConfigFileUtil.GSON.fromJson((JsonElement)jsonArray, String[].class);
            holder.submit(IncompatibleEntry.deserialize(holder.id(), incompatibles));
        }
    }

    private static JsonElement serializeDataEntry(Collection<DataEntry<?>> entries) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("schemaVersion", (Number)2);
        JsonArray jsonArray = new JsonArray();
        JsonArray jsonArray1 = new JsonArray();
        for (DataEntry<?> entry : entries) {
            if (entry instanceof TypeEntry) {
                entry.serialize(jsonArray);
                continue;
            }
            if (!(entry instanceof IncompatibleEntry)) continue;
            entry.serialize(jsonArray1);
        }
        jsonObject.add("items", (JsonElement)jsonArray);
        jsonObject.add("incompatible", (JsonElement)jsonArray1);
        return jsonObject;
    }
}

