/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.world.item.enchantment.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import fuzs.universalenchants.core.CommonAbstractions;
import fuzs.universalenchants.world.item.enchantment.serialize.entry.DataEntry;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.DamageEnchantment;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;

public class AdditionalEnchantmentDataProvider {
    static final String ENCHANTMENT_CATEGORY_PREFIX = "Universal Enchants".toUpperCase(Locale.ROOT).replace(" ", "_") + "_";
    public static final EnchantmentCategory AXE_ENCHANTMENT_CATEGORY = CommonAbstractions.INSTANCE.createEnchantmentCategory(ENCHANTMENT_CATEGORY_PREFIX + "AXE", item -> item instanceof AxeItem);
    public static final EnchantmentCategory HORSE_ARMOR_ENCHANTMENT_CATEGORY = CommonAbstractions.INSTANCE.createEnchantmentCategory(ENCHANTMENT_CATEGORY_PREFIX + "HORSE_ARMOR", item -> item instanceof HorseArmorItem);
    public static final EnchantmentCategory SHIELD_ENCHANTMENT_CATEGORY = CommonAbstractions.INSTANCE.createEnchantmentCategory(ENCHANTMENT_CATEGORY_PREFIX + "SHIELD", item -> item instanceof ShieldItem);
    public static final AdditionalEnchantmentDataProvider INSTANCE = new AdditionalEnchantmentDataProvider();
    private final List<AdditionalEnchantmentsData> additionalEnchantmentsData = ImmutableList.of((Object)new AdditionalEnchantmentsData(EnchantmentCategory.WEAPON, Enchantments.f_44956_), (Object)new AdditionalEnchantmentsData(AXE_ENCHANTMENT_CATEGORY, Enchantments.f_44977_, Enchantments.f_44978_, Enchantments.f_44979_, Enchantments.f_44980_, Enchantments.f_44981_, Enchantments.f_44982_, Enchantments.f_44983_, Enchantments.f_44956_), (Object)new AdditionalEnchantmentsData(EnchantmentCategory.TRIDENT, Enchantments.f_44977_, Enchantments.f_44978_, Enchantments.f_44979_, Enchantments.f_44980_, Enchantments.f_44981_, Enchantments.f_44982_, Enchantments.f_44983_, Enchantments.f_44960_, Enchantments.f_44961_), (Object)new AdditionalEnchantmentsData(EnchantmentCategory.BOW, Enchantments.f_44961_, Enchantments.f_44959_, Enchantments.f_44960_, Enchantments.f_44982_), (Object)new AdditionalEnchantmentsData(EnchantmentCategory.CROSSBOW, Enchantments.f_44990_, Enchantments.f_44989_, Enchantments.f_44988_, Enchantments.f_44952_, Enchantments.f_44982_), (Object)new AdditionalEnchantmentsData(HORSE_ARMOR_ENCHANTMENT_CATEGORY, Enchantments.f_44965_, Enchantments.f_44966_, Enchantments.f_44967_, Enchantments.f_44968_, Enchantments.f_44969_, Enchantments.f_44970_, Enchantments.f_44972_, Enchantments.f_44973_, Enchantments.f_44974_, Enchantments.f_44975_, Enchantments.f_44976_, Enchantments.f_44963_), (Object)new AdditionalEnchantmentsData(SHIELD_ENCHANTMENT_CATEGORY, Enchantments.f_44972_, Enchantments.f_44980_));
    private Map<Enchantment, List<DataEntry<?>>> defaultCategoryEntries;

    private AdditionalEnchantmentDataProvider() {
    }

    public void initialize() {
    }

    public Map<Enchantment, List<DataEntry<?>>> getEnchantmentDataEntries() {
        if (this.defaultCategoryEntries == null) {
            Map<Enchantment, DataEntry.Builder> builders = BuiltInRegistries.f_256876_.m_123024_().collect(Collectors.toMap(Function.identity(), CommonAbstractions.INSTANCE::defaultEnchantmentDataBuilder));
            this.additionalEnchantmentsData.forEach(data -> data.addToBuilder(builders));
            AdditionalEnchantmentDataProvider.setupAdditionalCompatibility(builders);
            this.defaultCategoryEntries = (Map)builders.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, e -> ((DataEntry.Builder)e.getValue()).build()));
        }
        return this.defaultCategoryEntries;
    }

    private static void setupAdditionalCompatibility(Map<Enchantment, DataEntry.Builder> builders) {
        AdditionalEnchantmentDataProvider.applyIncompatibilityToBoth(builders, Enchantments.f_44952_, Enchantments.f_44962_, false);
        AdditionalEnchantmentDataProvider.applyIncompatibilityToBoth(builders, Enchantments.f_44959_, Enchantments.f_44961_, false);
        for (Enchantment enchantment : BuiltInRegistries.f_256876_) {
            if (enchantment instanceof DamageEnchantment && enchantment != Enchantments.f_44977_) {
                AdditionalEnchantmentDataProvider.applyIncompatibilityToBoth(builders, Enchantments.f_44977_, enchantment, false);
                AdditionalEnchantmentDataProvider.applyIncompatibilityToBoth(builders, Enchantments.f_44956_, enchantment, true);
            }
            if (!(enchantment instanceof ProtectionEnchantment) || enchantment == Enchantments.f_44965_ || enchantment == Enchantments.f_44967_) continue;
            AdditionalEnchantmentDataProvider.applyIncompatibilityToBoth(builders, Enchantments.f_44965_, enchantment, false);
        }
    }

    private static void applyIncompatibilityToBoth(Map<Enchantment, DataEntry.Builder> builders, Enchantment enchantment, Enchantment other, boolean add) {
        BiConsumer<Enchantment, Enchantment> operation = (e1, e2) -> {
            DataEntry.Builder builder = (DataEntry.Builder)builders.get(e1);
            if (builder == null) {
                return;
            }
            if (add) {
                builder.add((Enchantment)e2);
            } else {
                builder.remove((Enchantment)e2);
            }
        };
        operation.accept(enchantment, other);
        operation.accept(other, enchantment);
    }

    private record AdditionalEnchantmentsData(EnchantmentCategory category, List<Enchantment> enchantments) {
        AdditionalEnchantmentsData(EnchantmentCategory category, Enchantment ... enchantments) {
            this(category, (List<Enchantment>)ImmutableList.copyOf((Object[])enchantments));
        }

        public void addToBuilder(Map<Enchantment, DataEntry.Builder> builders) {
            for (Enchantment enchantment : this.enchantments) {
                if (!builders.containsKey(enchantment)) continue;
                builders.get(enchantment).add(this.category);
            }
        }
    }
}

