/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import fuzs.universalenchants.UniversalEnchants;
import fuzs.universalenchants.config.CommonConfig;
import java.util.Collection;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;

public class ModEnchantCommand {
    private static final DynamicCommandExceptionType ERROR_NOT_LIVING_ENTITY = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"commands.enchant.failed.entity", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_NO_ITEM = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"commands.enchant.failed.itemless", (Object[])new Object[]{object}));
    private static final DynamicCommandExceptionType ERROR_INCOMPATIBLE = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"commands.enchant.failed.incompatible", (Object[])new Object[]{object}));
    private static final Dynamic2CommandExceptionType ERROR_LEVEL_TOO_HIGH = new Dynamic2CommandExceptionType((object, object2) -> Component.m_237110_((String)"commands.enchant.failed.level", (Object[])new Object[]{object, object2}));
    private static final SimpleCommandExceptionType ERROR_NOTHING_HAPPENED = new SimpleCommandExceptionType((Message)Component.m_237115_((String)"commands.enchant.failed"));

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher, CommandBuildContext context) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"enchant").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(Commands.m_82129_((String)"enchantment", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256762_)).executes(commandContext -> ModEnchantCommand.enchant((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91461_((CommandContext)commandContext, (String)"targets"), (Holder<Enchantment>)ResourceArgument.m_245369_((CommandContext)commandContext, (String)"enchantment"), 0)))))).then(Commands.m_82127_((String)"add").then(Commands.m_82129_((String)"targets", (ArgumentType)EntityArgument.m_91460_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"enchantment", (ArgumentType)ResourceArgument.m_247102_((CommandBuildContext)context, (ResourceKey)Registries.f_256762_)).executes(commandContext -> ModEnchantCommand.enchant((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91461_((CommandContext)commandContext, (String)"targets"), (Holder<Enchantment>)ResourceArgument.m_245369_((CommandContext)commandContext, (String)"enchantment")))).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)255)).executes(commandContext -> ModEnchantCommand.enchant((CommandSourceStack)commandContext.getSource(), EntityArgument.m_91461_((CommandContext)commandContext, (String)"targets"), (Holder<Enchantment>)ResourceArgument.m_245369_((CommandContext)commandContext, (String)"enchantment"), IntegerArgumentType.getInteger((CommandContext)commandContext, (String)"level"))))))));
    }

    private static int enchant(CommandSourceStack commandSourceStack, Collection<? extends Entity> collection, Holder<Enchantment> holder) throws CommandSyntaxException {
        return ModEnchantCommand.enchant(commandSourceStack, collection, holder, ((Enchantment)holder.m_203334_()).m_6586_());
    }

    private static int enchant(CommandSourceStack commandSourceStack, Collection<? extends Entity> collection, Holder<Enchantment> holder, int level) throws CommandSyntaxException {
        Enchantment enchantment = (Enchantment)holder.m_203334_();
        if (!((CommonConfig)UniversalEnchants.CONFIG.get(CommonConfig.class)).enchantCommand.removeMaxLevelLimit && level > enchantment.m_6586_()) {
            throw ERROR_LEVEL_TOO_HIGH.create((Object)level, (Object)enchantment.m_6586_());
        }
        if (level > 255) {
            throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.integerTooHigh().create((Object)level, (Object)255);
        }
        int successes = 0;
        for (Entity entity : collection) {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                ItemStack itemStack = livingEntity.m_21205_();
                if (!itemStack.m_41619_()) {
                    if (((CommonConfig)UniversalEnchants.CONFIG.get(CommonConfig.class)).enchantCommand.fixEnchantCommand) {
                        ItemStack stack = itemStack;
                        if (stack.m_41613_() == 1 && stack.m_150930_(Items.f_42517_)) {
                            stack = new ItemStack((ItemLike)Items.f_42690_);
                            CompoundTag compoundTag = itemStack.m_41783_();
                            if (compoundTag != null) {
                                stack.m_41751_(compoundTag.m_6426_());
                            }
                        }
                        if ((stack.m_150930_(Items.f_42690_) || enchantment.m_6081_(stack)) && EnchantmentHelper.m_44859_(EnchantmentHelper.m_44831_((ItemStack)stack).keySet().stream().filter(e -> e != enchantment).toList(), (Enchantment)enchantment)) {
                            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
                            if (level > 0) {
                                Integer oldLevel = enchantments.put(enchantment, level);
                                if (oldLevel != null && oldLevel == level && collection.size() == 1) {
                                    throw ERROR_INCOMPATIBLE.create((Object)itemStack.m_41720_().m_7626_(itemStack).getString());
                                }
                            } else {
                                enchantments.remove(enchantment);
                            }
                            ModEnchantCommand.setEnchantments(enchantments, stack);
                            if (stack.m_150930_(Items.f_42690_) && enchantments.isEmpty()) {
                                stack = new ItemStack((ItemLike)Items.f_42517_);
                                CompoundTag compoundTag = itemStack.m_41783_();
                                if (compoundTag != null) {
                                    stack.m_41751_(compoundTag.m_6426_());
                                }
                            }
                            livingEntity.m_21008_(InteractionHand.MAIN_HAND, stack);
                            ++successes;
                            continue;
                        }
                        if (collection.size() != 1) continue;
                        throw ERROR_INCOMPATIBLE.create((Object)itemStack.m_41720_().m_7626_(itemStack).getString());
                    }
                    if (enchantment.m_6081_(itemStack) && EnchantmentHelper.m_44859_(EnchantmentHelper.m_44831_((ItemStack)itemStack).keySet(), (Enchantment)enchantment)) {
                        itemStack.m_41663_(enchantment, level);
                        ++successes;
                        continue;
                    }
                    if (collection.size() != 1) continue;
                    throw ERROR_INCOMPATIBLE.create((Object)itemStack.m_41720_().m_7626_(itemStack).getString());
                }
                if (collection.size() != 1) continue;
                throw ERROR_NO_ITEM.create((Object)livingEntity.m_7755_().getString());
            }
            if (collection.size() != 1) continue;
            throw ERROR_NOT_LIVING_ENTITY.create((Object)entity.m_7755_().getString());
        }
        if (successes == 0) {
            throw ERROR_NOTHING_HAPPENED.create();
        }
        if (collection.size() == 1) {
            commandSourceStack.m_288197_(() -> level > 0 || !((CommonConfig)UniversalEnchants.CONFIG.get(CommonConfig.class)).enchantCommand.fixEnchantCommand ? Component.m_237110_((String)"commands.enchant.success.single", (Object[])new Object[]{enchantment.m_44700_(level), ((Entity)collection.iterator().next()).m_5446_()}) : Component.m_237110_((String)"commands.enchant.remove.success.single", (Object[])new Object[]{ModEnchantCommand.getEnchantmentName(enchantment), ((Entity)collection.iterator().next()).m_5446_()}), true);
        } else {
            commandSourceStack.m_288197_(() -> level > 0 || !((CommonConfig)UniversalEnchants.CONFIG.get(CommonConfig.class)).enchantCommand.fixEnchantCommand ? Component.m_237110_((String)"commands.enchant.success.multiple", (Object[])new Object[]{enchantment.m_44700_(level), collection.size()}) : Component.m_237110_((String)"commands.enchant.remove.success.multiple", (Object[])new Object[]{ModEnchantCommand.getEnchantmentName(enchantment), collection.size()}), true);
        }
        return successes;
    }

    private static void setEnchantments(Map<Enchantment, Integer> map, ItemStack itemStack) {
        String enchantmentsKey;
        ListTag list = new ListTag();
        for (Map.Entry<Enchantment, Integer> entry : map.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            list.add((Object)EnchantmentHelper.m_182443_((ResourceLocation)EnchantmentHelper.m_182432_((Enchantment)enchantment), (int)entry.getValue()));
        }
        String string = enchantmentsKey = itemStack.m_150930_(Items.f_42690_) ? "StoredEnchantments" : "Enchantments";
        if (list.isEmpty()) {
            itemStack.m_41749_(enchantmentsKey);
        } else {
            itemStack.m_41700_(enchantmentsKey, (Tag)list);
        }
    }

    private static Component getEnchantmentName(Enchantment enchantment) {
        MutableComponent mutableComponent = Component.m_237115_((String)enchantment.m_44704_());
        if (enchantment.m_6589_()) {
            mutableComponent.m_130940_(ChatFormatting.RED);
        } else {
            mutableComponent.m_130940_(ChatFormatting.GRAY);
        }
        return mutableComponent;
    }
}

