/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.mixin;

import fuzs.universalenchants.core.CommonAbstractions;
import fuzs.universalenchants.handler.ItemCompatHandler;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CrossbowItem.class})
public abstract class CrossbowItemMixin
extends ProjectileWeaponItem {
    public CrossbowItemMixin(Item.Properties builder) {
        super(builder);
    }

    @ModifyVariable(method={"tryLoadProjectiles"}, at=@At(value="STORE"), ordinal=0)
    private static boolean tryLoadProjectiles$storeHasInfiniteAmmo(boolean hasInfiniteAmmo, LivingEntity entityIn, ItemStack stack) {
        if (hasInfiniteAmmo) {
            return true;
        }
        ItemStack arrowStack = entityIn.m_6298_(stack);
        if (arrowStack.m_41619_() || CommonAbstractions.INSTANCE.isArrowInfinite(entityIn, stack, arrowStack)) {
            return EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
        }
        return false;
    }

    @Inject(method={"getArrow"}, at={@At(value="TAIL")})
    private static void getArrow$tail(Level level, LivingEntity entity, ItemStack stack, ItemStack arrowStack, CallbackInfoReturnable<AbstractArrow> callback) {
        AbstractArrow abstractarrowentity = (AbstractArrow)callback.getReturnValue();
        ItemCompatHandler.applyPowerEnchantment(abstractarrowentity, stack);
        ItemCompatHandler.applyPunchEnchantment(abstractarrowentity, stack);
        ItemCompatHandler.applyFlameEnchantment(abstractarrowentity, stack);
        ItemCompatHandler.applyLootingEnchantment(abstractarrowentity, stack);
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0 && CommonAbstractions.INSTANCE.isArrowInfinite(entity, stack, arrowStack)) {
            abstractarrowentity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        }
    }
}

