/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalenchants.client.resources.language;

import com.google.common.collect.Maps;
import fuzs.universalenchants.UniversalEnchants;
import fuzs.universalenchants.config.ClientConfig;
import fuzs.universalenchants.mixin.client.accessor.I18nAccessor;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.minecraft.Util;
import net.minecraft.client.resources.language.ClientLanguage;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class NumericClientLanguage
extends Language {
    private static final TreeMap<Integer, String> ROMAN_NUMERALS = (TreeMap)Util.m_137469_((Object)Maps.newTreeMap(), map -> {
        map.put(1000, "M");
        map.put(900, "CM");
        map.put(500, "D");
        map.put(400, "CD");
        map.put(100, "C");
        map.put(90, "XC");
        map.put(50, "L");
        map.put(40, "XL");
        map.put(10, "X");
        map.put(9, "IX");
        map.put(5, "V");
        map.put(4, "IV");
        map.put(1, "I");
    });
    private final Language language;
    private final Map<String, String> numeralsCache = Maps.newHashMap();

    public NumericClientLanguage(Language language) {
        this.language = language;
    }

    public static void injectLanguage(NumericClientLanguage numericLanguage) {
        if (((ClientConfig)UniversalEnchants.CONFIG.get(ClientConfig.class)).fixRomanNumerals == ClientConfig.NumeralLanguage.NONE) {
            return;
        }
        if (numericLanguage.language instanceof ClientLanguage) {
            I18nAccessor.universalenchants$callSetLanguage(numericLanguage);
            Language.m_128114_((Language)numericLanguage);
        }
    }

    public String m_118919_(String string, String fallback) {
        if ((fallback == null || Objects.equals(string, fallback)) && this.isNumeral(string)) {
            return this.numeralsCache.computeIfAbsent(string, this::computeLanguageNumeral);
        }
        return this.language.m_118919_(string, fallback);
    }

    private boolean isNumeral(String string) {
        return string.startsWith("potion.potency.") || string.startsWith("enchantment.level.");
    }

    private String computeLanguageNumeral(String translationKey) {
        if (!this.language.m_6722_(translationKey) || ((ClientConfig)UniversalEnchants.CONFIG.get(ClientConfig.class)).fixRomanNumerals == ClientConfig.NumeralLanguage.ARABIC) {
            String number = translationKey.substring(translationKey.lastIndexOf(".") + 1);
            if (number.chars().allMatch(Character::isDigit)) {
                int intNumber = Integer.parseInt(number);
                if (translationKey.startsWith("potion.potency.")) {
                    ++intNumber;
                }
                return this.toNumeral(intNumber);
            }
            return translationKey;
        }
        return this.language.m_6834_(translationKey);
    }

    private String toNumeral(int number) {
        if (number > 0 && number < 4000 && ((ClientConfig)UniversalEnchants.CONFIG.get(ClientConfig.class)).fixRomanNumerals == ClientConfig.NumeralLanguage.ROMAN) {
            return NumericClientLanguage.toRomanNumeral(number);
        }
        return String.valueOf(number);
    }

    private static String toRomanNumeral(int number) {
        int l = ROMAN_NUMERALS.floorKey(number);
        if (number == l) {
            return ROMAN_NUMERALS.get(number);
        }
        return ROMAN_NUMERALS.get(l) + NumericClientLanguage.toRomanNumeral(number - l);
    }

    public boolean m_6722_(String string) {
        if (this.language.m_6722_(string)) {
            return true;
        }
        return this.isNumeral(string);
    }

    public boolean m_6627_() {
        return this.language.m_6627_();
    }

    public FormattedCharSequence m_5536_(FormattedText formattedText) {
        return this.language.m_5536_(formattedText);
    }
}

