/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.structure;

import com.robertx22.dungeon_realm.configs.DungeonConfig;
import com.robertx22.dungeon_realm.database.DungeonDatabase;
import com.robertx22.dungeon_realm.database.dungeon.Dungeon;
import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.library_of_exile.dimension.MapGenerationUTIL;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonBuilder;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonStructure;
import com.robertx22.library_of_exile.dimension.structure.dungeon.IDungeon;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class DungeonMapStructure
extends DungeonStructure {
    public static int DUNGEON_LENGTH = 30;

    public String guid() {
        return "dungeon";
    }

    public DungeonBuilder getMap(ChunkPos cp) {
        ServerLevel serverLevel = DungeonMain.server.m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DungeonMain.DIMENSION_KEY));
        AtomicReference mapDungeon = new AtomicReference();
        ChunkPos start = this.getStartChunkPos(cp);
        DungeonMain.ifMapData((Level)serverLevel, cp.m_151394_(5)).ifPresentOrElse(x -> mapDungeon.set(x.dungeon), () -> {
            Random rand = MapGenerationUTIL.createRandom((ChunkPos)start);
            String randomDungeon = ((Dungeon)RandomUtils.weightedRandom((Collection)DungeonDatabase.Dungeons().getFilterWrapped((Predicate<Dungeon>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getMap$1(com.robertx22.dungeon_realm.database.dungeon.Dungeon ), (Lcom/robertx22/dungeon_realm/database/dungeon/Dungeon;)Z)()).list, (double)rand.nextDouble())).id;
            mapDungeon.set(randomDungeon);
        });
        DungeonBuilder b = new DungeonBuilder(DungeonMapStructure.dungeonSettings(start, (String)mapDungeon.get()));
        return b;
    }

    public static DungeonBuilder.Settings dungeonSettings(ChunkPos pos, String mapDungeon) {
        Random rand = MapGenerationUTIL.createRandom((ChunkPos)pos);
        ArrayList dungeons = new ArrayList(DungeonDatabase.Dungeons().getFilterWrapped((Predicate<Dungeon>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$dungeonSettings$3(com.robertx22.dungeon_realm.database.dungeon.Dungeon ), (Lcom/robertx22/dungeon_realm/database/dungeon/Dungeon;)Z)()).list);
        Optional<Dungeon> dungeon = dungeons.stream().filter(x -> x.id.equals(mapDungeon)).findFirst();
        IDungeon mapFinalDungeon = dungeon.orElseGet(() -> (Dungeon)RandomUtils.weightedRandom((Collection)dungeons, (double)rand.nextDouble()));
        DungeonBuilder.Settings settings = new DungeonBuilder.Settings(rand, ((Integer)DungeonConfig.get().MIN_MAP_ROOMS.get()).intValue(), ((Integer)DungeonConfig.get().MAX_MAP_ROOMS.get()).intValue(), mapFinalDungeon);
        return settings;
    }

    public ChunkPos getStartFromCounter(int x, int z) {
        ChunkPos start = new ChunkPos(x * DUNGEON_LENGTH, z * DUNGEON_LENGTH);
        start = this.getStartChunkPos(start);
        return start;
    }

    public int getSpawnHeight() {
        return 50;
    }

    protected ChunkPos INTERNALgetStartChunkPos(ChunkPos cp) {
        int chunkX = cp.f_45578_;
        int chunkZ = cp.f_45579_;
        int distToEntranceX = 11 - chunkX % DUNGEON_LENGTH;
        int distToEntranceZ = 11 - chunkZ % DUNGEON_LENGTH;
        return new ChunkPos(chunkX += distToEntranceX, chunkZ += distToEntranceZ);
    }

    private static /* synthetic */ boolean lambda$dungeonSettings$3(Dungeon x) {
        return true;
    }

    private static /* synthetic */ boolean lambda$getMap$1(Dungeon i) {
        return true;
    }
}

