/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.block_entity;

import com.robertx22.dungeon_realm.block_entity.MapDeviceMenu;
import com.robertx22.dungeon_realm.item.relic.RelicAffixData;
import com.robertx22.dungeon_realm.item.relic.RelicItemData;
import com.robertx22.dungeon_realm.main.DungeonWords;
import com.robertx22.library_of_exile.database.relic.stat.ExactRelicStat;
import com.robertx22.library_of_exile.database.relic.stat.RelicMod;
import com.robertx22.library_of_exile.database.relic.stat.RelicStat;
import com.robertx22.library_of_exile.database.relic.stat.RelicStatsContainer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;

public class MapDeviceScreen
extends AbstractContainerScreen<MapDeviceMenu>
implements MenuAccess<MapDeviceMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = new ResourceLocation("textures/gui/container/generic_54.png");
    private final int containerRows;
    private final int LINE_HEIGHT = 11;

    public MapDeviceScreen(MapDeviceMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        int i = 222;
        int j = 114;
        this.containerRows = 3;
        this.f_97727_ = 114 + this.containerRows * 18;
        this.f_97731_ = this.f_97727_ - 94;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(0.0f, 0.0f, 399.0f);
        this.renderRelicStats(pGuiGraphics);
        pGuiGraphics.m_280168_().m_85849_();
    }

    private void renderRelicStats(GuiGraphics pGuiGraphics) {
        boolean detailedMode = Screen.m_96638_();
        if (detailedMode) {
            this.drawRelicsInfo(pGuiGraphics);
        } else {
            this.drawHint(pGuiGraphics);
        }
    }

    private void drawHint(GuiGraphics pGuiGraphics) {
        MutableComponent shiftText = Component.m_237113_((String)"<SHIFT>").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD});
        MutableComponent hintText = DungeonWords.SHOW_RELIC_STATS_HINT.get(shiftText).m_130940_(ChatFormatting.GREEN);
        Font minecraftFont = Minecraft.m_91087_().f_91062_;
        int textWidth = minecraftFont.m_92852_((FormattedText)hintText);
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        pGuiGraphics.m_280430_(minecraftFont, (Component)hintText, startX + this.f_97726_ - textWidth, startY - 11, 0xFFFFFF);
    }

    public void drawRelicsInfo(GuiGraphics pGuiGraphics) {
        List<RelicItemData> relics = ((MapDeviceMenu)this.f_97732_).getRelics();
        if (relics.isEmpty()) {
            return;
        }
        Map<String, RelicStatWithValue> mappedGroupedRelicStats = MapDeviceScreen.getRelicStatWithValueMap(relics);
        List<String> sortedKeys = mappedGroupedRelicStats.keySet().stream().sorted(Comparator.comparingDouble(i -> ((RelicStatWithValue)mappedGroupedRelicStats.get((Object)i)).value.floatValue())).toList();
        Font minecraftFont = Minecraft.m_91087_().f_91062_;
        int maxLineWidth = 0;
        ArrayList<Component> lines = new ArrayList<Component>();
        for (int i2 = sortedKeys.size() - 1; i2 >= 0; --i2) {
            RelicStatWithValue relicStatWithValue = mappedGroupedRelicStats.get(sortedKeys.get(i2));
            RelicStat stat = relicStatWithValue.stat;
            Float value = relicStatWithValue.value;
            MutableComponent statText = stat.getTooltip(value.floatValue());
            lines.add((Component)statText);
            int textWidth = minecraftFont.m_92852_((FormattedText)statText);
            maxLineWidth = Math.max(maxLineWidth, textWidth);
        }
        int startY = (this.f_96544_ - this.f_97727_) / 2;
        this.drawStatsBackground(pGuiGraphics, maxLineWidth, startY, lines.size());
        this.drawStats(pGuiGraphics, lines, minecraftFont, startY, maxLineWidth);
    }

    private void drawStatsBackground(GuiGraphics pGuiGraphics, int maxLineWidth, int startY, int size) {
        int backgroundStartX = (this.f_96543_ - this.f_97726_) / 2;
        int backgroundEndX = backgroundStartX + this.f_97726_;
        int backgroundEndY = startY + this.f_97727_;
        if (maxLineWidth > this.f_97726_) {
            backgroundStartX -= (maxLineWidth - this.f_97726_) / 2;
            backgroundEndX += (maxLineWidth - this.f_97726_) / 2;
        }
        if (size * 11 > this.f_97726_) {
            backgroundEndY = startY + size * 11;
        }
        pGuiGraphics.m_280509_(backgroundStartX, startY, backgroundEndX, backgroundEndY, Integer.MIN_VALUE);
    }

    private void drawStats(GuiGraphics pGuiGraphics, List<Component> lines, Font minecraftFont, int startY, int maxLineWidth) {
        int y = 2;
        int startX = (this.f_96543_ - this.f_97726_) / 2;
        if (maxLineWidth > this.f_97726_) {
            startX -= (maxLineWidth - this.f_97726_) / 2;
        }
        for (Component line : lines) {
            pGuiGraphics.m_280430_(minecraftFont, line, startX, startY + y, 0xFFFFFF);
            y += 11;
        }
    }

    @NotNull
    private static Map<String, RelicStatWithValue> getRelicStatWithValueMap(List<RelicItemData> relics) {
        ArrayList<ExactRelicStat> exactRelicStats = new ArrayList<ExactRelicStat>();
        for (RelicItemData data : relics) {
            for (RelicAffixData affix : data.affixes) {
                for (RelicMod mod : affix.get().mods) {
                    exactRelicStats.add(mod.toExact(affix.p));
                }
            }
        }
        RelicStatsContainer groupedRelicStats = RelicStatsContainer.calculate(exactRelicStats);
        HashMap<String, RelicStatWithValue> mappedGroupedRelicStats = new HashMap<String, RelicStatWithValue>();
        for (ExactRelicStat exactRelicStat : exactRelicStats) {
            RelicStat stat = exactRelicStat.getStat();
            if (mappedGroupedRelicStats.containsKey(stat.id)) continue;
            mappedGroupedRelicStats.put(stat.id, new RelicStatWithValue(stat, Float.valueOf(groupedRelicStats.get(stat))));
        }
        return mappedGroupedRelicStats;
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280218_(CONTAINER_BACKGROUND, i, j, 0, 0, this.f_97726_, this.containerRows * 18 + 17);
        pGuiGraphics.m_280218_(CONTAINER_BACKGROUND, i, j + this.containerRows * 18 + 17, 0, 126, this.f_97726_, 96);
    }

    private record RelicStatWithValue(RelicStat stat, Float value) {
    }
}

