/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.block_entity;

import com.robertx22.dungeon_realm.item.DungeonItemNbt;
import com.robertx22.dungeon_realm.item.relic.RelicAffixData;
import com.robertx22.dungeon_realm.item.relic.RelicItemData;
import com.robertx22.dungeon_realm.main.DungeonEntries;
import com.robertx22.dungeon_realm.structure.DungeonMapCapability;
import com.robertx22.library_of_exile.database.relic.stat.ExactRelicStat;
import com.robertx22.library_of_exile.database.relic.stat.RelicMod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class MapDeviceBE
extends BlockEntity
implements ContainerListener {
    public boolean gaveMap = false;
    public BlockPos pos = null;
    public String currentWorldUUID = "";
    public SimpleContainer inv = new SimpleContainer(27);

    public boolean isActivated() {
        if (this.currentWorldUUID.isEmpty() || !this.currentWorldUUID.equals(DungeonMapCapability.getFromServer().data.data.uuid)) {
            return false;
        }
        return this.pos != null;
    }

    public void setGaveMap() {
        this.gaveMap = true;
        this.m_6596_();
    }

    public MapDeviceBE(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)DungeonEntries.MAP_DEVICE_BE.get(), pPos, pBlockState);
        this.inv.m_19164_((ContainerListener)this);
    }

    public List<ExactRelicStat> getAllValidRelicStats() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        ArrayList<RelicItemData> all = new ArrayList<RelicItemData>();
        for (int i = 0; i < this.inv.m_6643_(); ++i) {
            ItemStack stack = this.inv.m_8020_(i);
            try {
                if (stack.m_41619_() || !DungeonItemNbt.RELIC.has(stack)) continue;
                RelicItemData data = (RelicItemData)DungeonItemNbt.RELIC.loadFrom(stack);
                int cur = map.getOrDefault(data.type, 0) + 1;
                map.put(data.type, cur);
                if (cur <= data.getType().max_equipped) {
                    all.add(data);
                    continue;
                }
                int n = 5;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<ExactRelicStat> ex = new ArrayList<ExactRelicStat>();
        for (RelicItemData data : all) {
            for (RelicAffixData affix : data.affixes) {
                for (RelicMod mod : affix.get().mods) {
                    ex.add(mod.toExact(affix.p));
                }
            }
        }
        return ex;
    }

    protected void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("gave", this.gaveMap);
        if (this.pos != null) {
            nbt.m_128356_("spawnpos", this.pos.m_121878_());
        }
        nbt.m_128365_("inv", (Tag)this.inv.m_7927_());
        nbt.m_128359_("uid", this.currentWorldUUID);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.gaveMap = pTag.m_128471_("gave");
        if (pTag.m_128441_("spawnpos")) {
            this.pos = BlockPos.m_122022_((long)pTag.m_128454_("spawnpos"));
        }
        this.inv.m_7797_(pTag.m_128437_("inv", 10));
        this.currentWorldUUID = pTag.m_128461_("uid");
    }

    public void m_5757_(Container pContainer) {
        this.m_6596_();
    }
}

