/*
 * Decompiled with CFR 0.152.
 */
package com.baketsu.mine_and_meals.events;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mine_and_meals")
public class TooltipHandler {
    private static final Map<String, String> ENGLISH_TRANSLATIONS = new HashMap<String, String>();
    private static final Map<String, String> JAPANESE_TRANSLATIONS = new HashMap<String, String>();
    private static final Map<String, Integer> TAG_COLORS = new HashMap<String, Integer>();

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        String languageCode = TooltipHandler.getCurrentLanguage();
        stack.m_204131_().forEach(tag -> {
            if (tag.f_203868_().m_135827_().equals("mine_and_meals")) {
                String tagPath = "tag." + tag.f_203868_().m_135827_() + "." + tag.f_203868_().m_135815_();
                String translation = TooltipHandler.getTranslation(tagPath, languageCode);
                int color = TAG_COLORS.getOrDefault(tagPath, 0xFFFFFF);
                event.getToolTip().add(Component.m_237113_((String)translation).m_130938_(style -> style.m_178520_(color)));
            }
        });
    }

    private static String getTranslation(String tagPath, String languageCode) {
        if ("ja_jp".equals(languageCode)) {
            return JAPANESE_TRANSLATIONS.getOrDefault(tagPath, "\u4e0d\u660e\u306a\u30bf\u30b0: " + tagPath);
        }
        return ENGLISH_TRANSLATIONS.getOrDefault(tagPath, "Unknown Tag: " + tagPath);
    }

    private static String getCurrentLanguage() {
        return Minecraft.m_91087_().f_91066_.f_92075_ != null ? Minecraft.m_91087_().f_91066_.f_92075_ : "en_us";
    }

    static {
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.grain1_1", "\u6700\u5927\u30d8\u30eb\u30b9\u5f37\u5316(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.grain1_2", "\u6700\u5927\u30d8\u30eb\u30b9\u5f37\u5316(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.grain1_3", "\u6700\u5927\u30d8\u30eb\u30b9\u5f37\u5316(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.grain2_1", "\u6700\u5927\u30d8\u30eb\u30b9\u5f37\u5316(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.grain2_2", "\u6700\u5927\u30d8\u30eb\u30b9\u5f37\u5316(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.meat1_1", "\u30d8\u30eb\u30b9\u56de\u5fa9(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.meat1_2", "\u30d8\u30eb\u30b9\u56de\u5fa9(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.meat1_3", "\u30d8\u30eb\u30b9\u56de\u5fa9(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.meat2_1", "\u30d8\u30eb\u30b9\u56de\u5fa9(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.meat2_2", "\u30d8\u30eb\u30b9\u56de\u5fa9(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.vegetable1_1", "\u6700\u5927\u30de\u30ca\u5f37\u5316(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.vegetable1_2", "\u6700\u5927\u30de\u30ca\u5f37\u5316(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.vegetable1_3", "\u6700\u5927\u30de\u30ca\u5f37\u5316(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.vegetable2_1", "\u6700\u5927\u30de\u30ca\u5f37\u5316(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.vegetable2_2", "\u6700\u5927\u30de\u30ca\u5f37\u5316(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fruit1_1", "\u30de\u30ca\u56de\u5fa9(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fruit1_2", "\u30de\u30ca\u56de\u5fa9(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fruit1_3", "\u30de\u30ca\u56de\u5fa9(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fruit2_1", "\u30de\u30ca\u56de\u5fa9(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fruit2_2", "\u30de\u30ca\u56de\u5fa9(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fish1_1", "\u6700\u5927\u30a8\u30cd\u30eb\u30ae\u30fc\u5f37\u5316(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fish1_2", "\u6700\u5927\u30a8\u30cd\u30eb\u30ae\u30fc\u5f37\u5316(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fish1_3", "\u6700\u5927\u30a8\u30cd\u30eb\u30ae\u30fc\u5f37\u5316(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fish2_1", "\u6700\u5927\u30a8\u30cd\u30eb\u30ae\u30fc\u5f37\u5316(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fish2_2", "\u6700\u5927\u30a8\u30cd\u30eb\u30ae\u30fc\u5f37\u5316(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.dairy1_1", "\u30a8\u30cd\u30eb\u30ae\u30fc\u56de\u5fa9(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.dairy1_2", "\u30a8\u30cd\u30eb\u30ae\u30fc\u56de\u5fa9(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.dairy1_3", "\u30a8\u30cd\u30eb\u30ae\u30fc\u56de\u5fa9(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.dairy2_1", "\u30a8\u30cd\u30eb\u30ae\u30fc\u56de\u5fa9(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.dairy2_2", "\u30a8\u30cd\u30eb\u30ae\u30fc\u56de\u5fa9(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.sugar1_1", "\u30c9\u30ed\u30c3\u30d7\u7387\u5f37\u5316(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.sugar1_2", "\u30c9\u30ed\u30c3\u30d7\u7387\u5f37\u5316(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.sugar1_3", "\u30c9\u30ed\u30c3\u30d7\u7387\u5f37\u5316(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.sugar2_1", "\u30c9\u30ed\u30c3\u30d7\u7387\u5f37\u5316(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.sugar2_2", "\u30c9\u30ed\u30c3\u30d7\u7387\u5f37\u5316(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.alcohol1_1", "\u7d4c\u9a13\u5024\u52b9\u7387\u5f37\u5316(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.alcohol1_2", "\u7d4c\u9a13\u5024\u52b9\u7387\u5f37\u5316(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.alcohol1_3", "\u7d4c\u9a13\u5024\u52b9\u7387\u5f37\u5316(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.alcohol2_1", "\u7d4c\u9a13\u5024\u52b9\u7387\u5f37\u5316(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.alcohol2_2", "\u7d4c\u9a13\u5024\u52b9\u7387\u5f37\u5316(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.spice1_1", "\u706b\u5c5e\u6027\u5f37\u5316(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.spice1_2", "\u706b\u5c5e\u6027\u5f37\u5316(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.spice1_3", "\u706b\u5c5e\u6027\u5f37\u5316(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.spice2_1", "\u706b\u5c5e\u6027\u5f37\u5316(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.spice2_2", "\u706b\u5c5e\u6027\u5f37\u5316(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.ice1_1", "\u6c34\u5c5e\u6027\u5f37\u5316(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.ice1_2", "\u6c34\u5c5e\u6027\u5f37\u5316(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.ice1_3", "\u6c34\u5c5e\u6027\u5f37\u5316(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.ice2_1", "\u6c34\u5c5e\u6027\u5f37\u5316(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.ice2_2", "\u6c34\u5c5e\u6027\u5f37\u5316(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.sparkling1_1", "\u96f7\u5c5e\u6027\u5f37\u5316(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.sparkling1_2", "\u96f7\u5c5e\u6027\u5f37\u5316(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.sparkling1_3", "\u96f7\u5c5e\u6027\u5f37\u5316(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.sparkling2_1", "\u96f7\u5c5e\u6027\u5f37\u5316(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.sparkling2_2", "\u96f7\u5c5e\u6027\u5f37\u5316(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fried1_1", "\u7269\u7406\u5f37\u5316(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fried1_2", "\u7269\u7406\u5f37\u5316(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fried1_3", "\u7269\u7406\u5f37\u5316(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fried2_1", "\u7269\u7406\u5f37\u5316(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.fried2_2", "\u7269\u7406\u5f37\u5316(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.tea1_1", "\u30af\u30ea\u30c6\u30a3\u30ab\u30eb\u5f37\u5316(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.tea1_2", "\u30af\u30ea\u30c6\u30a3\u30ab\u30eb\u5f37\u5316(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.tea1_3", "\u30af\u30ea\u30c6\u30a3\u30ab\u30eb\u5f37\u5316(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.tea2_1", "\u30af\u30ea\u30c6\u30a3\u30ab\u30eb\u5f37\u5316(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.tea2_2", "\u30af\u30ea\u30c6\u30a3\u30ab\u30eb\u5f37\u5316(\u5927) 30:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.strange1_1", "\u6df7\u6c8c\u5c5e\u6027\u5f37\u5316(\u5c0f) 1:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.strange1_2", "\u6df7\u6c8c\u5c5e\u6027\u5f37\u5316(\u5c0f) 10:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.strange1_3", "\u6df7\u6c8c\u5c5e\u6027\u5f37\u5316(\u5c0f) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.strange2_1", "\u6df7\u6c8c\u5c5e\u6027\u5f37\u5316(\u5927) 15:00");
        JAPANESE_TRANSLATIONS.put("tag.mine_and_meals.strange2_2", "\u6df7\u6c8c\u5c5e\u6027\u5f37\u5316(\u5927) 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.grain1_1", "Max Health \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.grain1_2", "Max Health \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.grain1_3", "Max Health \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.grain2_1", "Max Health \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.grain2_2", "Max Health \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.meat1_1", "Health Regen \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.meat1_2", "Health Regen \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.meat1_3", "Health Regen \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.meat2_1", "Health Regen \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.meat2_2", "Health Regen \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.vegetable1_1", "Max Mana \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.vegetable1_2", "Max Mana \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.vegetable1_3", "Max Mana \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.vegetable2_1", "Max Mana \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.vegetable2_2", "Max Mana \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fruit1_1", "Mana Regen \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fruit1_2", "Mana Regen \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fruit1_3", "Mana Regen \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fruit2_1", "Mana Regen \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fruit2_2", "Mana Regen \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fish1_1", "Max Energy \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fish1_2", "Max Energy \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fish1_3", "Max Energy \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fish2_1", "Max Energy \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fish2_2", "Max Energy \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.dairy1_1", "Energy Regen \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.dairy1_2", "Energy Regen \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.dairy1_3", "Energy Regen \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.dairy2_1", "Energy Regen \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.dairy2_2", "Energy Regen \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.sugar1_1", "Drop Rate \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.sugar1_2", "Drop Rate \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.sugar1_3", "Drop Rate \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.sugar2_1", "Drop Rate \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.sugar2_2", "Drop Rate \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.alcohol1_1", "EXP Bonus \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.alcohol1_2", "EXP Bonus \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.alcohol1_3", "EXP Bonus \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.alcohol2_1", "EXP Bonus \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.alcohol2_2", "EXP Bonus \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.spice1_1", "Fire Boost \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.spice1_2", "Fire Boost \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.spice1_3", "Fire Boost \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.spice2_1", "Fire Boost \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.spice2_2", "Fire Boost \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.ice1_1", "Water Boost \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.ice1_2", "Water Boost \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.ice1_3", "Water Boost \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.ice2_1", "Water Boost \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.ice2_2", "Water Boost \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.sparkling1_1", "Lightning Boost \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.sparkling1_2", "Lightning Boost \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.sparkling1_3", "Lightning Boost \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.sparkling2_1", "Lightning Boost \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.sparkling2_2", "Lightning Boost \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fried1_1", "Physical Boost \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fried1_2", "Physical Boost \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fried1_3", "Physical Boost \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fried2_1", "Physical Boost \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.fried2_2", "Physical Boost \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.tea1_1", "Critical Boost \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.tea1_2", "Critical Boost \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.tea1_3", "Critical Boost \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.tea2_1", "Critical Boost \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.tea2_2", "Critical Boost \u2161 30:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.strange1_1", "Chaos Boost \u2160 1:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.strange1_2", "Chaos Boost \u2160 10:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.strange1_3", "Chaos Boost \u2160 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.strange2_1", "Chaos Boost \u2161 15:00");
        ENGLISH_TRANSLATIONS.put("tag.mine_and_meals.strange2_2", "Chaos Boost \u2161 30:00");
        TAG_COLORS.put("tag.mine_and_meals.grain1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.grain1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.grain1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.grain2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.grain2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.meat1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.meat1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.meat1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.meat2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.meat2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.vegetable1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.vegetable1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.vegetable1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.vegetable2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.vegetable2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.fruit1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.fruit1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.fruit1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.fruit2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.fruit2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.fish1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.fish1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.fish1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.fish2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.fish2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.dairy1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.dairy1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.dairy1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.dairy2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.dairy2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.sugar1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.sugar1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.sugar1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.sugar2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.sugar2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.alcohol1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.alcohol1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.alcohol1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.alcohol2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.alcohol2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.spice1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.spice1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.spice1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.spice2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.spice2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.ice1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.ice1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.ice1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.ice2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.ice2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.sparkling1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.sparkling1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.sparkling1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.sparkling2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.sparkling2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.fried1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.fried1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.fried1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.fried2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.fried2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.tea1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.tea1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.tea1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.tea2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.tea2_2", 0xFF00FF);
        TAG_COLORS.put("tag.mine_and_meals.strange1_1", 0xFFFFFF);
        TAG_COLORS.put("tag.mine_and_meals.strange1_2", 65280);
        TAG_COLORS.put("tag.mine_and_meals.strange1_3", 65535);
        TAG_COLORS.put("tag.mine_and_meals.strange2_1", 0xFFFF00);
        TAG_COLORS.put("tag.mine_and_meals.strange2_2", 0xFF00FF);
    }
}

