/*
 * Decompiled with CFR 0.152.
 */
package com.baketsu.mine_and_meals.events;

import com.baketsu.mine_and_meals.MineAndMeals;
import com.baketsu.mine_and_meals.effects.ModEffects;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="mine_and_meals")
public class FoodConsumptionHandler {
    private static final Map<TagKey<Item>, Supplier<MobEffectInstance>> TAG_EFFECT_MAP = new HashMap<TagKey<Item>, Supplier<MobEffectInstance>>();

    private static TagKey<Item> createTag(String tagName) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("mine_and_meals", tagName));
    }

    private static void registerEffect(String tagName, MobEffectInstance effectInstance) {
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag(tagName), () -> effectInstance);
    }

    @SubscribeEvent
    public static void onFoodConsumption(LivingEntityUseItemEvent.Finish event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            ItemStack consumedItem = event.getItem();
            TAG_EFFECT_MAP.forEach((tag, effectSupplier) -> {
                if (consumedItem.m_204117_(tag)) {
                    FoodConsumptionHandler.applyEffect(player, (MobEffectInstance)effectSupplier.get());
                }
            });
        }
    }

    private static void applyEffect(Player player, MobEffectInstance effectInstance) {
        if (player.m_21023_(effectInstance.m_19544_())) {
            MobEffectInstance currentEffect = player.m_21124_(effectInstance.m_19544_());
            if (currentEffect != null && effectInstance.m_19557_() > currentEffect.m_19557_()) {
                player.m_21195_(effectInstance.m_19544_());
                player.m_7292_(effectInstance);
                MineAndMeals.LOGGER.info("Updated effect: {} for player: {}", (Object)effectInstance.m_19544_().m_19481_(), (Object)player.m_7755_().getString());
            }
        } else {
            player.m_7292_(effectInstance);
            MineAndMeals.LOGGER.info("Applied effect: {} to player: {}", (Object)effectInstance.m_19544_().m_19481_(), (Object)player.m_7755_().getString());
        }
    }

    static {
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("grain1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.GRAIN_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("grain1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.GRAIN_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("grain1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.GRAIN_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("grain2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.GRAIN_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("grain2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.GRAIN_2.get(), 36000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("meat1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.MEAT_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("meat1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.MEAT_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("meat1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.MEAT_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("meat2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.MEAT_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("meat2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.MEAT_2.get(), 36000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("vegetable1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.VEGETABLE_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("vegetable1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.VEGETABLE_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("vegetable1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.VEGETABLE_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("vegetable2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.VEGETABLE_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("vegetable2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.VEGETABLE_2.get(), 36000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fruit1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.FRUIT_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fruit1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.FRUIT_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fruit1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.FRUIT_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fruit2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.FRUIT_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fruit2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.FRUIT_2.get(), 36000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fish1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.FISH_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fish1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.FISH_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fish1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.FISH_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fish2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.FISH_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fish2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.FISH_2.get(), 36000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("dairy1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.DAIRY_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("dairy1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.DAIRY_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("dairy1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.DAIRY_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("dairy2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.DAIRY_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("dairy2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.DAIRY_2.get(), 36000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("alcohol1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.ALCOHOL_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("alcohol1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.ALCOHOL_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("alcohol1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.ALCOHOL_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("alcohol2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.ALCOHOL_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("alcohol2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.ALCOHOL_2.get(), 36000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("sugar1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.SUGAR_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("sugar1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.SUGAR_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("spice1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.SPICE_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("spice2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.SPICE_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("spice2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.SPICE_2.get(), 36000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("ice1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.ICE_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("ice1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.ICE_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("ice1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.ICE_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("ice2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.ICE_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("ice2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.ICE_2.get(), 36000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("sparkling1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.SPARKLING_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("sparkling1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.SPARKLING_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("sparkling1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.SPARKLING_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("sparkling2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.SPARKLING_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("sparkling2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.SPARKLING_2.get(), 36000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("strange1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.STRANGE_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("strange1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.STRANGE_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("strange1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.STRANGE_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("strange2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.STRANGE_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("strange2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.STRANGE_2.get(), 36000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fried1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.FRIED_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fried1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.FRIED_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fried1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.FRIED_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fried2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.FRIED_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("fried2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.FRIED_2.get(), 36000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("tea1_1"), () -> new MobEffectInstance((MobEffect)ModEffects.TEA_1.get(), 1200, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("tea1_2"), () -> new MobEffectInstance((MobEffect)ModEffects.TEA_1.get(), 12000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("tea1_3"), () -> new MobEffectInstance((MobEffect)ModEffects.TEA_1.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("tea2_1"), () -> new MobEffectInstance((MobEffect)ModEffects.TEA_2.get(), 18000, 0));
        TAG_EFFECT_MAP.put(FoodConsumptionHandler.createTag("tea2_2"), () -> new MobEffectInstance((MobEffect)ModEffects.TEA_2.get(), 36000, 0));
    }
}

