/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei.transfer;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IStackHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.network.BnCNetworkHandler;
import umpaz.brewinandchewin.common.network.serverbound.JEITransferKegRecipeServerboundPacket;
import umpaz.brewinandchewin.common.registry.BnCMenuTypes;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.integration.jei.BnCJEIRecipeTypes;
import umpaz.brewinandchewin.integration.jei.KegFermentingPouringRecipe;

public class FermentingTransfer {

    private record InventoryState(Map<Slot, ItemStack> availableItemStacks, int filledCraftSlotCount, int emptySlotCount) {
        private boolean hasRoom(int inputCount) {
            return this.filledCraftSlotCount - inputCount <= this.emptySlotCount;
        }
    }

    public static class TransferOperations {
        public final List<Pair<Slot, Slot>> results = new ArrayList<Pair<Slot, Slot>>();
        public final List<Pair<Slot, Integer>> fluidResults = new ArrayList<Pair<Slot, Integer>>();
        public final List<Pair<Slot, Integer>> emptyingResults = new ArrayList<Pair<Slot, Integer>>();
        public final List<IRecipeSlotView> missingItems = new ArrayList<IRecipeSlotView>();
        public boolean canEmpty = true;
        public boolean notEnoughFluid = false;
        public boolean invalidFluid = false;

        public static TransferOperations readFromIntegers(List<Pair<Integer, Integer>> resultSlots, List<Pair<Integer, Integer>> fluidSlots, List<Pair<Integer, Integer>> emptyingSlots, AbstractContainerMenu menu) {
            int fluidAmount;
            TransferOperations operations = new TransferOperations();
            for (Pair<Integer, Integer> resultSlot : resultSlots) {
                int inventorySlotIndex = (Integer)resultSlot.getFirst();
                int craftingSlotIndex = (Integer)resultSlot.getSecond();
                operations.results.add((Pair<Slot, Slot>)Pair.of((Object)menu.m_38853_(inventorySlotIndex), (Object)menu.m_38853_(craftingSlotIndex)));
            }
            for (Pair<Integer, Integer> fluidSlot : fluidSlots) {
                int fluidSlotIndex = (Integer)fluidSlot.getFirst();
                fluidAmount = (Integer)fluidSlot.getSecond();
                operations.fluidResults.add((Pair<Slot, Integer>)Pair.of((Object)menu.m_38853_(fluidSlotIndex), (Object)fluidAmount));
            }
            for (Pair<Integer, Integer> emptyingSlot : emptyingSlots) {
                int emptyingSlotIndex = (Integer)emptyingSlot.getFirst();
                fluidAmount = (Integer)emptyingSlot.getSecond();
                operations.emptyingResults.add((Pair<Slot, Integer>)Pair.of((Object)menu.m_38853_(emptyingSlotIndex), (Object)fluidAmount));
            }
            return operations;
        }
    }

    private record SlotReference(Slot slot, ItemStack stack, @Nullable Integer fluidAmount, int shrinkAmount) {
    }

    public static class Handler
    implements IRecipeTransferHandler<KegMenu, KegFermentingPouringRecipe> {
        private final IRecipeTransferHandlerHelper helper;
        private final IStackHelper stackHelper;

        public Handler(IRecipeTransferHandlerHelper helper, IStackHelper stackHelper) {
            this.helper = helper;
            this.stackHelper = stackHelper;
        }

        public Class<? extends KegMenu> getContainerClass() {
            return KegMenu.class;
        }

        public Optional<MenuType<KegMenu>> getMenuType() {
            return Optional.of((MenuType)BnCMenuTypes.KEG.get());
        }

        public RecipeType<KegFermentingPouringRecipe> getRecipeType() {
            return BnCJEIRecipeTypes.FERMENTING;
        }

        @Nullable
        public IRecipeTransferError transferRecipe(KegMenu menu, KegFermentingPouringRecipe recipe, IRecipeSlotsView view, Player player, boolean maxTransfer, boolean doTransfer) {
            int requiredInv;
            if (!KegBlockEntity.isValidTemp(menu.getKegTemperature(), recipe.getTemperature())) {
                MutableComponent message = Component.m_237115_((String)"brewinandchewin.jei.tooltip.error.recipe.transfer.temperature");
                return this.helper.createUserErrorWithTooltip((Component)message);
            }
            Info info = Info.INSTANCE;
            List<Slot> craftingSlots = Collections.unmodifiableList(info.getRecipeSlots(menu, recipe));
            List<Slot> inventorySlots = Collections.unmodifiableList(info.getInventorySlots(menu, recipe));
            List<IRecipeSlotView> inputItemSlotViews = view.getSlotViews(RecipeIngredientRole.INPUT).stream().filter(ingredientView -> ingredientView.getAllIngredients().anyMatch(ingredient -> ingredient.getIngredient((IIngredientType)VanillaTypes.ITEM_STACK).isPresent())).toList();
            InventoryState inv = this.createInvState(craftingSlots, inventorySlots);
            if (!inv.hasRoom(requiredInv = inputItemSlotViews.size())) {
                MutableComponent message = Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.inventory.full");
                return this.helper.createUserErrorWithTooltip((Component)message);
            }
            TransferOperations operations = this.createOperations(inv.availableItemStacks, inputItemSlotViews, recipe.getFluidIngredient() != null ? (IRecipeSlotView)view.getSlotViews(RecipeIngredientRole.INPUT).stream().filter(ingredientView -> ingredientView.getAllIngredients().anyMatch(ingredient -> ingredient.getIngredient((IIngredientType)ForgeTypes.FLUID_STACK).isPresent())).findFirst().orElse(null) : null, recipe, menu, craftingSlots, maxTransfer);
            if (!operations.canEmpty) {
                MutableComponent message = Component.m_237115_((String)"brewinandchewin.jei.tooltip.error.recipe.transfer.cant_empty");
                return this.helper.createUserErrorWithTooltip((Component)message);
            }
            if (operations.notEnoughFluid) {
                MutableComponent message = Component.m_237115_((String)"brewinandchewin.jei.tooltip.error.recipe.transfer.not_enough_fluid");
                return this.helper.createUserErrorWithTooltip((Component)message);
            }
            if (operations.invalidFluid) {
                MutableComponent message = Component.m_237115_((String)"brewinandchewin.jei.tooltip.error.recipe.transfer.invalid_fluid");
                return this.helper.createUserErrorWithTooltip((Component)message);
            }
            if (!operations.missingItems.isEmpty()) {
                MutableComponent message = Component.m_237115_((String)"jei.tooltip.error.recipe.transfer.missing");
                return this.helper.createUserErrorForMissingSlots((Component)message, operations.missingItems);
            }
            if (doTransfer) {
                BnCNetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new JEITransferKegRecipeServerboundPacket(recipe.m_6423_(), operations.results.stream().map(pair -> Pair.of((Object)((Slot)pair.getFirst()).f_40219_, (Object)((Slot)pair.getSecond()).f_40219_)).toList(), operations.fluidResults.stream().map(pair -> Pair.of((Object)((Slot)pair.getFirst()).f_40219_, (Object)((Integer)pair.getSecond()))).toList(), operations.emptyingResults.stream().map(pair -> Pair.of((Object)((Slot)pair.getFirst()).f_40219_, (Object)((Integer)pair.getSecond()))).toList(), craftingSlots.stream().map(slot -> slot.f_40219_).toList(), inventorySlots.stream().map(slot -> slot.f_40219_).toList(), maxTransfer));
            }
            return null;
        }

        private InventoryState createInvState(Collection<Slot> craftingSlots, Collection<Slot> inventorySlots) {
            ItemStack stack;
            HashMap<Slot, ItemStack> availableItemStacks = new HashMap<Slot, ItemStack>();
            int filledCraftSlotCount = 0;
            int emptySlotCount = 0;
            for (Slot slot : craftingSlots) {
                stack = slot.m_7993_();
                if (stack.m_41619_()) continue;
                ++filledCraftSlotCount;
                availableItemStacks.put(slot, stack.m_41777_());
            }
            for (Slot slot : inventorySlots) {
                stack = slot.m_7993_();
                if (!stack.m_41619_()) {
                    availableItemStacks.put(slot, stack.m_41777_());
                    continue;
                }
                ++emptySlotCount;
            }
            return new InventoryState(availableItemStacks, filledCraftSlotCount, emptySlotCount);
        }

        /*
         * WARNING - void declaration
         */
        private TransferOperations createOperations(Map<Slot, ItemStack> availableItemStacks, List<IRecipeSlotView> requiredItemStacks, IRecipeSlotView requiredFluidStack, KegFermentingPouringRecipe recipe, KegMenu menu, List<Slot> craftingSlots, boolean maxTransfer) {
            int n;
            void var18_28;
            TransferOperations operations = new TransferOperations();
            IdentityHashMap<IRecipeSlotView, Map> relevantSlots = new IdentityHashMap<IRecipeSlotView, Map>();
            IdentityHashMap<ItemStack, List> emptyingSlots = new IdentityHashMap<ItemStack, List>();
            boolean hasTooMuchFluid = false;
            int fluidCapacity = 0;
            int largestFluidCapacity = 0;
            int largestEmptyCapacity = 0;
            for (Map.Entry<Slot, ItemStack> slotTuple : availableItemStacks.entrySet()) {
                int tankAmount;
                List<KegPouringRecipe> pouringRecipes;
                Optional<KegPouringRecipe> optional;
                for (IRecipeSlotView iRecipeSlotView : requiredItemStacks) {
                    if (iRecipeSlotView.isEmpty() || !iRecipeSlotView.getItemStacks().anyMatch(it -> this.stackHelper.isEquivalent(it, (ItemStack)slotTuple.getValue(), UidContext.Ingredient))) continue;
                    relevantSlots.computeIfAbsent(iRecipeSlotView, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<ItemStack>(){

                        public int hashCode(ItemStack o) {
                            return o.m_41720_().hashCode();
                        }

                        public boolean equals(ItemStack a, ItemStack b) {
                            return stackHelper.isEquivalent(a, b, UidContext.Ingredient);
                        }
                    })).computeIfAbsent(slotTuple.getValue(), it -> new ArrayList()).add(new SlotReference(slotTuple.getKey(), slotTuple.getValue(), null, 1));
                }
                if (!(menu.kegTank.isEmpty() || maxTransfer && recipe.getFluidIngredient() != null && menu.kegTank.getFluid().isFluidEqual(recipe.getFluidIngredient()) || !(optional = (pouringRecipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().filter(kegPouringRecipe -> kegPouringRecipe.getFluid((ItemStack)slotTuple.getValue()).isFluidEqual(menu.kegTank.getFluid())).toList()).stream().filter(pouring -> {
                    if (pouring.isStrict()) {
                        return ItemStack.m_150942_((ItemStack)((ItemStack)slotTuple.getValue()), (ItemStack)pouring.getContainer());
                    }
                    return ItemStack.m_41656_((ItemStack)((ItemStack)slotTuple.getValue()), (ItemStack)pouring.getContainer());
                }).findFirst()).isPresent())) {
                    int shrinkAmount;
                    if (optional.get().getAmount() <= menu.kegTank.getFluidAmount()) {
                        shrinkAmount = menu.kegTank.getFluidAmount() / optional.get().getAmount();
                        emptyingSlots.computeIfAbsent(slotTuple.getValue(), it -> new ArrayList()).add(new SlotReference(slotTuple.getKey(), slotTuple.getValue(), optional.get().getAmount() * shrinkAmount, shrinkAmount));
                    }
                    if (recipe.getFluidIngredient() != null && menu.kegTank.getFluid().isFluidEqual(recipe.getFluidIngredient()) && optional.get().getAmount() <= recipe.getFluidIngredient().getAmount() && fluidCapacity < recipe.getFluidIngredient().getAmount()) {
                        if (optional.get().getAmount() > largestEmptyCapacity) {
                            relevantSlots.remove(requiredFluidStack);
                        }
                        shrinkAmount = recipe.getFluidIngredient().getAmount() / optional.get().getAmount();
                        largestEmptyCapacity = optional.get().getAmount();
                        relevantSlots.computeIfAbsent(requiredFluidStack, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<ItemStack>(){

                            public int hashCode(ItemStack o) {
                                return o.m_41720_().hashCode();
                            }

                            public boolean equals(ItemStack a, ItemStack b) {
                                return stackHelper.isEquivalent(a, b, UidContext.Ingredient);
                            }
                        })).computeIfAbsent(slotTuple.getValue(), it -> new ArrayList()).add(new SlotReference(slotTuple.getKey(), optional.get().m_8043_(Minecraft.m_91087_().f_91073_.m_9598_()).m_255036_(shrinkAmount), optional.get().getAmount() * shrinkAmount, shrinkAmount));
                    }
                }
                if (recipe.getFluidIngredient() == null || requiredFluidStack.isEmpty() || !requiredFluidStack.getIngredients((IIngredientType)ForgeTypes.FLUID_STACK).findFirst().isPresent()) continue;
                pouringRecipes = Minecraft.m_91087_().f_91073_.m_7465_().m_44013_((net.minecraft.world.item.crafting.RecipeType)BnCRecipeTypes.KEG_POURING.get()).stream().filter(kegPouringRecipe -> kegPouringRecipe.canFill() && kegPouringRecipe.getFluid((ItemStack)slotTuple.getValue()).isFluidEqual(recipe.getFluidIngredient())).toList();
                Optional<KegPouringRecipe> optional2 = pouringRecipes.stream().filter(pouring -> {
                    if (pouring.isStrict()) {
                        return ItemStack.m_150942_((ItemStack)((ItemStack)slotTuple.getValue()), (ItemStack)pouring.getOutput());
                    }
                    return ItemStack.m_41656_((ItemStack)((ItemStack)slotTuple.getValue()), (ItemStack)pouring.getOutput());
                }).findFirst();
                int n2 = tankAmount = menu.kegTank.getFluid().isFluidEqual(recipe.getFluidIngredient()) ? menu.kegTank.getFluidAmount() : 0;
                if (!optional2.isPresent()) continue;
                if (optional2.get().getAmount() <= menu.kegTank.getCapacity() - tankAmount && fluidCapacity < menu.kegTank.getCapacity() - tankAmount) {
                    if (optional2.get().getAmount() > largestFluidCapacity) {
                        relevantSlots.remove(requiredFluidStack);
                    }
                    int shrinkAmount = recipe.getFluidIngredient().getAmount() / optional2.get().getAmount() - tankAmount % recipe.getFluidIngredient().getAmount() / optional2.get().getAmount();
                    largestFluidCapacity = optional2.get().getAmount();
                    fluidCapacity += optional2.get().getAmount() * shrinkAmount;
                    relevantSlots.computeIfAbsent(requiredFluidStack, it -> new Object2ObjectOpenCustomHashMap((Hash.Strategy)new Hash.Strategy<ItemStack>(){

                        public int hashCode(ItemStack o) {
                            return o.m_41720_().hashCode();
                        }

                        public boolean equals(ItemStack a, ItemStack b) {
                            return stackHelper.isEquivalent(a, b, UidContext.Ingredient);
                        }
                    })).computeIfAbsent(slotTuple.getValue(), it -> new ArrayList()).add(new SlotReference(slotTuple.getKey(), slotTuple.getValue(), optional2.get().getAmount() * shrinkAmount, shrinkAmount));
                    continue;
                }
                hasTooMuchFluid = true;
            }
            Object2ObjectArrayMap bestMatches = new Object2ObjectArrayMap();
            ArrayList emptyingBestMatches = new ArrayList();
            for (Map.Entry entry : relevantSlots.entrySet()) {
                ArrayList<List> countedAndSorted = new ArrayList<List>();
                for (Map.Entry foundSlots : ((Map)entry.getValue()).entrySet()) {
                    ((List)foundSlots.getValue()).sort((o1, o2) -> {
                        int compare;
                        int n = compare = o1.fluidAmount != null && o2.fluidAmount != null ? Integer.compare(o1.fluidAmount, o2.fluidAmount) : Integer.compare(o1.stack.m_41613_(), o2.stack.m_41613_());
                        if (compare == 0) {
                            return Integer.compare(o1.slot.f_40219_, o2.slot.f_40219_);
                        }
                        return compare;
                    });
                    countedAndSorted.add((List)foundSlots.getValue());
                }
                countedAndSorted.sort((o1, o2) -> {
                    int compare = Long.compare(o2.stream().mapToLong(it -> it.stack.m_41613_()).sum(), o1.stream().mapToLong(it -> it.stack.m_41613_()).sum());
                    if (compare == 0) {
                        return Integer.compare(o1.stream().mapToInt(it -> it.slot.f_40219_).min().orElse(0), o2.stream().mapToInt(it -> it.slot.f_40219_).min().orElse(0));
                    }
                    return compare;
                });
                bestMatches.put((IRecipeSlotView)entry.getKey(), countedAndSorted);
            }
            for (Map.Entry entry : emptyingSlots.entrySet()) {
                ArrayList<List> countedAndSorted = new ArrayList<List>();
                ((List)entry.getValue()).sort((o1, o2) -> {
                    int compare;
                    int n = compare = o1.fluidAmount != null && o2.fluidAmount != null ? Integer.compare(o1.fluidAmount, o2.fluidAmount) : Integer.compare(o1.stack.m_41613_(), o2.stack.m_41613_());
                    if (compare == 0) {
                        return Integer.compare(o1.slot.f_40219_, o2.slot.f_40219_);
                    }
                    return compare;
                });
                countedAndSorted.add((List)entry.getValue());
                countedAndSorted.sort((o1, o2) -> {
                    int compare = Long.compare(o2.stream().mapToLong(it -> it.stack.m_41613_()).sum(), o1.stream().mapToLong(it -> it.stack.m_41613_()).sum());
                    if (compare == 0) {
                        return Integer.compare(o1.stream().mapToInt(it -> it.slot.f_40219_).min().orElse(0), o2.stream().mapToInt(it -> it.slot.f_40219_).min().orElse(0));
                    }
                    return compare;
                });
                emptyingBestMatches.addAll(countedAndSorted);
            }
            ArrayList<IRecipeSlotView> inclusiveRequiredItemStacks = new ArrayList<IRecipeSlotView>(requiredItemStacks);
            if (requiredFluidStack != null) {
                inclusiveRequiredItemStacks.add(requiredFluidStack);
            }
            for (IRecipeSlotView ingredient : inclusiveRequiredItemStacks) {
                if (ingredient.isEmpty()) continue;
                bestMatches.computeIfAbsent(ingredient, it -> new ArrayList());
            }
            boolean bl = false;
            while (var18_28 < requiredItemStacks.size()) {
                IRecipeSlotView requiredItemStack = requiredItemStacks.get((int)var18_28);
                if (!requiredItemStack.isEmpty()) {
                    Slot craftingSlot = craftingSlots.get((int)var18_28);
                    SlotReference matching = ((List)bestMatches.get(requiredItemStack)).stream().flatMap(pairs -> pairs.stream().filter(p -> !p.stack.m_41619_())).findFirst().orElse(null);
                    if (matching == null) {
                        operations.missingItems.add(requiredItemStack);
                    } else {
                        matching.stack.m_41774_(matching.shrinkAmount);
                        operations.results.add((Pair<Slot, Slot>)Pair.of((Object)matching.slot, (Object)craftingSlot));
                    }
                }
                ++var18_28;
            }
            if (requiredFluidStack != null && recipe.getFluidIngredient() != null && (n = Math.max((maxTransfer ? menu.kegTank.getCapacity() : recipe.getFluidIngredient().getAmount()) - (menu.kegTank.getFluid().isFluidEqual(recipe.getFluidIngredient()) ? menu.kegTank.getFluidAmount() : 0), 0)) > 0) {
                List allMatching = ((List)bestMatches.get(requiredFluidStack)).stream().flatMap(pairs -> pairs.stream().filter(p -> !p.stack.m_41619_() && p.fluidAmount != null)).toList();
                if (allMatching.isEmpty()) {
                    operations.missingItems.add(requiredFluidStack);
                    if (hasTooMuchFluid) {
                        operations.invalidFluid = true;
                    }
                } else {
                    void var18_30;
                    ArrayList<SlotReference> toShrink = new ArrayList<SlotReference>();
                    for (SlotReference matching : allMatching) {
                        if (var18_30 <= 0) break;
                        toShrink.add(matching);
                        operations.fluidResults.add((Pair<Slot, Integer>)Pair.of((Object)matching.slot, (Object)matching.fluidAmount));
                        var18_30 -= matching.fluidAmount.intValue();
                    }
                    if (var18_30 > 0) {
                        operations.fluidResults.clear();
                        operations.notEnoughFluid = true;
                    } else {
                        toShrink.forEach(slotReference -> slotReference.stack.m_41774_(slotReference.shrinkAmount));
                    }
                }
            }
            if (!emptyingBestMatches.isEmpty()) {
                int n3 = menu.kegTank.getFluidAmount();
                List allMatching = emptyingBestMatches.stream().flatMap(pairs -> pairs.stream().filter(p -> !p.stack.m_41619_() && p.fluidAmount != null)).toList();
                if (!(!allMatching.isEmpty() || menu.kegTank.isEmpty() || recipe.getFluidIngredient() != null && menu.kegTank.getFluid().isFluidEqual(recipe.getFluidIngredient()))) {
                    operations.canEmpty = false;
                } else {
                    void var18_32;
                    ArrayList<SlotReference> toShrink = new ArrayList<SlotReference>();
                    for (SlotReference matching : allMatching) {
                        if (var18_32 <= 0) break;
                        toShrink.add(matching);
                        operations.emptyingResults.add((Pair<Slot, Integer>)Pair.of((Object)matching.slot, (Object)matching.fluidAmount));
                        var18_32 -= matching.fluidAmount.intValue();
                    }
                    if (!(var18_32 <= 0 || menu.kegTank.isEmpty() || recipe.getFluidIngredient() != null && menu.kegTank.getFluid().isFluidEqual(recipe.getFluidIngredient()))) {
                        operations.emptyingResults.clear();
                        operations.canEmpty = false;
                    } else {
                        toShrink.forEach(slotReference -> slotReference.stack.m_41774_(slotReference.shrinkAmount));
                    }
                }
            }
            if (!menu.kegTank.isEmpty() && emptyingBestMatches.isEmpty() && (recipe.getFluidIngredient() == null || !menu.kegTank.getFluid().isFluidEqual(recipe.getFluidIngredient()) || recipe.getFluidIngredient() != null && menu.kegTank.getFluidAmount() % recipe.getFluidIngredient().getAmount() != 0)) {
                operations.canEmpty = false;
            }
            return operations;
        }
    }

    public static class Info
    implements IRecipeTransferInfo<KegMenu, KegFermentingPouringRecipe> {
        public static final Info INSTANCE = new Info();

        protected Info() {
        }

        public Class<? extends KegMenu> getContainerClass() {
            return KegMenu.class;
        }

        public Optional<MenuType<KegMenu>> getMenuType() {
            return Optional.of((MenuType)BnCMenuTypes.KEG.get());
        }

        public RecipeType<KegFermentingPouringRecipe> getRecipeType() {
            return BnCJEIRecipeTypes.FERMENTING;
        }

        public boolean canHandle(KegMenu container, KegFermentingPouringRecipe recipe) {
            return true;
        }

        public List<Slot> getRecipeSlots(KegMenu container, KegFermentingPouringRecipe recipe) {
            ArrayList<Slot> slots = new ArrayList<Slot>();
            for (int i = 0; i < 4; ++i) {
                Slot slot = container.m_38853_(i);
                slots.add(slot);
            }
            return slots;
        }

        public List<Slot> getInventorySlots(KegMenu container, KegFermentingPouringRecipe recipe) {
            ArrayList<Slot> slots = new ArrayList<Slot>();
            for (int i = 6; i < 42; ++i) {
                Slot slot = container.m_38853_(i);
                slots.add(slot);
            }
            return slots;
        }
    }
}

