/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.network.serverbound;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import org.apache.commons.compress.utils.Lists;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.integration.emi.handler.KegEmiRecipeHandler;

public record EMIFillFermentingRecipeServerboundPacket(int syncId, Map<KegEmiRecipeHandler.InputType, List<ItemStack>> stacks) {
    public EMIFillFermentingRecipeServerboundPacket(KegMenu menu, Map<KegEmiRecipeHandler.InputType, List<ItemStack>> stacks) {
        this(menu.f_38840_, stacks);
    }

    public static EMIFillFermentingRecipeServerboundPacket decode(FriendlyByteBuf buf) {
        return new EMIFillFermentingRecipeServerboundPacket(buf.readInt(), EMIFillFermentingRecipeServerboundPacket.decodeStacks(buf));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.syncId);
        EMIFillFermentingRecipeServerboundPacket.encodeStacks(buf, this.stacks);
    }

    private static Map<KegEmiRecipeHandler.InputType, List<ItemStack>> decodeStacks(FriendlyByteBuf buf) {
        HashMap<KegEmiRecipeHandler.InputType, List<ItemStack>> stacks = new HashMap<KegEmiRecipeHandler.InputType, List<ItemStack>>();
        int size = buf.m_130242_();
        for (int i = 0; i < size; ++i) {
            KegEmiRecipeHandler.InputType inputType = KegEmiRecipeHandler.InputType.BY_ID.apply(buf.m_130242_());
            List innerStacks = buf.m_236845_(FriendlyByteBuf::m_130267_);
            stacks.put(inputType, innerStacks);
        }
        return stacks;
    }

    private static void encodeStacks(FriendlyByteBuf buf, Map<KegEmiRecipeHandler.InputType, List<ItemStack>> stacks) {
        buf.m_130130_(stacks.size());
        for (Map.Entry<KegEmiRecipeHandler.InputType, List<ItemStack>> entry : stacks.entrySet()) {
            buf.m_130130_(entry.getKey().ordinal());
            buf.m_130130_(entry.getValue().size());
            for (ItemStack stack : entry.getValue()) {
                buf.m_130055_(stack);
            }
        }
    }

    public static class Handler {
        public static void handle(EMIFillFermentingRecipeServerboundPacket packet, Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                block18: {
                    ServerPlayer sender = ((NetworkEvent.Context)context.get()).getSender();
                    if (sender == null || !ModList.get().isLoaded("emi")) {
                        return;
                    }
                    AbstractContainerMenu menu = sender.f_36096_;
                    if (menu.f_38840_ != packet.syncId || !(menu instanceof KegMenu)) {
                        BrewinAndChewin.LOG.error("Attempted to transfer fermenting recipe to an incorrect menu");
                        return;
                    }
                    KegMenu kegMenu = (KegMenu)menu;
                    ArrayList rubble = Lists.newArrayList();
                    try {
                        int gotten;
                        if (packet.stacks.containsKey((Object)KegEmiRecipeHandler.InputType.EMPTY)) {
                            for (ItemStack stack : packet.stacks.get((Object)KegEmiRecipeHandler.InputType.EMPTY)) {
                                if (stack.m_41619_()) continue;
                                gotten = Handler.grabMatching(kegMenu, (Player)sender, List.of(menu.m_38853_(4)), rubble, stack);
                                if (gotten != stack.m_41613_()) {
                                    if (gotten <= 0) break;
                                    stack.m_41764_(gotten);
                                    sender.m_150109_().m_150079_(stack);
                                    break;
                                }
                                for (ItemStack items : kegMenu.blockEntity.extractInGui(stack, gotten)) {
                                    sender.m_150109_().m_150079_(items);
                                }
                            }
                        }
                        if (packet.stacks.containsKey((Object)KegEmiRecipeHandler.InputType.FILL)) {
                            for (ItemStack stack : packet.stacks.get((Object)KegEmiRecipeHandler.InputType.FILL)) {
                                if (stack.m_41619_()) continue;
                                gotten = Handler.grabMatching(kegMenu, (Player)sender, List.of(menu.m_38853_(4)), rubble, stack);
                                if (gotten != stack.m_41613_()) {
                                    if (gotten <= 0) break;
                                    stack.m_41764_(gotten);
                                    sender.m_150109_().m_150079_(stack);
                                    break;
                                }
                                for (ItemStack items : kegMenu.blockEntity.extractInGui(stack, gotten)) {
                                    sender.m_150109_().m_150079_(items);
                                }
                            }
                        }
                        if (!packet.stacks.containsKey((Object)KegEmiRecipeHandler.InputType.ITEM)) break block18;
                        for (int i = 0; i < packet.stacks.get((Object)KegEmiRecipeHandler.InputType.ITEM).size(); ++i) {
                            ItemStack stack;
                            stack = packet.stacks.get((Object)KegEmiRecipeHandler.InputType.ITEM).get(i);
                            if (stack.m_41619_()) continue;
                            gotten = Handler.grabMatching(kegMenu, (Player)sender, menu.f_38839_.subList(0, 3), rubble, stack);
                            if (gotten != stack.m_41613_()) {
                                if (gotten > 0) {
                                    stack.m_41764_(gotten);
                                    sender.m_150109_().m_150079_(stack);
                                }
                                break;
                            }
                            Slot s = menu.m_38853_(i);
                            if (s.m_5857_(stack) && stack.m_41613_() <= s.m_6641_()) {
                                s.m_269060_(stack);
                                continue;
                            }
                            sender.m_150109_().m_150079_(stack);
                        }
                    }
                    finally {
                        for (ItemStack stack : rubble) {
                            sender.m_150109_().m_150079_(stack);
                        }
                    }
                }
            });
        }

        private static int grabMatching(KegMenu menu, Player player, List<Slot> crafting, List<ItemStack> rubble, ItemStack stack) {
            int amount = stack.m_41613_();
            int grabbed = 0;
            for (int i = 0; i < rubble.size(); ++i) {
                if (grabbed >= amount) {
                    return grabbed;
                }
                ItemStack r = rubble.get(i);
                if (!ItemStack.m_150942_((ItemStack)stack, (ItemStack)r)) continue;
                int wanted = amount - grabbed;
                if (r.m_41613_() <= wanted) {
                    grabbed += r.m_41613_();
                    rubble.remove(i);
                    --i;
                    continue;
                }
                grabbed = amount;
                r.m_41764_(r.m_41613_() - wanted);
            }
            for (Slot s : menu.f_38839_) {
                ItemStack st;
                if (grabbed >= amount) {
                    return grabbed;
                }
                if (crafting.contains(s) || !s.m_8010_(player) || !ItemStack.m_150942_((ItemStack)stack, (ItemStack)(st = s.m_7993_()))) continue;
                int wanted = amount - grabbed;
                ItemStack taken = st.m_41777_();
                if (st.m_41613_() <= wanted) {
                    grabbed += st.m_41613_();
                    s.m_269060_(ItemStack.f_41583_);
                } else {
                    grabbed = amount;
                    st.m_41764_(st.m_41613_() - wanted);
                }
                s.m_142406_(player, taken);
            }
            return grabbed;
        }
    }
}

