/*
 * Decompiled with CFR 0.152.
 */
package fuzs.illagerinvasion.world.entity.monster;

import fuzs.illagerinvasion.init.ModRegistry;
import fuzs.illagerinvasion.world.entity.monster.Surrendered;
import fuzs.illagerinvasion.world.entity.projectile.FlyingMagma;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.SpellcasterIllager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class Firecaller
extends SpellcasterIllager {
    private int conjureSkullCooldown = 160;
    private int areaDamageCooldown = 300;

    public Firecaller(EntityType<? extends Firecaller> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 15;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookAtTargetOrWololoTarget());
        this.f_21345_.m_25352_(4, (Goal)new ConjureSkullGoal());
        this.f_21345_.m_25352_(3, (Goal)new AreaDamageGoal());
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 12.0f, 0.6, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, false));
    }

    public SoundEvent m_7930_() {
        return SoundEvents.f_12048_;
    }

    protected void m_8024_() {
        super.m_8024_();
        --this.conjureSkullCooldown;
        --this.areaDamageCooldown;
    }

    public boolean m_7307_(Entity other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (super.m_7307_(other)) {
            return true;
        }
        if (other instanceof Vex) {
            return this.m_7307_((Entity)((Vex)other).m_19749_());
        }
        return other instanceof LivingEntity && ((LivingEntity)other).m_6336_() == MobType.f_21643_ && this.m_5647_() == null && other.m_5647_() == null;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModRegistry.FIRECALLER_AMBIENT_SOUND_EVENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModRegistry.FIRECALLER_DEATH_SOUND_EVENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)ModRegistry.FIRECALLER_HURT_SOUND_EVENT.get();
    }

    protected SoundEvent m_7894_() {
        return SoundEvents.f_11874_;
    }

    public void m_7895_(int wave, boolean unused) {
    }

    public AbstractIllager.IllagerArmPose m_6768_() {
        if (this.m_33736_()) {
            return AbstractIllager.IllagerArmPose.SPELLCASTING;
        }
        return AbstractIllager.IllagerArmPose.CROSSED;
    }

    class LookAtTargetOrWololoTarget
    extends SpellcasterIllager.SpellcasterCastingSpellGoal {
        LookAtTargetOrWololoTarget() {
            super((SpellcasterIllager)Firecaller.this);
        }

        public void m_8037_() {
            if (Firecaller.this.m_5448_() != null) {
                Firecaller.this.m_21563_().m_24960_((Entity)Firecaller.this.m_5448_(), (float)Firecaller.this.m_8085_(), (float)Firecaller.this.m_8132_());
            }
        }
    }

    public class ConjureSkullGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public ConjureSkullGoal() {
            super((SpellcasterIllager)Firecaller.this);
        }

        private List<LivingEntity> getTargets() {
            return Firecaller.this.m_9236_().m_6443_(LivingEntity.class, Firecaller.this.m_20191_().m_82400_(5.0), entity -> entity instanceof Player || entity instanceof IronGolem);
        }

        public boolean m_8036_() {
            if (Firecaller.this.m_5448_() == null) {
                return false;
            }
            if (Firecaller.this.conjureSkullCooldown > 0) {
                return false;
            }
            return Firecaller.this.conjureSkullCooldown < 0 && !Firecaller.this.m_33736_() && this.getTargets().isEmpty();
        }

        public void m_8037_() {
            if (Firecaller.this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)Firecaller.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, Firecaller.this.m_20185_(), Firecaller.this.m_20186_() + 2.5, Firecaller.this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.05);
                ((ServerLevel)Firecaller.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123755_, Firecaller.this.m_20185_(), Firecaller.this.m_20186_() + 2.5, Firecaller.this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.05);
            }
            super.m_8037_();
        }

        private void shootSkullAt(LivingEntity target) {
            this.shootSkullAt(target.m_20185_(), target.m_20186_() + (double)target.m_20192_() * 0.5, target.m_20189_());
        }

        private void shootSkullAt(double targetX, double targetY, double targetZ) {
            double d = Firecaller.this.m_20185_();
            double e = Firecaller.this.m_20186_() + 2.5;
            double f = Firecaller.this.m_20189_();
            double g = targetX - d;
            double h = targetY - e;
            double i = targetZ - f;
            FlyingMagma Magma = new FlyingMagma(Firecaller.this.m_9236_(), (LivingEntity)Firecaller.this, g, h, i);
            Magma.m_5602_((Entity)Firecaller.this);
            Magma.m_20343_(d, e, f);
            Firecaller.this.m_9236_().m_7967_((Entity)Magma);
        }

        protected void m_8130_() {
            this.shootSkullAt(Firecaller.this.m_5448_());
            if (Firecaller.this.m_9236_() instanceof ServerLevel) {
                double x = Firecaller.this.m_20185_();
                double y = Firecaller.this.m_20186_() + 2.5;
                double z = Firecaller.this.m_20189_();
                ((ServerLevel)Firecaller.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 40, 0.4, 0.4, 0.4, 0.15);
            }
            Firecaller.this.conjureSkullCooldown = 160;
        }

        protected int m_8069_() {
            return 60;
        }

        protected int m_8089_() {
            return 60;
        }

        protected int m_8067_() {
            return 400;
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModRegistry.FIRECALLER_CAST_SOUND_EVENT.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return SpellcasterIllager.IllagerSpell.WOLOLO;
        }
    }

    public class AreaDamageGoal
    extends SpellcasterIllager.SpellcasterUseSpellGoal {
        public AreaDamageGoal() {
            super((SpellcasterIllager)Firecaller.this);
        }

        public boolean m_8036_() {
            if (Firecaller.this.m_5448_() == null) {
                return false;
            }
            if (Firecaller.this.m_33736_()) {
                return false;
            }
            return Firecaller.this.areaDamageCooldown <= 0;
        }

        private List<LivingEntity> getTargets() {
            return Firecaller.this.m_9236_().m_6443_(LivingEntity.class, Firecaller.this.m_20191_().m_82400_(6.0), entity -> !(entity instanceof AbstractIllager) && !(entity instanceof Surrendered) && !(entity instanceof Ravager));
        }

        private void buff(LivingEntity entity) {
            entity.m_5997_(0.0, (double)1.2f, 0.0);
            entity.m_6469_(Firecaller.this.m_269291_().m_269425_(), 6.0f);
            entity.m_7311_(120);
            double x = entity.m_20185_();
            double y = entity.m_20186_() + 1.0;
            double z = entity.m_20189_();
            ((ServerLevel)Firecaller.this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123762_, x, y + 1.0, z, 10, 0.2, 0.2, 0.2, 0.015);
            BlockPos blockPos = entity.m_20183_();
            Firecaller.this.m_9236_().m_46597_(blockPos, Blocks.f_50083_.m_49966_());
        }

        protected void m_8130_() {
            this.getTargets().forEach(this::buff);
            Firecaller.this.areaDamageCooldown = 300;
        }

        protected int m_8069_() {
            return 50;
        }

        protected int m_8089_() {
            return 50;
        }

        protected int m_8067_() {
            return 400;
        }

        protected SoundEvent m_7030_() {
            return (SoundEvent)ModRegistry.FIRECALLER_CAST_SOUND_EVENT.get();
        }

        protected SpellcasterIllager.IllagerSpell m_7269_() {
            return (SpellcasterIllager.IllagerSpell)ModRegistry.PROVOKE_ILLAGER_SPELL;
        }
    }
}

