/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.whats_your_build.world.loadout.load;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import me.clefal.whats_your_build.world.loadout.load.ItemLoadDescriber;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class VanillaItemLoadDescriber
extends ItemLoadDescriber {
    public static final String TYPE = "vanilla_item_load_describer";
    public static final MapCodec<VanillaItemLoadDescriber> CODEC = RecordCodecBuilder.mapCodec(vanillaItemLoadDescriberInstance -> vanillaItemLoadDescriberInstance.group((App)ItemStack.f_41582_.listOf().fieldOf("itemstacks").forGetter(x -> (List)x.target)).apply((Applicative)vanillaItemLoadDescriberInstance, VanillaItemLoadDescriber::new));

    public VanillaItemLoadDescriber(List<ItemStack> target) {
        super(target);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void tryWear(ServerPlayer player, Container armory) {
        List<ItemStack> itemStacks = VanillaItemLoadDescriber.getArmory(armory);
        for (ItemStack buildStack : (List)this.target) {
            itemStacks.stream().filter(x -> ItemStack.m_41728_((ItemStack)x, (ItemStack)buildStack)).findFirst().ifPresent(sameItem -> {
                EquipmentSlot equipmentslot = ServerPlayer.m_147233_((ItemStack)buildStack);
                InventoryMenu inventoryMenu = player.f_36095_;
                if (equipmentslot.m_20743_() == EquipmentSlot.Type.ARMOR) {
                    int targetPosition = 8 - equipmentslot.m_20749_();
                    this.equipAndConsumeSource((Player)player, inventoryMenu, targetPosition, equipmentslot, buildStack, (ItemStack)sameItem);
                } else if (equipmentslot.equals((Object)EquipmentSlot.OFFHAND)) {
                    int targetPosition = 45;
                    this.equipAndConsumeSource((Player)player, inventoryMenu, targetPosition, equipmentslot, buildStack, (ItemStack)sameItem);
                } else if (equipmentslot.equals((Object)EquipmentSlot.MAINHAND)) {
                    this.giveToMainHandOrDrop((Player)player, buildStack, (ItemStack)sameItem);
                }
            });
        }
    }

    private boolean equipOrSwap(Player player, InventoryMenu inventoryMenu, int slotIndex, EquipmentSlot equipmentslot, ItemStack newItem) {
        if (((Slot)inventoryMenu.f_38839_.get(slotIndex)).m_6657_()) {
            ItemStack oldEquipment = ((Slot)inventoryMenu.f_38839_.get(slotIndex)).m_7993_();
            if (ItemStack.m_41728_((ItemStack)oldEquipment, (ItemStack)newItem)) {
                return false;
            }
            if (!player.m_36356_(oldEquipment)) {
                player.m_5552_(oldEquipment, 1.0f);
            }
        }
        player.m_8061_(equipmentslot, newItem);
        return true;
    }

    private void equipAndConsumeSource(Player player, InventoryMenu inventoryMenu, int slotIndex, EquipmentSlot equipmentslot, ItemStack newItem, ItemStack sourceItem) {
        if (this.equipOrSwap(player, inventoryMenu, slotIndex, equipmentslot, newItem)) {
            sourceItem.m_41764_(0);
        }
    }

    private void giveToMainHandOrDrop(Player player, ItemStack newItem, ItemStack sourceItem) {
        if (!player.m_36356_(newItem)) {
            player.m_5552_(newItem, 1.0f);
        }
        sourceItem.m_41764_(0);
    }
}

