/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.whats_your_build.data.modules.compat.mas.talent;

import com.clefal.nirvana_lib.relocated.io.vavr.API;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import com.robertx22.mine_and_slash.saveclasses.perks.SchoolData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import me.clefal.whats_your_build.data.handler.IBuildComponent;
import me.clefal.whats_your_build.mixinhelper.ISchoolDataGetter;

public class MASSkillComponent
implements IBuildComponent<MASSkillComponent> {
    public static final String ID = "mine_and_slash";
    public static final Codec<PointData> POINT_DATA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(x -> x.x), (App)Codec.INT.fieldOf("y").forGetter(x -> x.y)).apply((Applicative)instance, PointData::new));
    public static final Codec<SchoolData> SCHOOL_DATA_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)POINT_DATA_CODEC.listOf().fieldOf("points").forGetter(x -> new ArrayList<PointData>(((ISchoolDataGetter)x).getPoints()))).apply((Applicative)instance, x -> {
        SchoolData schoolData = new SchoolData();
        x.forEach(arg_0 -> ((SchoolData)schoolData).allocate(arg_0));
        return schoolData;
    }));
    public static final MapCodec<MASSkillComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING.xmap(TalentTree.SchoolType::valueOf, Enum::toString), SCHOOL_DATA_CODEC).fieldOf("skills").forGetter(x -> x.perks)).apply((Applicative)instance, MASSkillComponent::new));
    private Map<TalentTree.SchoolType, SchoolData> perks;

    public MASSkillComponent(Map<TalentTree.SchoolType, SchoolData> perks) {
        this.perks = perks;
    }

    public Map<TalentTree.SchoolType, SchoolData> getPerks() {
        HashMap<TalentTree.SchoolType, SchoolData> map = new HashMap<TalentTree.SchoolType, SchoolData>();
        this.perks.entrySet().stream().map(x -> {
            Set<PointData> points = ((ISchoolDataGetter)x.getValue()).getPoints();
            SchoolData schoolData = new SchoolData();
            for (PointData point : points) {
                schoolData.allocate(new PointData(point.x, point.y));
            }
            return API.Tuple((Object)((TalentTree.SchoolType)x.getKey()), (Object)schoolData);
        }).forEach(x -> map.put((TalentTree.SchoolType)x._1(), (SchoolData)x._2()));
        return map;
    }

    @Override
    public byte getHandlerIndex() {
        return 2;
    }

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public MapCodec<MASSkillComponent> getCodec() {
        return CODEC;
    }
}

