/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.whats_your_build.data.modules.armor;

import com.clefal.nirvana_lib.relocated.io.vavr.Tuple;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import me.clefal.whats_your_build.data.handler.IItemBuildComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class VanillaArmorComponent
implements IItemBuildComponent<VanillaArmorComponent> {
    public static final String ID = "vanilla_armor";
    public static final MapCodec<VanillaArmorComponent> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.unboundedMap((Codec)Codec.STRING.xmap(EquipmentSlot::m_20747_, EquipmentSlot::m_20751_), (Codec)ItemStack.f_41582_).fieldOf("armors").forGetter(x -> {
        HashMap<EquipmentSlot, ItemStack> equipmentSlotItemStackHashMap = new HashMap<EquipmentSlot, ItemStack>(x.armors);
        x.armors.entrySet().stream().filter(entry -> ((ItemStack)entry.getValue()).m_41619_()).map(Map.Entry::getKey).forEach(equipmentSlotItemStackHashMap::remove);
        return equipmentSlotItemStackHashMap;
    })).apply((Applicative)i, VanillaArmorComponent::new));
    public Map<EquipmentSlot, ItemStack> armors;

    public VanillaArmorComponent(Map<EquipmentSlot, ItemStack> armors) {
        this.armors = Stream.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND).map(x -> Tuple.of((Object)x, (Object)armors.getOrDefault(x, ItemStack.f_41583_))).collect(HashMap::new, (equipmentSlotItemStackHashMap, equipmentSlotItemStackTuple2) -> equipmentSlotItemStackHashMap.put((EquipmentSlot)equipmentSlotItemStackTuple2._1, (ItemStack)equipmentSlotItemStackTuple2._2), HashMap::putAll);
    }

    private VanillaArmorComponent(List<ItemStack> itemStacks) {
        if (itemStacks.size() != 6) {
            throw new RuntimeException("illegally invoke this constructor!");
        }
        List<EquipmentSlot> head = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND);
        this.armors = IntStream.rangeClosed(0, 5).boxed().map(x -> Tuple.of((Object)((EquipmentSlot)head.get((int)x)), (Object)((ItemStack)itemStacks.get((int)x)))).collect(HashMap::new, (equipmentSlotItemStackHashMap, equipmentSlotItemStackTuple2) -> equipmentSlotItemStackHashMap.put((EquipmentSlot)equipmentSlotItemStackTuple2._1, (ItemStack)equipmentSlotItemStackTuple2._2), HashMap::putAll);
    }

    @Override
    public byte getHandlerIndex() {
        return 0;
    }

    @Override
    public String getIdentifier() {
        return ID;
    }

    @Override
    public MapCodec<VanillaArmorComponent> getCodec() {
        return CODEC;
    }

    @Override
    public VanillaArmorComponent copy() {
        HashMap<EquipmentSlot, ItemStack> equipmentSlotItemStackHashMap = new HashMap<EquipmentSlot, ItemStack>();
        for (Map.Entry<EquipmentSlot, ItemStack> equipmentSlotItemStackEntry : this.armors.entrySet()) {
            equipmentSlotItemStackHashMap.put(equipmentSlotItemStackEntry.getKey(), equipmentSlotItemStackEntry.getValue().m_41777_());
        }
        return new VanillaArmorComponent(new EnumMap<EquipmentSlot, ItemStack>(equipmentSlotItemStackHashMap));
    }

    @Override
    public VanillaArmorComponent makeCleanCopy() {
        HashMap<EquipmentSlot, ItemStack> objectObjectHashMap = new HashMap<EquipmentSlot, ItemStack>();
        this.armors.forEach((x, y) -> objectObjectHashMap.put((EquipmentSlot)x, ItemStack.f_41583_));
        return new VanillaArmorComponent(objectObjectHashMap);
    }

    @Override
    public Container asContainer() {
        List<EquipmentSlot> list = List.of(EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND);
        SimpleContainer simpleContainer = new SimpleContainer(list.size());
        for (int i = 0; i < simpleContainer.m_6643_(); ++i) {
            simpleContainer.m_6836_(i, this.armors.getOrDefault(list.get(i), ItemStack.f_41583_));
        }
        return simpleContainer;
    }

    @Override
    public VanillaArmorComponent getFromContainer(Container container) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (int i = 0; i < 6; ++i) {
            itemStacks.add(container.m_8020_(i));
        }
        return new VanillaArmorComponent(itemStacks);
    }
}

