/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.whats_your_build.data.handler;

import com.clefal.nirvana_lib.relocated.io.vavr.API;
import com.clefal.nirvana_lib.relocated.io.vavr.collection.Iterator;
import com.clefal.nirvana_lib.relocated.io.vavr.collection.List;
import com.clefal.nirvana_lib.relocated.io.vavr.collection.Map;
import com.clefal.nirvana_lib.relocated.io.vavr.collection.Seq;
import com.clefal.nirvana_lib.utils.SideUtils;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import me.clefal.whats_your_build.client.screen.WYBScreen;
import me.clefal.whats_your_build.client.screen.buildscreen.BuildMenuTab;
import me.clefal.whats_your_build.data.buildobject.Build;
import me.clefal.whats_your_build.data.handler.IBuildComponent;
import me.clefal.whats_your_build.data.handler.IComponentClientHandler;
import me.clefal.whats_your_build.data.handler.IComponentServerHandler;
import me.clefal.whats_your_build.data.modules.ModulesManager;
import me.clefal.whats_your_build.world.IRewritable;

public class HandlerManager {
    private static HandlerManager INSTANCE;
    private final java.util.List<IComponentServerHandler> serverHandlers = new ArrayList<IComponentServerHandler>();
    private final java.util.List<IComponentClientHandler> clientHandlers = new ArrayList<IComponentClientHandler>();

    public static HandlerManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new HandlerManager();
        }
        return INSTANCE;
    }

    public void addHandlers(IComponentServerHandler serverHandler, safeInvoker clientHandler) {
        if (!this.serverHandlers.contains(serverHandler)) {
            this.serverHandlers.add(serverHandler.getIndex(), serverHandler);
        }
        if (!this.clientHandlers.contains(clientHandler) && SideUtils.isClient()) {
            this.clientHandlers.add(((IComponentClientHandler)((Supplier)clientHandler.get()).get()).getIndex(), (IComponentClientHandler)((Supplier)clientHandler.get()).get());
        }
    }

    public Iterator<IComponentServerHandler> forServerHandlers() {
        return API.For(this.serverHandlers).yield();
    }

    public Iterator<IComponentClientHandler> forClientHandlers() {
        return API.For(this.clientHandlers).yield();
    }

    public List<BiFunction<WYBScreen<?>, IRewritable, BuildMenuTab<?>>> getImmutableBuildMenuTabFunction(Build build) {
        Map<Byte, IBuildComponent<?>> components = build.getComponents();
        return this.getClientHandlers(build).map(x -> x.getBuildMenuTabFunction((IBuildComponent)components.get((Object)x.getIndex()).get())).toList();
    }

    public List<BiFunction<WYBScreen<?>, IRewritable, BuildMenuTab<?>>> getWritableBuildMenuTabFunction(Build build) {
        Map<Byte, IBuildComponent<?>> components = build.getComponents();
        return this.getClientHandlers(build).map(x -> x.getBuildMenuTabFunction((IBuildComponent)components.get((Object)x.getIndex()).get())).toList();
    }

    public Seq<IComponentClientHandler> getClientHandlers(Build build) {
        return build.getComponents().values().map(x -> this.clientHandlers.get(x.getHandlerIndex()));
    }

    static {
        ModulesManager.init();
    }

    public static abstract class safeInvoker
    implements Supplier<Supplier<IComponentClientHandler>> {
    }
}

