/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.whats_your_build.data.buildobject;

import com.clefal.nirvana_lib.relocated.io.vavr.Tuple;
import com.clefal.nirvana_lib.relocated.io.vavr.collection.List;
import com.clefal.nirvana_lib.relocated.io.vavr.collection.Map;
import com.google.common.base.Objects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Comparator;
import lombok.Generated;
import me.clefal.whats_your_build.data.IPersistedObject;
import me.clefal.whats_your_build.data.handler.IBuildComponent;
import me.clefal.whats_your_build.data.handler.IItemBuildComponent;
import me.clefal.whats_your_build.network.INetworkObject;
import net.minecraft.network.FriendlyByteBuf;

public class Build
implements INetworkObject,
IPersistedObject<Build> {
    public static final Codec<Build> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(x -> x.name), (App)IBuildComponent.COMPONENT_CODEC.listOf().fieldOf("components").forGetter(x -> x.components.values().asJava())).apply((Applicative)instance, (x, y) -> new Build((List<IBuildComponent<?>>)List.ofAll((Iterable)y), (String)x)));
    public static final Build EMPTY = new Build(List.empty(), "empty");
    private Map<Byte, IBuildComponent<?>> components;
    public String name;

    public Build(List<IBuildComponent<?>> components, String name) {
        this.components = components.toSortedMap(Comparator.naturalOrder(), x -> Tuple.of((Object)x.getHandlerIndex(), (Object)x));
        this.name = name;
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    @Override
    public Codec<Build> getCodec() {
        return CODEC;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_272073_(CODEC, (Object)this);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.components = ((Build)buf.m_271872_(Build.CODEC)).components;
    }

    public Build copy() {
        return new Build(this.components.values().toList(), this.name);
    }

    public Build cleanCopy() {
        return new Build(List.narrow((List)this.components.mapValues(x -> {
            if (x instanceof IItemBuildComponent) {
                IItemBuildComponent itemBuildComponent = (IItemBuildComponent)x;
                return itemBuildComponent.makeCleanCopy();
            }
            return x;
        }).values().toList()), this.name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Build)) {
            return false;
        }
        Build build = (Build)object;
        return Objects.equal(this.components, build.components) && Objects.equal((Object)this.name, (Object)build.name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.components, this.name});
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Map<Byte, IBuildComponent<?>> getComponents() {
        return this.components;
    }
}

