/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.whats_your_build.client.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.clefal.whats_your_build.Constants;
import me.clefal.whats_your_build.data.buildobject.Build;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import org.slf4j.Logger;

public class LoadoutsClientHandler {
    public static final Path buildsLocation = Path.of(Minecraft.m_91087_().f_91069_ + "/wyb/builds/", new String[0]);

    public static void writeToLocal(Build build) throws IOException {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            UUID uuid = player.m_20148_();
            Path playerFolder = buildsLocation.resolve(uuid.toString());
            Files.createDirectories(playerFolder, new FileAttribute[0]);
            String buildFileName = build.name + ".json";
            Path buildFile = playerFolder.resolve(buildFileName);
            JsonElement json = (JsonElement)Build.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)build).getOrThrow(false, arg_0 -> ((Logger)Constants.LOG).error(arg_0));
            try (BufferedWriter writer = Files.newBufferedWriter(buildFile, new OpenOption[0]);){
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                gson.toJson(json, (Appendable)writer);
            }
        }
    }

    public static void deleteFromLocal(String buildFileName) throws IOException {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            Path buildFile;
            UUID uuid = player.m_20148_();
            Path playerFolder = buildsLocation.resolve(uuid.toString());
            if (!((String)buildFileName).endsWith(".json")) {
                buildFileName = (String)buildFileName + ".json";
            }
            if (Files.exists(buildFile = playerFolder.resolve((String)buildFileName), new LinkOption[0])) {
                Files.delete(buildFile);
                Constants.LOG.info("Deleted build file: {}", (Object)buildFile);
            } else {
                Constants.LOG.warn("Build file not found: {}", (Object)buildFile);
            }
        }
    }

    public static List<Build> readAllFromLocal(UUID playerUUID) throws IOException {
        ArrayList<Build> builds = new ArrayList<Build>();
        Path playerFolder = buildsLocation.resolve(playerUUID.toString());
        if (!Files.exists(playerFolder, new LinkOption[0]) || !Files.isDirectory(playerFolder, new LinkOption[0])) {
            Constants.LOG.debug("non-exist directory: {}, return empty list.", (Object)playerFolder);
            Files.createDirectories(playerFolder, new FileAttribute[0]);
            return builds;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(playerFolder, "*.json");){
            for (Path file : stream) {
                try {
                    BufferedReader reader = Files.newBufferedReader(file);
                    try {
                        Build.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).resultOrPartial(string -> Constants.LOG.error("Invalid element while loading build file {}: {}", (Object)file, string)).map(Pair::getFirst).ifPresent(builds::add);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    Constants.LOG.error("Failed to load build file: {}", (Object)file, (Object)e);
                }
            }
        }
        return builds;
    }
}

