/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.whats_your_build.client.screen.loadoutscreen;

import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import me.clefal.whats_your_build.CommonClass;
import me.clefal.whats_your_build.Constants;
import me.clefal.whats_your_build.client.screen.loadoutscreen.BuildEntryState;
import me.clefal.whats_your_build.client.screen.loadoutscreen.LoadoutScreen;
import me.clefal.whats_your_build.client.screen.loadoutscreen.components.BuildEntryFunctionButton;
import me.clefal.whats_your_build.client.storage.LoadoutsClientHandler;
import me.clefal.whats_your_build.data.buildobject.Build;
import me.clefal.whats_your_build.utils.WidgetHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class LoadoutSelectionList
extends AbstractSelectionList<BuildEntry> {
    static final int WIDTH = 244;
    static final int HEIGHT = 12;
    protected final LoadoutScreen screen;
    private Queue<BuildEntry> deletedEntry;
    private static final ResourceLocation BACKGROUND = CommonClass.gui("sprites/loadout/menu_button_background");
    private final BiFunction<String, BuildEntryFunctionButton.EntryAction, BuildEntryFunctionButton> getButton;
    public final BuildEntryFunctionButton save;
    public final BuildEntryFunctionButton reset;
    public final BuildEntryFunctionButton clear;
    public final BuildEntryFunctionButton delete;

    public LoadoutSelectionList(int width, int height, int y0, int y1, LoadoutScreen screen) {
        super(Minecraft.m_91087_(), width, height, y0, y1, 12);
        this.m_93473_(false, 0);
        this.m_93488_(false);
        this.m_93496_(false);
        this.m_93471_(false);
        this.screen = screen;
        this.deletedEntry = new ArrayDeque<BuildEntry>();
        this.getButton = (string, action) -> (BuildEntryFunctionButton)((Object)((Object)Util.m_137537_(() -> {
            BuildEntryFunctionButton buildEntryFunctionButton = new BuildEntryFunctionButton((String)string, this, (BuildEntryFunctionButton.EntryAction)action, (Component)Component.m_237115_((String)("wyb.screen.loadout.right_click_menu." + string)), screen.vertexContainer){

                public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
                    PoseStack pose = guiGraphics.m_280168_();
                    pose.m_85836_();
                    guiGraphics.m_280411_(BACKGROUND, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 0.0f, 0.0f, 34, 10, 34, 10);
                    pose.m_252880_(4.0f, 4.0f, 0.0f);
                    pose.m_252880_(10.5f, 0.0f, 0.0f);
                    guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, this.m_6035_().getString(), this.m_252754_(), this.m_252907_(), ChatFormatting.WHITE.m_126665_().intValue());
                    pose.m_85849_();
                }
            };
            WidgetHelper.setSize((AbstractWidget)buildEntryFunctionButton, 51, 15);
            return buildEntryFunctionButton;
        })));
        this.save = this.getButton.apply("save", button -> button.entry.save(screen));
        this.reset = this.getButton.apply("reset", button -> button.entry.abortChanges());
        this.clear = this.getButton.apply("clear", button -> button.entry.clear());
        this.delete = this.getButton.apply("delete", button -> {
            LoadoutSelectionList list1 = button.list;
            list1.m_93502_(button.entry);
            try {
                LoadoutsClientHandler.deleteFromLocal(button.entry.currentState.presentBuild().name);
            }
            catch (IOException e) {
                Constants.LOG.error("Failed to load builds from local when delete entry: {}", (Object)button.entry.currentState.presentBuild().name, (Object)e);
            }
            list1.m_7522_(null);
        });
    }

    public void addBuildsOnInit(List<Build> builds) {
        for (Build build : builds) {
            this.m_7085_(new BuildEntry(build));
        }
    }

    @javax.annotation.Nullable
    public BuildEntry getCurrentEntry(double mouseX, double mouseY) {
        return (BuildEntry)this.m_93412_(mouseX, mouseY);
    }

    protected void addSelfBuildEntry(Build build) {
        List<Object> builds;
        try {
            builds = LoadoutsClientHandler.readAllFromLocal(Minecraft.m_91087_().f_91074_.m_20148_());
        }
        catch (IOException e) {
            builds = List.of();
            Constants.LOG.error("Failed to load builds from local when add new entry: {}", (Object)String.valueOf(e));
        }
        Set collect = builds.stream().map(Build::getName).collect(Collectors.toSet());
        Object name = Component.m_237110_((String)"wyb.screen.loadout.initial_build_name", (Object[])new Object[]{this.m_6702_().size()}).getString();
        while (collect.contains(name)) {
            name = (String)name + "(1)";
        }
        build.name = name;
        this.m_7085_(new BuildEntry(build));
    }

    public void renderHoveredTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        BuildEntryState buildEntryState;
        if (this.m_168795_() != null && (buildEntryState = ((BuildEntry)this.m_168795_()).currentState) instanceof BuildEntryState.Editing) {
            BuildEntryState.Editing editing = (BuildEntryState.Editing)buildEntryState;
            if (editing.isEdited) {
                guiGraphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237115_((String)"wyb.screen.loadout.save_tip"), mouseX, mouseY);
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean b = super.m_6375_(mouseX, mouseY, button);
        for (BuildEntry buildEntry : this.deletedEntry) {
            this.m_93502_(buildEntry);
        }
        this.deletedEntry.clear();
        return b;
    }

    public boolean noBuild() {
        return this.getCurrentBuild() == Build.EMPTY;
    }

    public Build getCurrentBuild() {
        if (this.m_7222_() != null) {
            return ((BuildEntry)this.m_7222_()).currentState.presentBuild();
        }
        return Build.EMPTY;
    }

    public int m_5759_() {
        return this.f_93388_;
    }

    protected int m_5756_() {
        return this.f_93393_ + this.f_93388_ + 999;
    }

    public void m_7522_(@Nullable GuiEventListener focused) {
        if (this.m_7222_() != null) {
            if (((Object)((Object)((BuildEntry)this.m_7222_()))).equals(focused)) {
                return;
            }
            ((BuildEntry)this.m_7222_()).changeState(new BuildEntryState.Waiting((BuildEntry)this.m_7222_()));
        }
        super.m_7522_(focused);
        if (focused instanceof BuildEntry) {
            BuildEntry buildEntry = (BuildEntry)focused;
            buildEntry.changeState(new BuildEntryState.Editing(buildEntry));
        }
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public class BuildEntry
    extends AbstractSelectionList.Entry<BuildEntry> {
        BuildEntryState currentState;

        public BuildEntry(Build storageBuild) {
            BuildEntryState.Waiting waiting = new BuildEntryState.Waiting(this);
            waiting.storageBuild = storageBuild;
            this.changeState(waiting);
        }

        protected void changeState(BuildEntryState state) {
            if (this.currentState != null) {
                this.currentState.onChangeState(state);
            }
            this.currentState = state;
            LoadoutSelectionList.this.screen.handleBuild(this.currentState.presentBuild());
            LoadoutSelectionList.this.screen.rewriteSlotsToFirst();
            if (state instanceof BuildEntryState.Editing) {
                LoadoutSelectionList.this.screen.setCurrentEditingEntry(this);
            } else {
                LoadoutSelectionList.this.screen.setCurrentEditingEntry(null);
            }
        }

        private void save(LoadoutScreen screen) {
            this.currentState.save(screen);
            screen.handleBuild(this.currentState.presentBuild());
            screen.rewriteSlots(screen.currentAt);
        }

        private void abortChanges() {
            this.currentState.abortChanges();
            if (!LoadoutSelectionList.this.screen.currentAt.isEmpty()) {
                LoadoutSelectionList.this.screen.rewriteSlots(LoadoutSelectionList.this.screen.currentAt);
            }
        }

        private void clear() {
            this.currentState.clear();
            LoadoutSelectionList.this.screen.handleBuild(this.currentState.presentBuild());
            LoadoutSelectionList.this.screen.rewriteSlotsToFirst();
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            boolean flag = false;
            return flag || this.m_5953_(mouseX, mouseY);
        }

        public void m_274437_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick) {
            this.currentState.renderBack(guiGraphics, index, top, left, width, height, mouseX, mouseY, isMouseOver, partialTick, LoadoutSelectionList.this.screen.vertexContainer);
        }
    }
}

