/*
 * Decompiled with CFR 0.152.
 */
package me.clefal.whats_your_build.client.screen.loadoutscreen;

import com.clefal.nirvana_lib.client.render.batch.VertexContainer;
import com.clefal.nirvana_lib.relocated.io.vavr.Tuple;
import com.clefal.nirvana_lib.relocated.io.vavr.collection.List;
import com.clefal.nirvana_lib.relocated.io.vavr.collection.Map;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.IOException;
import java.util.LinkedHashMap;
import me.clefal.whats_your_build.Constants;
import me.clefal.whats_your_build.client.screen.loadoutscreen.LoadoutScreen;
import me.clefal.whats_your_build.client.screen.loadoutscreen.LoadoutSelectionList;
import me.clefal.whats_your_build.client.storage.LoadoutsClientHandler;
import me.clefal.whats_your_build.data.buildobject.Build;
import me.clefal.whats_your_build.data.handler.IItemBuildComponent;
import me.clefal.whats_your_build.data.modules.compat.mas.talent.MASSkillComponent;
import me.clefal.whats_your_build.data.modules.compat.mas.talent.client.MASSkillViewButton;
import me.clefal.whats_your_build.mixinhelper.ITalentDataGetter;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;

public abstract class BuildEntryState {
    protected final LoadoutSelectionList.BuildEntry buildEntry;

    protected BuildEntryState(LoadoutSelectionList.BuildEntry buildEntry) {
        this.buildEntry = buildEntry;
    }

    public abstract void onChangeState(BuildEntryState var1);

    public abstract void save(LoadoutScreen var1);

    public abstract void abortChanges();

    public abstract void clear();

    public abstract Build presentBuild();

    public abstract void mouseClick(double var1, double var3, int var5);

    public abstract void renderBack(GuiGraphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10, VertexContainer var11);

    public static BuildEntryState getEditingState(LoadoutSelectionList.BuildEntry entry) {
        return new Editing(entry);
    }

    public static BuildEntryState getWaitingState(LoadoutSelectionList.BuildEntry entry, Build build) {
        Waiting waiting = new Waiting(entry);
        waiting.storageBuild = build;
        return waiting;
    }

    public static class Editing
    extends BuildEntryState {
        public Build baseBuild;
        public boolean isEdited = false;

        protected Editing(LoadoutSelectionList.BuildEntry buildEntry) {
            super(buildEntry);
        }

        @Override
        public void onChangeState(BuildEntryState next) {
            if (next instanceof Waiting) {
                Waiting waiting = (Waiting)next;
                waiting.storageBuild = this.baseBuild.copy();
            }
        }

        @Override
        public void save(LoadoutScreen screen) {
            Map map = this.baseBuild.getComponents().map((b, c) -> Tuple.of((Object)c.getIdentifier(), (Object)c));
            LinkedHashMap<String, NonNullList<Slot>> slotMap = screen.getSlotMap();
            this.baseBuild = (Build)map.map((string, component) -> {
                List<? extends AbstractWidget> abstractWidgets;
                if (component instanceof IItemBuildComponent) {
                    IItemBuildComponent itemBuildComponent = (IItemBuildComponent)component;
                    NonNullList slots = (NonNullList)slotMap.get(string);
                    if (slots != null) {
                        Object fromContainer = itemBuildComponent.getFromContainer(((Slot)slots.get((int)0)).f_40218_);
                        return Tuple.of((Object)string, fromContainer);
                    }
                } else if (component instanceof MASSkillComponent && (abstractWidgets = screen.getWidgets().get("mine_and_slash")) != null) {
                    ITalentDataGetter talents = (ITalentDataGetter)((MASSkillViewButton)((Object)((Object)abstractWidgets.get((int)0)))).data.talents;
                    return Tuple.of((Object)"mine_and_slash", (Object)new MASSkillComponent(talents.getPerks()));
                }
                return Tuple.of((Object)string, (Object)component);
            }).transform(x -> new Build(List.ofAll((Iterable)x.values()), this.baseBuild.name));
            try {
                LoadoutsClientHandler.writeToLocal(this.baseBuild);
            }
            catch (IOException e) {
                Constants.LOG.error("Failed to save build: {}", (Object)this.baseBuild.name, (Object)e);
            }
            this.isEdited = false;
        }

        @Override
        public void abortChanges() {
        }

        @Override
        public void clear() {
            this.baseBuild = this.baseBuild.cleanCopy();
        }

        @Override
        public Build presentBuild() {
            return this.baseBuild;
        }

        @Override
        public void mouseClick(double mouseX, double mouseY, int button) {
        }

        @Override
        public void renderBack(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick, VertexContainer vertexContainer) {
            Font font = Minecraft.m_91087_().f_91062_;
            if (isMouseOver || this.buildEntry.m_93696_()) {
                guiGraphics.m_280430_(font, (Component)Component.m_237113_((String)"\u27a4").m_130940_(ChatFormatting.WHITE), left + 1, top - 1, ChatFormatting.WHITE.m_126665_().intValue());
                guiGraphics.m_280488_(font, this.presentBuild().name, left + 10, top - 1, ChatFormatting.WHITE.m_126665_().intValue());
            } else {
                guiGraphics.m_280488_(font, this.presentBuild().name, left, top, ChatFormatting.WHITE.m_126665_().intValue());
            }
            if (this.isEdited) {
                PoseStack pose = guiGraphics.m_280168_();
                pose.m_85836_();
                pose.m_252880_((float)(font.m_92895_(this.presentBuild().name) + 5), 0.0f, 0.0f);
                guiGraphics.m_280430_(font, (Component)Component.m_237113_((String)"!"), left, top, ChatFormatting.YELLOW.m_126665_().intValue());
                pose.m_85849_();
            }
        }
    }

    public static class Waiting
    extends BuildEntryState {
        public Build storageBuild;

        protected Waiting(LoadoutSelectionList.BuildEntry buildEntry) {
            super(buildEntry);
        }

        @Override
        public void onChangeState(BuildEntryState next) {
            if (next instanceof Editing) {
                Build copy;
                Editing editing = (Editing)next;
                editing.baseBuild = copy = this.storageBuild.copy();
            }
        }

        @Override
        public void save(LoadoutScreen screen) {
        }

        @Override
        public void abortChanges() {
        }

        @Override
        public void clear() {
        }

        @Override
        public Build presentBuild() {
            return this.storageBuild;
        }

        @Override
        public void mouseClick(double mouseX, double mouseY, int button) {
        }

        @Override
        public void renderBack(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isMouseOver, float partialTick, VertexContainer vertexContainer) {
            if (isMouseOver || this.buildEntry.m_93696_()) {
                guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, this.presentBuild().name, left + 1, top - 1, ChatFormatting.WHITE.m_126665_().intValue());
            } else {
                guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, this.presentBuild().name, left, top, ChatFormatting.WHITE.m_126665_().intValue());
            }
        }
    }
}

