/*
 * Decompiled with CFR 0.152.
 */
package alternate.current.wire;

import alternate.current.wire.LevelHelper;
import alternate.current.wire.Node;
import alternate.current.wire.WireConnectionManager;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WireNode
extends Node {
    final WireConnectionManager connections;
    int currentPower;
    int virtualPower;
    int externalPower;
    int flowIn;
    int iFlowDir;
    boolean added;
    boolean removed;
    boolean shouldBreak;
    boolean root;
    boolean discovered;
    boolean searched;
    WireNode next_wire;

    WireNode(ServerLevel level, BlockPos pos, BlockState state) {
        super(level);
        this.pos = pos.m_7949_();
        this.state = state;
        this.connections = new WireConnectionManager(this);
        this.virtualPower = this.currentPower = ((Integer)this.state.m_61143_((Property)RedStoneWireBlock.f_55500_)).intValue();
        this.priority = this.priority();
    }

    @Override
    Node set(BlockPos pos, BlockState state, boolean clearNeighbors) {
        throw new UnsupportedOperationException("Cannot update a WireNode!");
    }

    @Override
    int priority() {
        return Mth.m_14045_((int)this.virtualPower, (int)0, (int)15);
    }

    @Override
    public boolean isWire() {
        return true;
    }

    @Override
    public WireNode asWire() {
        return this;
    }

    boolean offerPower(int power, int iDir) {
        if (this.removed || this.shouldBreak) {
            return false;
        }
        if (power == this.virtualPower) {
            this.flowIn |= 1 << iDir;
            return false;
        }
        if (power > this.virtualPower) {
            this.virtualPower = power;
            this.flowIn = 1 << iDir;
            return true;
        }
        return false;
    }

    boolean setPower() {
        if (this.removed) {
            return true;
        }
        this.state = this.level.m_8055_(this.pos);
        if (!this.state.m_60713_(Blocks.f_50088_)) {
            return false;
        }
        if (this.shouldBreak) {
            Block.m_49950_((BlockState)this.state, (Level)this.level, (BlockPos)this.pos);
            this.level.m_7731_(this.pos, Blocks.f_50016_.m_49966_(), 2);
            return true;
        }
        this.currentPower = Mth.m_14045_((int)this.virtualPower, (int)0, (int)15);
        this.state = (BlockState)this.state.m_61124_((Property)RedStoneWireBlock.f_55500_, (Comparable)Integer.valueOf(this.currentPower));
        return LevelHelper.setWireState(this.level, this.pos, this.state, this.added);
    }
}

