/*
 * Decompiled with CFR 0.152.
 */
package com.saloeater.gateways_to_emiloot;

import com.saloeater.gateways_to_emiloot.TypeAccessor;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.WaveEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;

public class GatewayDropRecipe {
    public static final int FINAL = -1;
    public static final int ENDLESS = -2;
    public int waveIndex;
    public List<ItemStackReward> stacks = new ArrayList<ItemStackReward>();
    public List<EntityReward> entityIds = new ArrayList<EntityReward>();
    public List<LootTableReward> lootTableRewards = new ArrayList<LootTableReward>();
    public List<EntityWithCount> entityWithCounts = new ArrayList<EntityWithCount>();

    public GatewayDropRecipe(List<Reward> rewards) {
        this(rewards, new ArrayList<WaveEntity>(), -1);
    }

    public GatewayDropRecipe(List<Reward> rewards, List<WaveEntity> entities, int i) {
        this.waveIndex = i;
        rewards.forEach(reward -> {
            if (reward instanceof Reward.ChancedReward) {
                Reward.ChancedReward chancedReward = (Reward.ChancedReward)reward;
                this.addReward(chancedReward.reward(), chancedReward.chance() * 100.0f);
            } else {
                this.addReward((Reward)reward, 100.0f);
            }
        });
        entities.forEach(entity -> {
            if (entity instanceof WaveEntity.StandardWaveEntity) {
                WaveEntity.StandardWaveEntity standardEntity = (WaveEntity.StandardWaveEntity)entity;
                if (entity instanceof TypeAccessor) {
                    TypeAccessor typeAccessor = (TypeAccessor)entity;
                    this.entityWithCounts.add(new EntityWithCount(typeAccessor.getType(), standardEntity.getCount()));
                }
            }
        });
    }

    private void addReward(Reward reward, float chance) {
        if (reward instanceof Reward.StackReward) {
            Reward.StackReward stackReward = (Reward.StackReward)reward;
            this.addStackReward(stackReward, chance);
        } else if (reward instanceof Reward.StackListReward) {
            Reward.StackListReward stackListReward = (Reward.StackListReward)reward;
            this.addStackListReward(stackListReward, chance);
        } else if (reward instanceof Reward.EntityLootReward) {
            Reward.EntityLootReward entityReward = (Reward.EntityLootReward)reward;
            this.addEntityReward(entityReward, chance);
        } else if (reward instanceof Reward.LootTableReward) {
            Reward.LootTableReward lootTableReward = (Reward.LootTableReward)reward;
            this.addLootTableReward(lootTableReward, chance);
        }
    }

    private void addLootTableReward(Reward.LootTableReward lootTableReward, float chance) {
        this.lootTableRewards.add(new LootTableReward(lootTableReward.table(), lootTableReward.rolls(), chance));
    }

    private void addStackListReward(Reward.StackListReward stackListReward, float chance) {
        this.stacks.addAll(stackListReward.stacks().stream().map(i -> new ItemStackReward((ItemStack)i, chance)).toList());
    }

    private void addStackReward(Reward.StackReward reward, float chance) {
        this.stacks.add(new ItemStackReward(reward.stack(), chance));
    }

    private void addEntityReward(Reward.EntityLootReward entityReward, float chance) {
        this.entityIds.add(new EntityReward(entityReward.type(), entityReward.rolls(), chance));
    }

    public record LootTableReward(ResourceLocation lootTableId, int rolls, float chance) {
    }

    public record ItemStackReward(ItemStack stack, float chance) {
    }

    public record EntityReward(EntityType<?> type, int rolls, float chance) {
    }

    public record EntityWithCount(EntityType<?> type, int count) {
    }
}

