/*
 * Decompiled with CFR 0.152.
 */
package com.saloeater.gateways_to_emiloot;

import com.saloeater.gateways_to_emiloot.ClickableSlotWidget;
import com.saloeater.gateways_to_emiloot.EmiIntegration;
import com.saloeater.gateways_to_emiloot.GatewayDropRecipe;
import com.saloeater.gateways_to_emiloot.LootEmiStack;
import com.saloeater.gateways_to_emiloot.MobEmiStack;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import fzzyhmstrs.emi_loot.EMILootAgnos;
import fzzyhmstrs.emi_loot.client.ClientResourceData;
import fzzyhmstrs.emi_loot.emi.EmiClientPlugin;
import fzzyhmstrs.emi_loot.util.BlockStateEmiStack;
import fzzyhmstrs.emi_loot.util.EntityEmiStack;
import fzzyhmstrs.emi_loot.util.FloatTrimmer;
import fzzyhmstrs.emi_loot.util.LText;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GatewayDropEmiRecipe
implements EmiRecipe {
    int categoryIndex;
    String path;
    int waveIndex;
    ItemStack gatePearl;
    List<EmiStack> stacks;
    List<EmiStack> outputs;
    List<Float> chances;
    List<GatewayDropRecipe.EntityReward> entityIds;
    List<GatewayDropRecipe.LootTableReward> lootTables;
    List<GatewayDropRecipe.EntityWithCount> spawns;
    Component name;
    int titleHeight = 11;
    int slotSize = 18;
    int itemColumns = 5;
    int slotsStartY = 12;
    int entityColumns = 2;
    int entitiesX = 95;
    int lootTableColumns = 2;
    int spawnColumns = 8;
    int height;

    public GatewayDropEmiRecipe(ItemStack gatePearl, ResourceLocation resourceLocation, GatewayDropRecipe recipe, int categoryIndex) {
        this.categoryIndex = categoryIndex;
        this.path = resourceLocation.m_135815_();
        this.waveIndex = recipe.waveIndex;
        this.gatePearl = gatePearl.m_41777_();
        this.stacks = new ArrayList<EmiStack>();
        this.chances = new ArrayList<Float>();
        recipe.stacks.forEach(stack -> {
            this.stacks.add(EmiStack.of((ItemStack)stack.stack()));
            this.chances.add(Float.valueOf(stack.chance()));
        });
        this.outputs = new ArrayList<EmiStack>(this.stacks);
        this.name = gatePearl.m_41786_();
        this.entityIds = recipe.entityIds;
        this.entityIds.forEach(entityId -> this.outputs.add(new MobEmiStack(this.toEmiMobLootFormat(ForgeRegistries.ENTITY_TYPES.getKey(entityId.type())))));
        this.lootTables = recipe.lootTableRewards;
        this.lootTables.forEach(lootTable -> this.outputs.add(new LootEmiStack(lootTable.lootTableId().toString())));
        this.spawns = recipe.entityWithCounts;
        this.spawns.forEach(entityWithCount -> this.outputs.add(new MobEmiStack(this.toEmiMobLootFormat(ForgeRegistries.ENTITY_TYPES.getKey(entityWithCount.type())))));
        int slotsHeight = this.stacks.size() / this.itemColumns * this.slotSize;
        int rewardsHeight = 2 * this.titleHeight + (int)(Math.ceil((double)this.lootTables.size() / (double)this.lootTableColumns) + (double)((int)Math.ceil((double)this.entityIds.size() / (double)this.entityColumns))) * this.slotSize;
        int spawnsHeight = this.titleHeight + (int)Math.ceil((double)this.spawns.size() / (double)this.spawnColumns) * this.slotSize;
        this.height = this.titleHeight + Math.max(slotsHeight, rewardsHeight) + spawnsHeight;
    }

    private String toEmiMobLootFormat(@Nullable ResourceLocation key) {
        if (key == null) {
            return "";
        }
        return ResourceLocation.fromNamespaceAndPath((String)key.m_135827_(), (String)("entities/" + key.m_135815_())).toString();
    }

    public EmiRecipeCategory getCategory() {
        return EmiIntegration.categories.get(this.categoryIndex);
    }

    @Nullable
    public ResourceLocation getId() {
        return ResourceLocation.m_214293_((String)"gateways_to_emiloot", (String)("/gateway_drop/" + this.path));
    }

    public List<EmiIngredient> getInputs() {
        return List.of(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.gatePearl})));
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 144;
    }

    public int getDisplayHeight() {
        return this.height;
    }

    public void addWidgets(WidgetHolder widgets) {
        Object slot;
        int x;
        MutableComponent waveText = this.getWaveText();
        widgets.addText((Component)waveText, this.centeredTextX((Component)waveText), 0, 0x404040, false);
        int row = 0;
        int column = 0;
        for (EmiStack stack : this.stacks) {
            if (column == this.itemColumns) {
                ++row;
                column = 0;
            }
            int x2 = column * this.slotSize;
            int y = this.slotsStartY + row * this.slotSize;
            SlotWidget slot2 = new SlotWidget((EmiIngredient)stack, x2, y);
            widgets.add((Widget)slot2.appendTooltip((Component)LText.translatable((String)"emi_loot.percentage", (Object[])new Object[]{FloatTrimmer.trimFloatString((float)this.chances.get(column).floatValue())})));
            ++column;
        }
        int y = this.slotsStartY;
        if (!this.entityIds.isEmpty() || !this.lootTables.isEmpty()) {
            widgets.addText(this.getRewardsText(), this.entitiesX, y, 0x404040, false);
            widgets.addText(this.getFromText(), this.entitiesX, y += this.titleHeight, 0x404040, false);
            y += this.titleHeight;
        }
        if (!this.entityIds.isEmpty()) {
            row = 0;
            column = 0;
            for (GatewayDropRecipe.EntityReward entityRewards : this.entityIds) {
                if (column == this.entityColumns) {
                    ++row;
                    column = 0;
                    y += this.slotSize;
                }
                x = this.entitiesX + column * this.slotSize;
                EntityType<?> entityType = entityRewards.type();
                EmiIngredient entityStack = this.createEntitySlot(entityType);
                ClickableSlotWidget slot3 = new ClickableSlotWidget(entityStack, x, y, (mouseX, mouseY, button) -> {
                    if (button == 1) {
                        GatewayDropEmiRecipe.showMobLoot(entityType);
                    }
                }).appendTooltip((Component)LText.translatable((String)"emi_loot.percentage", (Object[])new Object[]{FloatTrimmer.trimFloatString((float)entityRewards.chance())}));
                widgets.add((Widget)slot3);
                ++column;
            }
            y += this.slotSize;
        }
        if (!this.lootTables.isEmpty()) {
            row = 0;
            column = 0;
            for (GatewayDropRecipe.LootTableReward lootTable : this.lootTables) {
                if (column == this.lootTableColumns) {
                    ++row;
                    column = 0;
                    y += this.slotSize;
                }
                x = this.entitiesX + column * this.slotSize;
                ItemStack chestSlot = new ItemStack((ItemLike)Items.f_42009_);
                chestSlot.m_41714_((Component)this.getLootTableName(lootTable));
                slot = BlockStateEmiStack.of((ItemStack)chestSlot);
                ClickableSlotWidget slotWidget = new ClickableSlotWidget((EmiIngredient)slot, x, y, (mouseX, mouseY, button) -> {
                    if (button == 1) {
                        GatewayDropEmiRecipe.showChestLoot(lootTable.lootTableId());
                    }
                }).appendTooltip((Component)LText.translatable((String)"emi_loot.percentage", (Object[])new Object[]{FloatTrimmer.trimFloatString((float)lootTable.chance())}));
                widgets.add((Widget)slotWidget);
                ++column;
            }
            y += this.slotSize;
        }
        if (!this.spawns.isEmpty()) {
            y = (int)Math.max((double)y, (double)this.slotsStartY + Math.ceil((double)this.stacks.size() / (double)this.itemColumns) * (double)this.slotSize);
            widgets.addText((Component)Component.m_237115_((String)"gateways_to_emiloot.spawns"), 0, y, 0x404040, false);
            y += this.titleHeight;
            row = 0;
            column = 0;
            for (GatewayDropRecipe.EntityWithCount entityWithCount : this.spawns) {
                if (column == this.spawnColumns) {
                    ++row;
                    column = 0;
                    y += this.slotSize;
                }
                x = column * this.slotSize;
                EmiIngredient entityStack = this.createEntitySlot(entityWithCount.type());
                slot = new ClickableSlotWidget(entityStack, x, y, (mouseX, mouseY, button) -> {
                    if (button == 1) {
                        GatewayDropEmiRecipe.showMobLoot(entityWithCount.type());
                    }
                });
                widgets.add((Widget)slot);
                widgets.addText((Component)Component.m_237113_((String)String.valueOf(entityWithCount.count())), x + 1, y + 1, 12397066, false);
                ++column;
            }
        }
    }

    private static void showChestLoot(ResourceLocation id) {
        EmiRecipe emiRecipe = EmiApi.getRecipeManager().getRecipe(ResourceLocation.fromNamespaceAndPath((String)"emi_loot", (String)("/" + EmiClientPlugin.CHEST_CATEGORY.getId().m_135815_() + "/" + id.m_135827_() + "/" + id.m_135815_())));
        if (emiRecipe == null) {
            return;
        }
        EmiApi.displayRecipe((EmiRecipe)emiRecipe);
    }

    private static void showMobLoot(EntityType<?> type) {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey(type);
        EmiRecipe emiRecipe = EmiApi.getRecipeManager().getRecipe(ResourceLocation.fromNamespaceAndPath((String)"emi_loot", (String)("/" + EmiClientPlugin.MOB_CATEGORY.getId().m_135815_() + "/" + id.m_135827_() + "/entities/" + id.m_135815_())));
        if (emiRecipe == null) {
            return;
        }
        EmiApi.displayRecipe((EmiRecipe)emiRecipe);
    }

    private EmiIngredient createEntitySlot(EntityType<?> type) {
        EmiStack inputStack;
        Minecraft client = Minecraft.m_91087_();
        Entity entity = type.m_20615_((Level)client.f_91073_);
        if (entity != null) {
            AABB box = entity.m_20191_();
            double len = box.m_82309_();
            if (len > 1.05) {
                len = (len + Math.sqrt(len)) / 2.0;
            }
            if (entity instanceof Slime) {
                ((Slime)entity).m_7839_(5, false);
            }
            double scale = 1.05 / len * 8.0;
            if (ClientResourceData.MOB_SCALES.containsKey(type)) {
                scale *= (double)ClientResourceData.MOB_SCALES.getOrDefault(type, 1.0f);
            }
            inputStack = EntityEmiStack.ofScaled((Entity)entity, (double)scale);
        } else {
            inputStack = EmiStack.EMPTY;
        }
        return inputStack;
    }

    private MutableComponent getLootTableName(GatewayDropRecipe.LootTableReward lootTable) {
        MutableComponent rawTitle;
        ResourceLocation id = lootTable.lootTableId();
        String key = "emi_loot.chest." + id.toString();
        if (!I18n.m_118936_((String)key)) {
            String[] chestPathTokens;
            StringBuilder chestName = new StringBuilder();
            for (String str : chestPathTokens = id.m_135815_().split("[/_]")) {
                if (LText.tablePrefixes.contains(str)) continue;
                if (!chestName.isEmpty()) {
                    chestName.append(" ");
                }
                if (str.length() <= 1) {
                    chestName.append(str);
                    continue;
                }
                chestName.append(str.substring(0, 1).toUpperCase()).append(str.substring(1));
            }
            if (EMILootAgnos.isModLoaded((String)id.m_135827_())) {
                rawTitle = LText.translatable((String)"emi_loot.chest.unknown_chest", (Object[])new Object[]{chestName.toString()});
            } else {
                MutableComponent unknown = LText.translatable((String)"emi_loot.chest.unknown");
                rawTitle = LText.translatable((String)"emi_loot.chest.unknown_chest", (Object[])new Object[]{LText.literal((String)chestName.toString()).m_130946_(" ").m_7220_((Component)unknown)});
            }
        } else {
            rawTitle = LText.translatable((String)key);
        }
        return rawTitle;
    }

    private Component getRewardsText() {
        return Component.m_237115_((String)"gateways_to_emiloot.word.rewards");
    }

    private Component getFromText() {
        return Component.m_237115_((String)"gateways_to_emiloot.word.from");
    }

    @NotNull
    private MutableComponent getWaveText() {
        if (this.waveIndex == -1) {
            return Component.m_237115_((String)"gateways_to_emiloot.final");
        }
        if (this.waveIndex == -2) {
            return Component.m_237115_((String)"gateways_to_emiloot.endless_wave");
        }
        return Component.m_237110_((String)"gateways_to_emiloot.wave", (Object[])new Object[]{this.waveIndex});
    }

    private int centeredTextX(Component text, int startX, int endX) {
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)text);
        return startX + (endX - startX - textWidth) / 2;
    }

    private int centeredTextX(Component text, int startX) {
        return this.centeredTextX(text, startX, this.getDisplayWidth());
    }

    private int centeredTextX(Component text) {
        return this.centeredTextX(text, 0, this.getDisplayWidth());
    }

    public boolean supportsRecipeTree() {
        return false;
    }
}

