/*
 * Decompiled with CFR 0.152.
 */
package com.saloeater.gateways_to_emiloot;

import com.saloeater.gateways_to_emiloot.GatewayDropEmiRecipe;
import com.saloeater.gateways_to_emiloot.GatewayDropEmiRecipeCategory;
import com.saloeater.gateways_to_emiloot.GatewayDropRecipe;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.stack.EmiStack;
import dev.shadowsoffire.gateways.GatewayObjects;
import dev.shadowsoffire.gateways.gate.Gateway;
import dev.shadowsoffire.gateways.gate.GatewayRegistry;
import dev.shadowsoffire.gateways.gate.Reward;
import dev.shadowsoffire.gateways.gate.Wave;
import dev.shadowsoffire.gateways.gate.endless.EndlessGateway;
import dev.shadowsoffire.gateways.gate.normal.NormalGateway;
import dev.shadowsoffire.gateways.item.GatePearlItem;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@EmiEntrypoint
public class EmiIntegration
implements EmiPlugin {
    public static List<EmiRecipeCategory> categories = new ArrayList<EmiRecipeCategory>();

    public void register(EmiRegistry emiRegistry) {
        GatewayRegistry.INSTANCE.getKeys().forEach(resourceLocation -> {
            Gateway gate = (Gateway)GatewayRegistry.INSTANCE.getValue(resourceLocation);
            if (gate instanceof NormalGateway) {
                NormalGateway normalGateway = (NormalGateway)gate;
                ItemStack gatePearl = EmiIntegration.registerGatewayCategory(emiRegistry, resourceLocation, gate);
                int categoryIndex = categories.size() - 1;
                for (int i = 0; i < normalGateway.waves().size(); ++i) {
                    Wave wave = (Wave)normalGateway.waves().get(i);
                    List rewards = wave.rewards();
                    if (EmiIntegration.isRewardsEmpty(rewards)) continue;
                    emiRegistry.addRecipe((EmiRecipe)new GatewayDropEmiRecipe(gatePearl, (ResourceLocation)resourceLocation, new GatewayDropRecipe(rewards, wave.entities(), i + 1), categoryIndex));
                }
                if (EmiIntegration.isRewardsEmpty(normalGateway.rewards())) {
                    return;
                }
                emiRegistry.addRecipe((EmiRecipe)new GatewayDropEmiRecipe(gatePearl, (ResourceLocation)resourceLocation, new GatewayDropRecipe(normalGateway.rewards()), categoryIndex));
            } else if (gate instanceof EndlessGateway) {
                EndlessGateway endlessGateway = (EndlessGateway)gate;
                ItemStack gatePearl = EmiIntegration.registerGatewayCategory(emiRegistry, resourceLocation, gate);
                int categoryIndex = categories.size() - 1;
                if (EmiIntegration.isRewardsEmpty(endlessGateway.baseWave().rewards())) {
                    return;
                }
                emiRegistry.addRecipe((EmiRecipe)new GatewayDropEmiRecipe(gatePearl, (ResourceLocation)resourceLocation, new GatewayDropRecipe(endlessGateway.baseWave().rewards(), endlessGateway.baseWave().entities(), -2), categoryIndex));
            }
        });
    }

    @NotNull
    private static ItemStack registerGatewayCategory(EmiRegistry emiRegistry, ResourceLocation resourceLocation, Gateway gate) {
        ItemStack gatePearl = new ItemStack((ItemLike)GatewayObjects.GATE_PEARL.get());
        GatePearlItem.setGate((ItemStack)gatePearl, (Gateway)gate);
        GatewayDropEmiRecipeCategory category = new GatewayDropEmiRecipeCategory(ResourceLocation.m_214293_((String)resourceLocation.m_135827_(), (String)resourceLocation.m_135815_()), (EmiRenderable)EmiStack.of((ItemStack)gatePearl), gatePearl);
        emiRegistry.addCategory((EmiRecipeCategory)category);
        categories.add(category);
        return gatePearl;
    }

    private static boolean isRewardsEmpty(List<Reward> rewards) {
        AtomicBoolean empty = new AtomicBoolean(true);
        rewards.forEach(reward -> {
            if (reward instanceof Reward.StackReward || reward instanceof Reward.StackListReward || reward instanceof Reward.EntityLootReward || reward instanceof Reward.LootTableReward || reward instanceof Reward.ChancedReward) {
                empty.set(false);
            }
        });
        return empty.get();
    }
}

