/*
 * Decompiled with CFR 0.152.
 */
package dev.uncandango.alltheleaks.feature.common.mods.minecraft;

import dev.uncandango.alltheleaks.AllTheLeaks;
import dev.uncandango.alltheleaks.annotation.Issue;
import dev.uncandango.alltheleaks.mixin.RebindableTickingBlockEntityWrapperExtended;
import dev.uncandango.alltheleaks.mixin.core.accessor.LevelAccessor;
import dev.uncandango.alltheleaks.mixin.core.accessor.LevelChunkAccessor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.server.ServerLifecycleHooks;

@Issue(modId="minecraft", versionRange="1.20.1", mixins={"accessor.LevelAccessor", "main.RebindableTickingBlockEntityWrapperMixin", "accessor.LevelChunkAccessor"})
public class ClearLeakedLevelChunks {
    public static void execute() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            AllTheLeaks.LOGGER.warn("Server not found while trying to clear leaked chunks");
            return;
        }
        server.m_18709_(() -> {
            for (ServerLevel level : server.m_129785_()) {
                if (!(level instanceof LevelAccessor)) continue;
                LevelAccessor levelAccessor = (LevelAccessor)level;
                levelAccessor.atl$getBlockEntityTickers().removeIf(ClearLeakedLevelChunks::isNullTicker);
            }
        });
    }

    static boolean isNullTicker(TickingBlockEntity tickingBlockEntity) {
        LevelChunkAccessor chunkAccessor;
        RebindableTickingBlockEntityWrapperExtended tickingAccessor;
        LevelChunk levelChunk;
        if (tickingBlockEntity == LevelChunkAccessor.atl$getNullTicker() && tickingBlockEntity instanceof RebindableTickingBlockEntityWrapperExtended && (levelChunk = (tickingAccessor = (RebindableTickingBlockEntityWrapperExtended)tickingBlockEntity).atl$getLevelChunk()) instanceof LevelChunkAccessor && !(chunkAccessor = (LevelChunkAccessor)levelChunk).atl$isInLevel()) {
            AllTheLeaks.LOGGER.debug("Cleared leaked chunk at {} from dimension {}", (Object)levelChunk.m_7697_(), (Object)levelChunk.m_62953_().m_46472_().m_135782_());
            return true;
        }
        return false;
    }
}

