/*
 * Decompiled with CFR 0.152.
 */
package carbonconfiglib.gui.api;

import carbonconfiglib.api.ConfigType;
import carbonconfiglib.api.IConfigProxy;
import carbonconfiglib.config.ConfigHandler;
import carbonconfiglib.gui.api.IConfigNode;
import carbonconfiglib.gui.impl.carbon.ModConfig;
import carbonconfiglib.gui.impl.forge.ForgeConfigs;
import carbonconfiglib.gui.impl.minecraft.MinecraftConfig;
import carbonconfiglib.impl.PerWorldProxy;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.storage.LevelSummary;
import net.minecraftforge.fml.ModList;

public interface IModConfig {
    public String getFileName();

    public String getConfigName();

    public String getModId();

    public boolean isDynamicConfig();

    public ConfigType getConfigType();

    public IConfigNode getRootNode();

    public boolean isDefault();

    public boolean isLocalConfig();

    public boolean canCreateConfigs();

    public void restoreDefault();

    public List<IConfigTarget> getPotentialFiles();

    public boolean createConfig(Path var1);

    public IModConfig loadFromFile(Path var1);

    public IModConfig loadFromNetworking(UUID var1, Consumer<Predicate<FriendlyByteBuf>> var2);

    public void save();

    public static IModConfig carbon(String modId, ConfigHandler handler) {
        return new ModConfig(modId, handler);
    }

    public static IModConfig forge(String modId, ConfigType type) {
        List<IModConfig> config = new ForgeConfigs(ModList.get().getModContainerById(modId).orElse(null)).getConfigInstances(type);
        return config == null || config.isEmpty() ? null : config.get(0);
    }

    public static IModConfig minecraft() {
        return new MinecraftConfig();
    }

    public static class WorldConfigTarget
    implements IConfigTarget {
        LevelSummary summary;
        Path folder;
        Path file;
        String name;

        public WorldConfigTarget(PerWorldProxy.WorldTarget target, Path file) {
            this(target.getSummary(), target.getFolder(), file, target.getName());
        }

        public WorldConfigTarget(LevelSummary summary, Path folder, Path file, String name) {
            this.summary = summary;
            this.folder = folder;
            this.file = file;
            this.name = name;
        }

        @Override
        public Path getFolder() {
            return this.folder;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Path getConfigFile() {
            return this.file;
        }

        public LevelSummary getSummary() {
            return this.summary;
        }
    }

    public static class SimpleConfigTarget
    implements IConfigTarget {
        Path folder;
        Path file;
        String name;

        public SimpleConfigTarget(IConfigProxy.IPotentialTarget target, Path file) {
            this(target.getFolder(), file, target.getName());
        }

        public SimpleConfigTarget(Path folder, Path file, String name) {
            this.folder = folder;
            this.file = file;
            this.name = name;
        }

        @Override
        public Path getFolder() {
            return this.folder;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Path getConfigFile() {
            return this.file;
        }
    }

    public static interface IConfigTarget
    extends IConfigProxy.IPotentialTarget {
        public Path getConfigFile();
    }
}

