/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops.mixin.emi;

import fzzyhmstrs.emi_loot.mixins.BinomialLootNumberProviderAccessor;
import fzzyhmstrs.emi_loot.mixins.LootPoolAccessor;
import fzzyhmstrs.emi_loot.mixins.UniformLootNumberProviderAccessor;
import fzzyhmstrs.emi_loot.parser.LootTableParser;
import fzzyhmstrs.emi_loot.server.MobLootTableSender;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataManager;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SetNbtFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.WeatherCheck;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.registries.ForgeRegistries;
import net.poe.entitylootdrops.LootTablePools2;
import net.poe.entitylootdrops.SetItemCountFunctionNumberProviderAccessor;
import net.poe.entitylootdrops.lootdrops.LootConfig;
import net.poe.entitylootdrops.lootdrops.model.EntityDropEntry;
import net.poe.entitylootdrops.mixin.LootPoolSingletonContainerAccessor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LootTableParser.class}, remap=false)
public abstract class LootTableParserMixin {
    @Shadow
    public static String currentTable;
    @Final
    @Shadow
    private static Map<ResourceLocation, MobLootTableSender> mobSenders;
    @Unique
    private static Map<String, Boolean> entitylootdrops$entitiesDone;

    @Shadow
    private static MobLootTableSender parseMobLootTable(LootTable lootTable, ResourceLocation id, ResourceLocation mobId) {
        return null;
    }

    @Inject(method={"parseLootTables"}, at={@At(value="TAIL")})
    private static void parseLootTables(LootDataManager manager, Map<LootDataId<?>, ?> tables, CallbackInfo ci) {
        ForgeRegistries.ENTITY_TYPES.forEach(type -> {
            if (entitylootdrops$entitiesDone.containsKey(type.m_20675_())) {
                return;
            }
            ResourceLocation mobTableId = type.m_20677_();
            LootTable mobTable = manager.m_278676_(mobTableId);
            if (mobTable == LootTable.f_79105_) {
                ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey(type);
                if (!LootTableParserMixin.entitylootdrops$hasApplicableDrops(mobId.toString(), type)) {
                    return;
                }
                int size = LootTableParserMixin.addLootPool(mobTable, mobId, type);
                if (size > 0) {
                    currentTable = mobTableId.toString();
                    mobSenders.put(mobTableId, LootTableParserMixin.parseMobLootTable(mobTable, mobTableId, mobId));
                }
            }
        });
    }

    @Unique
    private static boolean entitylootdrops$hasApplicableDrops(String entityId, EntityType<?> entityType) {
        for (EntityDropEntry drop : LootConfig.getNormalDrops()) {
            if (!LootTableParserMixin.entitylootdrops$shouldApplyDrop(drop, entityId, entityType)) continue;
            return true;
        }
        return false;
    }

    @Unique
    private static int addLootPool(LootTable mobTable, ResourceLocation mobTableId, EntityType<?> entityType) {
        ArrayList<LootPool> lootPools = new ArrayList<LootPool>();
        for (EntityDropEntry drop : LootConfig.getNormalDrops()) {
            if (!LootTableParserMixin.entitylootdrops$shouldApplyDrop(drop, mobTableId.toString(), entityType) || !drop.hasItem()) continue;
            LootTableParserMixin.addAdvancedLootPool(lootPools, drop);
        }
        lootPools.forEach(arg_0 -> ((LootTable)mobTable).addPool(arg_0));
        return lootPools.size();
    }

    @Inject(method={"parseMobLootTable"}, at={@At(value="HEAD")})
    private static void $parseMobLootTable(LootTable lootTable, ResourceLocation lootTableId, ResourceLocation mobId, CallbackInfoReturnable<MobLootTableSender> cir) {
        entitylootdrops$entitiesDone.put(mobId.toString(), true);
        ArrayList<LootPool> lootPools = new ArrayList<LootPool>();
        lootPools.addAll(Arrays.asList(((LootTablePools2)lootTable).getPools()));
        EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(mobId);
        if (entityType == null) {
            return;
        }
        boolean shouldCancelVanillaDrops = false;
        for (EntityDropEntry drop : LootConfig.getNormalDrops()) {
            if (!LootTableParserMixin.entitylootdrops$shouldApplyDrop(drop, mobId.toString(), entityType) || !drop.getAllowModIDs().isEmpty() && !LootTableParserMixin.entitylootdrops$isModAllowed(mobId, drop.getAllowModIDs()) || drop.isAllowDefaultDrops()) continue;
            shouldCancelVanillaDrops = true;
            break;
        }
        if (shouldCancelVanillaDrops) {
            lootPools.clear();
        }
        for (EntityDropEntry drop : LootConfig.getNormalDrops()) {
            if (!LootTableParserMixin.entitylootdrops$shouldApplyDrop(drop, mobId.toString(), entityType) || !(drop.getExtraDropChance() > 0.0f)) continue;
            LootTableParserMixin.addExtraDrop(lootPools, drop);
        }
        for (EntityDropEntry drop : LootConfig.getNormalDrops()) {
            if (!LootTableParserMixin.entitylootdrops$shouldApplyDrop(drop, mobId.toString(), entityType) || !drop.hasItem()) continue;
            LootTableParserMixin.addAdvancedLootPool(lootPools, drop);
        }
        ((LootTablePools2)lootTable).setPools(lootPools.toArray(new LootPool[0]));
    }

    @Unique
    private static boolean entitylootdrops$isModAllowed(ResourceLocation mobId, List<String> allowedMods) {
        String namespace = mobId.m_135827_();
        return allowedMods.contains(namespace);
    }

    @Unique
    private static boolean entitylootdrops$shouldApplyDrop(EntityDropEntry drop, String entityId, EntityType<?> entityType) {
        String dropEntityId = drop.getEntityId();
        if (dropEntityId.equals(entityId)) {
            return true;
        }
        if (entityType.m_20674_() == MobCategory.MONSTER && (dropEntityId.equals("Global_Hostile") || dropEntityId.equals("Global_Monster"))) {
            return true;
        }
        if ((entityType.m_20674_() == MobCategory.CREATURE || entityType.m_20674_() == MobCategory.AMBIENT) && (dropEntityId.equals("Global_Passive") || dropEntityId.equals("Global_Animal"))) {
            return true;
        }
        return dropEntityId.equals("Global_All") || dropEntityId.equals("Global");
    }

    @Unique
    private static void addExtraDrop(List<LootPool> lootPools, EntityDropEntry drop) {
        int addedAmount = Math.max(drop.getExtraAmountMin(), drop.getExtraAmountMax());
        for (LootPool pool : lootPools) {
            LootPoolEntryContainer[] entries;
            LootItemFunction[] functions;
            for (LootItemFunction function : functions = ((LootPoolAccessor)pool).getFunctions()) {
                if (!(function instanceof SetItemCountFunction)) continue;
                SetItemCountFunction setItemCountFunction = (SetItemCountFunction)function;
                SetItemCountFunctionNumberProviderAccessor accessor = (SetItemCountFunctionNumberProviderAccessor)setItemCountFunction;
                NumberProvider numberProvider = accessor.getNumberProvider();
                accessor.setNumberProvider(LootTableParserMixin.addToNumberProvider(numberProvider, addedAmount));
            }
            for (LootPoolEntryContainer entry : entries = ((LootPoolAccessor)pool).getEntries()) {
                LootItemFunction[] functions2;
                if (!(entry instanceof LootItem)) continue;
                LootItem lootItem = (LootItem)entry;
                for (LootItemFunction function : functions2 = ((LootPoolSingletonContainerAccessor)lootItem).getFunctions()) {
                    if (!(function instanceof SetItemCountFunction)) continue;
                    SetItemCountFunction setItemCountFunction = (SetItemCountFunction)function;
                    SetItemCountFunctionNumberProviderAccessor accessor = (SetItemCountFunctionNumberProviderAccessor)setItemCountFunction;
                    NumberProvider numberProvider = accessor.getNumberProvider();
                    accessor.setNumberProvider(LootTableParserMixin.addToNumberProvider(numberProvider, addedAmount));
                }
            }
        }
    }

    @Unique
    private static NumberProvider addToNumberProvider(NumberProvider numberProvider, int addedAmount) {
        if (numberProvider instanceof UniformGenerator) {
            float min = LootTableParserMixin.getGeneratorMin(numberProvider);
            float max = LootTableParserMixin.getGeneratorMax(numberProvider) + (float)addedAmount;
            return UniformGenerator.m_165780_((float)min, (float)max);
        }
        if (numberProvider instanceof BinomialDistributionGenerator) {
            BinomialDistributionGenerator binomialDistributionGenerator = (BinomialDistributionGenerator)numberProvider;
            float max = LootTableParserMixin.getGeneratorMax((NumberProvider)binomialDistributionGenerator) + (float)addedAmount;
            return UniformGenerator.m_165780_((float)0.0f, (float)max);
        }
        if (numberProvider instanceof ConstantValue) {
            ConstantValue constantValue = (ConstantValue)numberProvider;
            return ConstantValue.m_165692_((float)(constantValue.m_142688_(null) + (float)addedAmount));
        }
        return numberProvider;
    }

    @Unique
    private static float getGeneratorMin(NumberProvider numberProvider) {
        if (numberProvider instanceof UniformGenerator) {
            return LootTableParserMixin.getGeneratorMin(((UniformLootNumberProviderAccessor)numberProvider).getMin());
        }
        if (numberProvider instanceof BinomialDistributionGenerator) {
            return 0.0f;
        }
        if (numberProvider instanceof ConstantValue) {
            ConstantValue constantValue = (ConstantValue)numberProvider;
            return constantValue.m_142688_(null);
        }
        return 0.0f;
    }

    @Unique
    private static float getGeneratorMax(NumberProvider numberProvider) {
        if (numberProvider instanceof UniformGenerator) {
            return LootTableParserMixin.getGeneratorMax(((UniformLootNumberProviderAccessor)numberProvider).getMax());
        }
        if (numberProvider instanceof BinomialDistributionGenerator) {
            return LootTableParserMixin.getGeneratorMax(((BinomialLootNumberProviderAccessor)numberProvider).getN());
        }
        if (numberProvider instanceof ConstantValue) {
            ConstantValue constantValue = (ConstantValue)numberProvider;
            return constantValue.m_142688_(null);
        }
        return 0.0f;
    }

    @Unique
    private static void addAdvancedLootPool(List<LootPool> lootPools, EntityDropEntry drop) {
        LootPoolSingletonContainer.Builder lootItem = LootItem.m_79579_((ItemLike)((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)drop.getItemId()))));
        LootPool.Builder builder = LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)lootItem);
        builder.m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)drop.getMinAmount(), (float)drop.getMaxAmount())));
        if (drop.getNbtData() != null && !drop.getNbtData().isEmpty()) {
            try {
                CompoundTag nbtTag = TagParser.m_129359_((String)drop.getNbtData());
                builder.m_79078_((LootItemFunction.Builder)SetNbtFunction.m_81187_((CompoundTag)nbtTag));
            }
            catch (Exception e) {
                System.err.println("Invalid NBT data in drop entry: " + drop.getNbtData());
            }
        }
        if (drop.isRequirePlayerKill()) {
            builder.m_79080_(LootItemKilledByPlayerCondition.m_81901_());
        }
        if (drop.getDropChance() < 100.0f) {
            builder.m_79080_(LootItemRandomChanceCondition.m_81927_((float)(drop.getDropChance() / 100.0f)));
        }
        LootTableParserMixin.addAdvancedConditions(builder, drop);
        lootPools.add(builder.m_79082_());
    }

    @Unique
    private static void addAdvancedConditions(LootPool.Builder builder, EntityDropEntry drop) {
        if (drop.getRequiredWeather() != null && !drop.getRequiredWeather().isEmpty()) {
            switch (drop.getRequiredWeather().toLowerCase()) {
                case "clear": {
                    builder.m_79080_((LootItemCondition.Builder)WeatherCheck.m_165552_().m_165556_(Boolean.valueOf(false)).m_165559_(Boolean.valueOf(false)));
                    break;
                }
                case "rain": {
                    builder.m_79080_((LootItemCondition.Builder)WeatherCheck.m_165552_().m_165556_(Boolean.valueOf(true)).m_165559_(Boolean.valueOf(false)));
                    break;
                }
                case "thunder": {
                    builder.m_79080_((LootItemCondition.Builder)WeatherCheck.m_165552_().m_165559_(Boolean.valueOf(true)));
                }
            }
        }
        if (drop.getRequiredEquipment() == null || !drop.getRequiredEquipment().isEmpty()) {
            // empty if block
        }
        if (drop.getRequiredAdvancement() == null || !drop.getRequiredAdvancement().isEmpty()) {
            // empty if block
        }
        if (drop.getRequiredEffect() == null || !drop.getRequiredEffect().isEmpty()) {
            // empty if block
        }
    }

    static {
        entitylootdrops$entitiesDone = new HashMap<String, Boolean>();
    }
}

