/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops.lootdrops.util;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.LivingEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTConditionChecker {
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean checkCondition(LivingEntity entity, String nbtPath, String condition, String valueStr) {
        if (entity == null || nbtPath == null || condition == null || valueStr == null) {
            return false;
        }
        try {
            CompoundTag entityNbt = new CompoundTag();
            entity.m_20240_(entityNbt);
            Tag nbtValue = NBTConditionChecker.getNbtValueAtPath(entityNbt, nbtPath);
            if (nbtValue == null) {
                LOGGER.debug("NBT path not found: {} for entity {}", (Object)nbtPath, (Object)entity.m_6095_().m_20675_());
                return false;
            }
            return NBTConditionChecker.compareValues(nbtValue, condition, valueStr);
        }
        catch (Exception e) {
            LOGGER.error("Error checking NBT condition for path '{}': {}", (Object)nbtPath, (Object)e.getMessage());
            return false;
        }
    }

    private static Tag getNbtValueAtPath(CompoundTag nbt, String path) {
        String[] parts = path.split("\\.");
        CompoundTag current = nbt;
        for (String part : parts) {
            if (!(current instanceof CompoundTag)) {
                return null;
            }
            CompoundTag compound = current;
            if (!compound.m_128441_(part)) {
                return null;
            }
            current = compound.m_128423_(part);
        }
        return current;
    }

    private static boolean compareValues(Tag nbtValue, String operator, String valueStr) {
        try {
            switch (nbtValue.m_7060_()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    return NBTConditionChecker.compareNumeric(NBTConditionChecker.getNumericValue(nbtValue), operator, NBTConditionChecker.parseNumeric(valueStr));
                }
                case 8: {
                    return NBTConditionChecker.compareString(nbtValue.m_7916_(), operator, valueStr);
                }
                case 7: 
                case 11: 
                case 12: {
                    LOGGER.warn("Array comparison not supported for NBT condition");
                    return false;
                }
            }
            LOGGER.warn("Unsupported NBT type for comparison: {}", (Object)nbtValue.m_7060_());
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error comparing values: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static double getNumericValue(Tag tag) {
        switch (tag.m_7060_()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return Double.parseDouble(tag.m_7916_());
            }
        }
        throw new IllegalArgumentException("Not a numeric NBT tag");
    }

    private static double parseNumeric(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid numeric value: " + value);
        }
    }

    private static boolean compareNumeric(double nbtValue, String operator, double compareValue) {
        switch (operator) {
            case "<": {
                return nbtValue < compareValue;
            }
            case ">": {
                return nbtValue > compareValue;
            }
            case "<=": {
                return nbtValue <= compareValue;
            }
            case ">=": {
                return nbtValue >= compareValue;
            }
            case "==": {
                return Math.abs(nbtValue - compareValue) < 1.0E-4;
            }
            case "!=": {
                return Math.abs(nbtValue - compareValue) >= 1.0E-4;
            }
        }
        LOGGER.warn("Unknown numeric operator: {}", (Object)operator);
        return false;
    }

    private static boolean compareString(String nbtValue, String operator, String compareValue) {
        switch (operator) {
            case "==": {
                return nbtValue.equals(compareValue);
            }
            case "!=": {
                return !nbtValue.equals(compareValue);
            }
        }
        LOGGER.warn("Unsupported string operator: {}. Only == and != are supported for strings.", (Object)operator);
        return false;
    }

    public static boolean isValidOperator(String operator) {
        return operator != null && (operator.equals("<") || operator.equals(">") || operator.equals("<=") || operator.equals(">=") || operator.equals("==") || operator.equals("!="));
    }
}

