/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops.lootdrops.handlers;

import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.poe.entitylootdrops.lootdrops.LootConfig;
import net.poe.entitylootdrops.lootdrops.model.CustomDropEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NBTDropHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RANDOM = new Random();
    private static final Pattern ARRAY_INDEX_PATTERN = Pattern.compile("(.+?)\\[(\\d+)\\]");

    public static boolean checkNBTConditions(CustomDropEntry drop, LivingEntity entity) {
        if (!drop.hasNbtEntityCondition()) {
            return true;
        }
        boolean debugLoggingEnabled = LootConfig.isDebugLoggingEnabled();
        try {
            Tag nbtValue;
            CompoundTag entityData = new CompoundTag();
            entity.m_20240_(entityData);
            if (debugLoggingEnabled) {
                LOGGER.info("[NBT Debug] Checking NBT condition for entity: {}", (Object)ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()));
                LOGGER.info("[NBT Debug] NBT Path: {}", (Object)drop.getNbtEntityData());
                LOGGER.info("[NBT Debug] Condition: {}", (Object)drop.getNbtDataCondition());
                LOGGER.info("[NBT Debug] Expected Value: {}", (Object)drop.getNbtDataValue());
                LOGGER.info("[NBT Debug] Full entity NBT: {}", (Object)entityData.toString());
            }
            if ((nbtValue = NBTDropHandler.navigateNBTPath(entityData, drop.getNbtEntityData())) == null) {
                if (debugLoggingEnabled) {
                    LOGGER.info("[NBT Debug] Failed to find NBT value at path: {}", (Object)drop.getNbtEntityData());
                }
                return false;
            }
            boolean result = NBTDropHandler.compareValues(nbtValue, drop.getNbtDataCondition(), drop.getNbtDataValue());
            if (debugLoggingEnabled) {
                LOGGER.info("[NBT Debug] Found value: {}", (Object)nbtValue.m_7916_());
                LOGGER.info("[NBT Debug] Condition result: {}", (Object)result);
            }
            return result;
        }
        catch (Exception e) {
            LOGGER.error("Error checking NBT conditions: {}", (Object)e.getMessage());
            if (debugLoggingEnabled) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private static Tag navigateNBTPath(CompoundTag nbt, String path) {
        boolean debugLoggingEnabled = LootConfig.isDebugLoggingEnabled();
        CharSequence[] parts = path.split("\\.");
        CompoundTag current = nbt;
        if (debugLoggingEnabled) {
            LOGGER.info("[NBT Debug] Navigating path: {}", (Object)path);
            LOGGER.info("[NBT Debug] Path parts: {}", (Object)String.join((CharSequence)" -> ", parts));
        }
        for (int i = 0; i < parts.length; ++i) {
            Matcher matcher;
            CharSequence part = parts[i];
            if (debugLoggingEnabled) {
                LOGGER.info("[NBT Debug] Processing part [{}]: {}", (Object)i, (Object)part);
            }
            if ((matcher = ARRAY_INDEX_PATTERN.matcher(part)).matches()) {
                String arrayName = matcher.group(1);
                int index = Integer.parseInt(matcher.group(2));
                if (debugLoggingEnabled) {
                    LOGGER.info("[NBT Debug] Array access: {}[{}]", (Object)arrayName, (Object)index);
                }
                if (!(current instanceof CompoundTag)) {
                    if (debugLoggingEnabled) {
                        LOGGER.info("[NBT Debug] Current tag is not CompoundTag, cannot access array");
                    }
                    return null;
                }
                CompoundTag compound = current;
                if (!compound.m_128441_(arrayName)) {
                    if (debugLoggingEnabled) {
                        LOGGER.info("[NBT Debug] Array '{}' not found in compound", (Object)arrayName);
                    }
                    return null;
                }
                Tag arrayTag = compound.m_128423_(arrayName);
                if (arrayTag instanceof ListTag) {
                    ListTag list = (ListTag)arrayTag;
                    if (debugLoggingEnabled) {
                        LOGGER.info("[NBT Debug] Found ListTag with {} elements", (Object)list.size());
                    }
                    if (index >= 0 && index < list.size()) {
                        current = list.get(index);
                        if (!debugLoggingEnabled) continue;
                        LOGGER.info("[NBT Debug] Retrieved element at index {}: {}", (Object)index, (Object)current);
                        continue;
                    }
                    if (debugLoggingEnabled) {
                        LOGGER.info("[NBT Debug] Index {} out of bounds (size: {})", (Object)index, (Object)list.size());
                    }
                    return null;
                }
                if (debugLoggingEnabled) {
                    LOGGER.info("[NBT Debug] Tag '{}' is not a ListTag: {}", (Object)arrayName, (Object)arrayTag.getClass().getSimpleName());
                }
                return null;
            }
            if (!(current instanceof CompoundTag)) {
                if (debugLoggingEnabled) {
                    LOGGER.info("[NBT Debug] Current tag is not CompoundTag: {}", (Object)current.getClass().getSimpleName());
                }
                return null;
            }
            CompoundTag compound = current;
            if (!compound.m_128441_((String)part)) {
                if (debugLoggingEnabled) {
                    LOGGER.info("[NBT Debug] Key '{}' not found in compound", (Object)part);
                    LOGGER.info("[NBT Debug] Available keys: {}", (Object)compound.m_128431_());
                }
                return null;
            }
            current = compound.m_128423_((String)part);
            if (!debugLoggingEnabled) continue;
            LOGGER.info("[NBT Debug] Found key '{}': {}", (Object)part, (Object)current);
        }
        if (debugLoggingEnabled) {
            LOGGER.info("[NBT Debug] Navigation complete. Final value: {}", (Object)current);
        }
        return current;
    }

    private static boolean compareValues(Tag nbtValue, String operator, String expectedValue) {
        boolean debugLoggingEnabled = LootConfig.isDebugLoggingEnabled();
        try {
            if (NBTDropHandler.isNumericTag(nbtValue)) {
                return NBTDropHandler.compareNumeric(nbtValue, operator, expectedValue);
            }
            if (nbtValue instanceof StringTag) {
                return NBTDropHandler.compareString(nbtValue.m_7916_(), operator, expectedValue);
            }
            if (nbtValue.m_7060_() == 1 && (expectedValue.equalsIgnoreCase("true") || expectedValue.equalsIgnoreCase("false"))) {
                return NBTDropHandler.compareBoolean(nbtValue, operator, expectedValue);
            }
            LOGGER.warn("Unsupported NBT type for comparison: {}", (Object)nbtValue.getClass().getSimpleName());
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error comparing values: {}", (Object)e.getMessage());
            if (debugLoggingEnabled) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private static boolean isNumericTag(Tag tag) {
        byte id = tag.m_7060_();
        return id == 1 || id == 2 || id == 3 || id == 4 || id == 5 || id == 6;
    }

    private static boolean compareNumeric(Tag nbtValue, String operator, String expectedValue) {
        boolean debugLoggingEnabled = LootConfig.isDebugLoggingEnabled();
        try {
            double actual = NBTDropHandler.getNumericValue(nbtValue);
            double expected = Double.parseDouble(expectedValue);
            if (debugLoggingEnabled) {
                LOGGER.info("[NBT Debug] Numeric comparison: {} {} {}", (Object)actual, (Object)operator, (Object)expected);
            }
            switch (operator) {
                case "<": {
                    return actual < expected;
                }
                case ">": {
                    return actual > expected;
                }
                case "<=": {
                    return actual <= expected;
                }
                case ">=": {
                    return actual >= expected;
                }
                case "==": {
                    return Math.abs(actual - expected) < 1.0E-4;
                }
                case "!=": {
                    return Math.abs(actual - expected) >= 1.0E-4;
                }
            }
            LOGGER.warn("Unknown numeric operator: {}", (Object)operator);
            return false;
        }
        catch (NumberFormatException e) {
            LOGGER.error("Invalid numeric value: {}", (Object)expectedValue);
            return false;
        }
    }

    private static double getNumericValue(Tag tag) {
        switch (tag.m_7060_()) {
            case 1: {
                return ((ByteTag)tag).m_7063_();
            }
            case 2: {
                return ((ShortTag)tag).m_7053_();
            }
            case 3: {
                return ((IntTag)tag).m_7047_();
            }
            case 4: {
                return ((LongTag)tag).m_7046_();
            }
            case 5: {
                return ((FloatTag)tag).m_7057_();
            }
            case 6: {
                return ((DoubleTag)tag).m_7061_();
            }
        }
        throw new IllegalArgumentException("Not a numeric tag");
    }

    private static boolean compareString(String actual, String operator, String expected) {
        boolean debugLoggingEnabled = LootConfig.isDebugLoggingEnabled();
        if (debugLoggingEnabled) {
            LOGGER.info("[NBT Debug] String comparison: '{}' {} '{}'", (Object)actual, (Object)operator, (Object)expected);
        }
        switch (operator) {
            case "==": {
                return actual.equals(expected);
            }
            case "!=": {
                return !actual.equals(expected);
            }
            case "contains": {
                return actual.contains(expected);
            }
            case "startsWith": {
                return actual.startsWith(expected);
            }
            case "endsWith": {
                return actual.endsWith(expected);
            }
        }
        LOGGER.warn("Unknown string operator: {}", (Object)operator);
        return false;
    }

    private static boolean compareBoolean(Tag nbtValue, String operator, String expectedValue) {
        boolean debugLoggingEnabled = LootConfig.isDebugLoggingEnabled();
        boolean actual = ((ByteTag)nbtValue).m_7063_() != 0;
        boolean expected = Boolean.parseBoolean(expectedValue);
        if (debugLoggingEnabled) {
            LOGGER.info("[NBT Debug] Boolean comparison: {} {} {}", (Object)actual, (Object)operator, (Object)expected);
        }
        switch (operator) {
            case "==": {
                return actual == expected;
            }
            case "!=": {
                return actual != expected;
            }
        }
        LOGGER.warn("Unknown boolean operator: {}", (Object)operator);
        return false;
    }

    public static void processNBTDrop(LivingDropsEvent event, CustomDropEntry drop, Player player, String eventName) {
        boolean debugLoggingEnabled = LootConfig.isDebugLoggingEnabled();
        String itemId = drop.getNbtEntityDrop();
        float dropChance = drop.getNbtEntityDropChance().floatValue();
        int minAmount = drop.getNbtEntityDropMin();
        int maxAmount = drop.getNbtEntityDropMax();
        if (debugLoggingEnabled) {
            LOGGER.info("[NBT Drop] Processing NBT drop for event: {}", (Object)(eventName != null ? eventName : "normal"));
            LOGGER.info("[NBT Drop] Item: {}, Chance: {}%, Amount: {}-{}", (Object)itemId, (Object)Float.valueOf(dropChance), (Object)minAmount, (Object)maxAmount);
        }
        if (RANDOM.nextFloat() * 100.0f <= dropChance) {
            int amount = NBTDropHandler.calculateAmount(minAmount, maxAmount);
            ItemStack stack = NBTDropHandler.createItemStack(itemId, amount, drop);
            if (stack != null && !stack.m_41619_()) {
                event.getEntity().m_19983_(stack);
                if (debugLoggingEnabled) {
                    LOGGER.info("[NBT Drop] Dropped {} x{} at {}", (Object)itemId, (Object)amount, (Object)event.getEntity().m_20182_());
                }
            }
        } else if (debugLoggingEnabled) {
            LOGGER.info("[NBT Drop] Drop chance failed for {}", (Object)itemId);
        }
    }

    private static int calculateAmount(int min, int max) {
        if (min >= max) {
            return min;
        }
        return min + RANDOM.nextInt(max - min + 1);
    }

    private static ItemStack createItemStack(String itemId, int amount, CustomDropEntry drop) {
        boolean debugLoggingEnabled = LootConfig.isDebugLoggingEnabled();
        try {
            ResourceLocation itemLocation = new ResourceLocation(itemId);
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
            if (item == null) {
                LOGGER.error("Invalid item ID: {}", (Object)itemId);
                return null;
            }
            ItemStack stack = new ItemStack((ItemLike)item, amount);
            if (drop.getNbtData() != null && !drop.getNbtData().isEmpty()) {
                try {
                    CompoundTag nbt = TagParser.m_129359_((String)drop.getNbtData());
                    stack.m_41751_(nbt);
                    if (debugLoggingEnabled) {
                        LOGGER.info("[NBT Drop] Applied NBT data to item: {}", (Object)drop.getNbtData());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to parse NBT data for item {}: {}", (Object)itemId, (Object)e.getMessage());
                }
            }
            return stack;
        }
        catch (Exception e) {
            LOGGER.error("Error creating item stack for {}: {}", (Object)itemId, (Object)e.getMessage());
            if (debugLoggingEnabled) {
                e.printStackTrace();
            }
            return null;
        }
    }
}

