/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops.lootdrops.events;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.poe.entitylootdrops.lootdrops.events.LootEventHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootEventManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CONFIG_DIR = "config/EntityLootDrops";
    private static final String LOOT_DROPS_DIR = "Loot Drops";
    private static final String EVENT_DROPS_DIR = "Event Drops";
    private Set<String> activeEvents = new HashSet<String>();
    private boolean dropChanceEventActive = false;
    private boolean doubleDropsActive = false;
    private boolean debugLoggingEnabled = false;
    private boolean dropCountEnabled = false;
    private Map<UUID, PlayerDropCount> playerDropCounts = new HashMap<UUID, PlayerDropCount>();
    private Map<String, String> eventEnableMessages = new HashMap<String, String>();
    private Map<String, String> eventDisableMessages = new HashMap<String, String>();
    private String dropChanceEnableMessage = "\u00a76[Events] \u00a7aDouble Drop Chance \u00a7eevent has been enabled! \u00a7e(2x drop rates)";
    private String dropChanceDisableMessage = "\u00a76[Events] \u00a7cDouble Drop Chance event has been disabled!";
    private String doubleDropsEnableMessage = "\u00a76[Events] \u00a7aDouble Drops \u00a7eevent has been enabled! \u00a7e(2x drop amounts)";
    private String doubleDropsDisableMessage = "\u00a76[Events] \u00a7cDouble Drops event has been disabled!";

    public boolean isEventActive(String eventName) {
        return this.activeEvents.contains(eventName.toLowerCase());
    }

    public void toggleEvent(String eventName, boolean active, Set<String> availableEvents) {
        Path eventsDir;
        String actualEventName = null;
        for (String key : availableEvents) {
            if (!key.equalsIgnoreCase(eventName)) continue;
            actualEventName = key;
            break;
        }
        if (actualEventName == null && Files.exists(eventsDir = Paths.get(CONFIG_DIR, LOOT_DROPS_DIR, EVENT_DROPS_DIR), new LinkOption[0])) {
            try {
                Optional<Path> matchingDir = Files.list(eventsDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).filter(dir -> dir.getFileName().toString().equalsIgnoreCase(eventName)).findFirst();
                if (matchingDir.isPresent()) {
                    actualEventName = matchingDir.get().getFileName().toString();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to check event directories", (Throwable)e);
            }
        }
        if (actualEventName == null) {
            actualEventName = eventName;
            LOGGER.warn("Event '{}' not found in configuration, using name as-is", (Object)eventName);
        }
        if (active) {
            this.activeEvents.add(actualEventName.toLowerCase());
            this.broadcastEventMessage(this.getEventEnableMessage(actualEventName));
            LOGGER.info("Enabled event: {}", (Object)actualEventName);
        } else {
            this.activeEvents.remove(actualEventName.toLowerCase());
            this.broadcastEventMessage(this.getEventDisableMessage(actualEventName));
            LOGGER.info("Disabled event: {}", (Object)actualEventName);
        }
        this.saveActiveEventsState();
    }

    public void toggleDropChanceEvent(boolean active) {
        this.dropChanceEventActive = active;
        if (active) {
            this.broadcastEventMessage(this.dropChanceEnableMessage);
            LOGGER.info("Enabled drop chance event");
        } else {
            this.broadcastEventMessage(this.dropChanceDisableMessage);
            LOGGER.info("Disabled drop chance event");
        }
        this.saveActiveEventsState();
    }

    public void toggleDoubleDrops(boolean active) {
        this.doubleDropsActive = active;
        if (active) {
            this.broadcastEventMessage(this.doubleDropsEnableMessage);
            LOGGER.info("Enabled double drops event");
        } else {
            this.broadcastEventMessage(this.doubleDropsDisableMessage);
            LOGGER.info("Disabled double drops event");
        }
        this.saveActiveEventsState();
    }

    public void enableDropCount(boolean enabled) {
        this.dropCountEnabled = enabled;
        if (enabled) {
            this.broadcastEventMessage("\u00a76[Drop Count] \u00a7aEnabled drop counting! \u00a77Items will be tracked per player.");
            LOGGER.info("Enabled drop counting");
            this.createDropCountFile();
        } else {
            this.broadcastEventMessage("\u00a76[Drop Count] \u00a7cDisabled drop counting.");
            LOGGER.info("Disabled drop counting");
        }
        this.saveActiveEventsState();
    }

    public void recordDrop(Player player, String itemId, int amount) {
        if (!this.dropCountEnabled || player == null) {
            return;
        }
        UUID playerId = player.m_20148_();
        PlayerDropCount dropCount = this.playerDropCounts.computeIfAbsent(playerId, k -> new PlayerDropCount(player.m_7755_().getString()));
        dropCount.setPlayerName(player.m_7755_().getString());
        dropCount.addDrop(itemId, amount);
        LOGGER.debug("Recorded drop for {}: {} x{} (Total: {})", (Object)player.m_7755_().getString(), (Object)itemId, (Object)amount, (Object)dropCount.getTotalDrops());
        if (dropCount.getTotalDrops() % 10 == 0) {
            this.saveDropCountData();
        }
    }

    public Optional<PlayerDropCount> getPlayerDropCount(UUID playerId) {
        return Optional.ofNullable(this.playerDropCounts.get(playerId));
    }

    public Optional<PlayerDropCount> getPlayerDropCount(String playerName) {
        return this.playerDropCounts.values().stream().filter(dropCount -> playerName.equals(dropCount.getPlayerName())).findFirst();
    }

    public List<Map.Entry<UUID, PlayerDropCount>> getTopDropCounts() {
        return this.playerDropCounts.entrySet().stream().sorted((a, b) -> Integer.compare(((PlayerDropCount)b.getValue()).getTotalDrops(), ((PlayerDropCount)a.getValue()).getTotalDrops())).toList();
    }

    public void resetDropCounts() {
        this.playerDropCounts.clear();
        this.broadcastEventMessage("\u00a76[Drop Count] \u00a7eAll drop counts have been reset!");
        LOGGER.info("Reset all drop counts");
        this.saveDropCountData();
    }

    public void clearActiveEvents() {
        this.activeEvents.clear();
        this.dropChanceEventActive = false;
        this.doubleDropsActive = false;
        this.broadcastEventMessage("\u00a76[Events] \u00a7cAll events have been disabled!");
        LOGGER.info("Cleared all active events");
        this.saveActiveEventsState();
    }

    public Set<String> getActiveEvents() {
        return new HashSet<String>(this.activeEvents);
    }

    public int getActiveEventsCount() {
        int count = this.activeEvents.size();
        if (this.dropChanceEventActive) {
            ++count;
        }
        if (this.doubleDropsActive) {
            ++count;
        }
        if (this.dropCountEnabled) {
            ++count;
        }
        return count;
    }

    public boolean isDropChanceEventActive() {
        return this.dropChanceEventActive;
    }

    public boolean isDoubleDropsActive() {
        return this.doubleDropsActive;
    }

    public boolean isDebugLoggingEnabled() {
        return this.debugLoggingEnabled;
    }

    public boolean isDropCountEnabled() {
        return this.dropCountEnabled;
    }

    public void setDebugLogging(boolean enabled) {
        this.debugLoggingEnabled = enabled;
        LootEventHandler.setDebugLogging(enabled);
        LOGGER.info("Debug logging {}", (Object)(enabled ? "enabled" : "disabled"));
        this.saveActiveEventsState();
    }

    public void createDropCountFile() {
        try {
            Path dropCountFile = Paths.get(CONFIG_DIR, "Drop_Count.json");
            if (!Files.exists(dropCountFile, new LinkOption[0])) {
                Files.createDirectories(dropCountFile.getParent(), new FileAttribute[0]);
                HashMap<String, Object> defaultData = new HashMap<String, Object>();
                defaultData.put("enabled", this.dropCountEnabled);
                defaultData.put("playerDropCounts", new HashMap());
                defaultData.put("lastUpdated", System.currentTimeMillis());
                defaultData.put("comment", "Tracks custom item drops per player for events. Player UUIDs are used as keys.");
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                Files.writeString(dropCountFile, (CharSequence)gson.toJson(defaultData), new OpenOption[0]);
                LOGGER.info("Created Drop_Count.json file: {}", (Object)dropCountFile);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create Drop_Count.json file", (Throwable)e);
        }
    }

    public void createActiveEventsFile() {
        try {
            Path stateFile = Paths.get(CONFIG_DIR, "Active_Events.json");
            if (!Files.exists(stateFile, new LinkOption[0])) {
                Files.createDirectories(stateFile.getParent(), new FileAttribute[0]);
                HashMap<String, Serializable> defaultState = new HashMap<String, Serializable>();
                defaultState.put("activeEvents", new ArrayList());
                defaultState.put("dropChanceEventActive", Boolean.valueOf(false));
                defaultState.put("doubleDropsActive", Boolean.valueOf(false));
                defaultState.put("debugLoggingEnabled", Boolean.valueOf(false));
                defaultState.put("dropCountEnabled", Boolean.valueOf(false));
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                Files.writeString(stateFile, (CharSequence)gson.toJson(defaultState), new OpenOption[0]);
                LOGGER.info("Created Active_Events.json file: {}", (Object)stateFile);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to create Active_Events.json file", (Throwable)e);
        }
    }

    public void saveDropCountData() {
        try {
            Path dropCountFile = Paths.get(CONFIG_DIR, "Drop_Count.json");
            Files.createDirectories(dropCountFile.getParent(), new FileAttribute[0]);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("enabled", this.dropCountEnabled);
            data.put("playerDropCounts", this.playerDropCounts);
            data.put("lastUpdated", System.currentTimeMillis());
            data.put("comment", "Tracks custom item drops per player for events. Player UUIDs are used as keys.");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Files.writeString(dropCountFile, (CharSequence)gson.toJson(data), new OpenOption[0]);
            LOGGER.debug("Saved drop count data to: {}", (Object)dropCountFile);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save drop count data", (Throwable)e);
        }
    }

    public void loadDropCountData() {
        try {
            Path dropCountFile = Paths.get(CONFIG_DIR, "Drop_Count.json");
            if (!Files.exists(dropCountFile, new LinkOption[0])) {
                LOGGER.debug("Drop_Count.json does not exist, using defaults");
                return;
            }
            String json = new String(Files.readAllBytes(dropCountFile));
            if (json.trim().isEmpty()) {
                LOGGER.warn("Drop_Count.json is empty");
                return;
            }
            Gson gson = new Gson();
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Map data = (Map)gson.fromJson(json, mapType);
            if (data.containsKey("enabled")) {
                this.dropCountEnabled = (Boolean)data.get("enabled");
            }
            if (data.containsKey("playerDropCounts")) {
                Type playerCountsType = new TypeToken<Map<String, PlayerDropCount>>(){}.getType();
                Map counts = (Map)gson.fromJson(gson.toJson(data.get("playerDropCounts")), playerCountsType);
                this.playerDropCounts.clear();
                if (counts != null) {
                    counts.forEach((uuidStr, dropCount) -> {
                        try {
                            UUID playerId = UUID.fromString(uuidStr);
                            this.playerDropCounts.put(playerId, (PlayerDropCount)dropCount);
                        }
                        catch (IllegalArgumentException e) {
                            LOGGER.warn("Invalid UUID in drop count data: {}", uuidStr);
                        }
                    });
                }
            }
            LOGGER.info("Loaded drop count data: {} players tracked", (Object)this.playerDropCounts.size());
        }
        catch (Exception e) {
            LOGGER.error("Failed to load drop count data", (Throwable)e);
        }
    }

    public void saveActiveEventsState() {
        try {
            Path stateFile = Paths.get(CONFIG_DIR, "Active_Events.json");
            Files.createDirectories(stateFile.getParent(), new FileAttribute[0]);
            HashMap<String, Serializable> state = new HashMap<String, Serializable>();
            state.put("activeEvents", new ArrayList<String>(this.activeEvents));
            state.put("dropChanceEventActive", Boolean.valueOf(this.dropChanceEventActive));
            state.put("doubleDropsActive", Boolean.valueOf(this.doubleDropsActive));
            state.put("debugLoggingEnabled", Boolean.valueOf(this.debugLoggingEnabled));
            state.put("dropCountEnabled", Boolean.valueOf(this.dropCountEnabled));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Files.writeString(stateFile, (CharSequence)gson.toJson(state), new OpenOption[0]);
            LOGGER.debug("Saved active events state to: {}", (Object)stateFile);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save active events state", (Throwable)e);
        }
    }

    public void loadActiveEventsState() {
        try {
            Path stateFile = Paths.get(CONFIG_DIR, "Active_Events.json");
            if (!Files.exists(stateFile, new LinkOption[0])) {
                this.createActiveEventsFile();
                return;
            }
            LOGGER.info("Loading active events state from: {}", (Object)stateFile);
            String json = new String(Files.readAllBytes(stateFile));
            if (json.trim().isEmpty()) {
                LOGGER.warn("Active_Events.json is empty, creating default state");
                this.createActiveEventsFile();
                return;
            }
            Gson gson = new Gson();
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Map state = (Map)gson.fromJson(json, mapType);
            if (state != null) {
                if (state.containsKey("activeEvents")) {
                    this.activeEvents.clear();
                    List events = (List)state.get("activeEvents");
                    if (events != null) {
                        this.activeEvents.addAll(events);
                        LOGGER.info("Restored {} active events from state file", (Object)events.size());
                    }
                }
                if (state.containsKey("dropChanceEventActive")) {
                    this.dropChanceEventActive = (Boolean)state.get("dropChanceEventActive");
                    LOGGER.info("Restored drop chance event state: {}", (Object)this.dropChanceEventActive);
                }
                if (state.containsKey("doubleDropsActive")) {
                    this.doubleDropsActive = (Boolean)state.get("doubleDropsActive");
                    LOGGER.info("Restored double drops event state: {}", (Object)this.doubleDropsActive);
                }
                if (state.containsKey("debugLoggingEnabled")) {
                    this.debugLoggingEnabled = (Boolean)state.get("debugLoggingEnabled");
                    LootEventHandler.setDebugLogging(this.debugLoggingEnabled);
                    LOGGER.info("Restored debug logging state: {}", (Object)this.debugLoggingEnabled);
                }
                if (state.containsKey("dropCountEnabled")) {
                    this.dropCountEnabled = (Boolean)state.get("dropCountEnabled");
                    LOGGER.info("Restored drop count enabled state: {}", (Object)this.dropCountEnabled);
                }
            }
            this.loadDropCountData();
        }
        catch (Exception e) {
            LOGGER.error("Failed to load active events state", (Throwable)e);
            this.createActiveEventsFile();
        }
    }

    public void restorePreviousState(Set<String> previousActiveEvents, boolean previousDropChanceState, boolean previousDoubleDropsState, boolean previousDebugState) {
        if (this.activeEvents.isEmpty() && !previousActiveEvents.isEmpty()) {
            this.activeEvents.addAll(previousActiveEvents);
            this.dropChanceEventActive = previousDropChanceState;
            this.doubleDropsActive = previousDoubleDropsState;
            this.debugLoggingEnabled = previousDebugState;
            this.saveActiveEventsState();
        }
    }

    private void broadcastEventMessage(String message) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.m_6846_().m_240416_((Component)Component.m_237113_((String)message), false);
        }
    }

    public void setEventMessages(Map<String, String> enableMessages, Map<String, String> disableMessages) {
        if (enableMessages != null) {
            this.eventEnableMessages.putAll(enableMessages);
        }
        if (disableMessages != null) {
            this.eventDisableMessages.putAll(disableMessages);
        }
    }

    public void setEventEnableMessage(String eventName, String message) {
        this.eventEnableMessages.put(eventName.toLowerCase(), message);
    }

    public void setEventDisableMessage(String eventName, String message) {
        this.eventDisableMessages.put(eventName.toLowerCase(), message);
    }

    public String getEventEnableMessage(String eventName) {
        return this.eventEnableMessages.getOrDefault(eventName.toLowerCase(), "\u00a76[Events] \u00a7a" + eventName + " event has been enabled!");
    }

    public String getEventDisableMessage(String eventName) {
        return this.eventDisableMessages.getOrDefault(eventName.toLowerCase(), "\u00a76[Events] \u00a7c" + eventName + " event has been disabled!");
    }

    public void setDropChanceEnableMessage(String message) {
        this.dropChanceEnableMessage = message;
    }

    public void setDropChanceDisableMessage(String message) {
        this.dropChanceDisableMessage = message;
    }

    public String getDropChanceEnableMessage() {
        return this.dropChanceEnableMessage;
    }

    public String getDropChanceDisableMessage() {
        return this.dropChanceDisableMessage;
    }

    public void setDoubleDropsEnableMessage(String message) {
        this.doubleDropsEnableMessage = message;
    }

    public void setDoubleDropsDisableMessage(String message) {
        this.doubleDropsDisableMessage = message;
    }

    public String getDoubleDropsEnableMessage() {
        return this.doubleDropsEnableMessage;
    }

    public String getDoubleDropsDisableMessage() {
        return this.doubleDropsDisableMessage;
    }

    public static class PlayerDropCount {
        private String playerName;
        private int totalDrops = 0;
        private Map<String, Integer> itemCounts = new HashMap<String, Integer>();
        private long lastUpdated = System.currentTimeMillis();

        public PlayerDropCount() {
        }

        public PlayerDropCount(String playerName) {
            this.playerName = playerName;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public void setPlayerName(String playerName) {
            this.playerName = playerName;
        }

        public int getTotalDrops() {
            return this.totalDrops;
        }

        public void setTotalDrops(int totalDrops) {
            this.totalDrops = totalDrops;
        }

        public Map<String, Integer> getItemCounts() {
            return this.itemCounts;
        }

        public void setItemCounts(Map<String, Integer> itemCounts) {
            this.itemCounts = itemCounts;
        }

        public long getLastUpdated() {
            return this.lastUpdated;
        }

        public void setLastUpdated(long lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        public void addDrop(String itemId, int amount) {
            this.totalDrops += amount;
            this.itemCounts.put(itemId, this.itemCounts.getOrDefault(itemId, 0) + amount);
            this.lastUpdated = System.currentTimeMillis();
        }
    }
}

