/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops.lootdrops.events;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.advancements.Advancement;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.poe.entitylootdrops.lootdrops.LootConfig;
import net.poe.entitylootdrops.lootdrops.config.EventConfig;
import net.poe.entitylootdrops.lootdrops.events.EventDropCountManager;
import net.poe.entitylootdrops.lootdrops.handlers.NBTDropHandler;
import net.poe.entitylootdrops.lootdrops.model.CustomDropEntry;
import net.poe.entitylootdrops.lootdrops.model.EntityDropEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="entitylootdrops")
public class LootEventHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Random RANDOM = new Random();
    private static boolean debugLoggingEnabled = false;
    private static final Map<UUID, Map<String, Long>> commandCooldowns = new HashMap<UUID, Map<String, Long>>();

    public static void setDebugLogging(boolean enabled) {
        debugLoggingEnabled = enabled;
        if (enabled) {
            LOGGER.info("Debug logging enabled for EntityLootDrops");
        } else {
            LOGGER.info("Debug logging disabled for EntityLootDrops");
        }
    }

    private static void logDebug(String message, Object ... args) {
        if (debugLoggingEnabled) {
            LOGGER.info("[DEBUG] " + message, args);
        }
    }

    private static boolean isCommandOnCooldown(Player player, String command, int cooldownSeconds) {
        long cooldownMs;
        if (cooldownSeconds <= 0) {
            return false;
        }
        UUID playerId = player.m_20148_();
        String commandHash = "" + command.hashCode();
        long currentTime = System.currentTimeMillis();
        Map playerCooldowns = commandCooldowns.computeIfAbsent(playerId, k -> new HashMap());
        Long lastExecution = (Long)playerCooldowns.get(commandHash);
        if (lastExecution == null) {
            return false;
        }
        long timeSinceLastExecution = currentTime - lastExecution;
        return timeSinceLastExecution < (cooldownMs = (long)cooldownSeconds * 1000L);
    }

    private static void setCommandCooldown(Player player, String command) {
        UUID playerId = player.m_20148_();
        String commandHash = "" + command.hashCode();
        long currentTime = System.currentTimeMillis();
        Map playerCooldowns = commandCooldowns.computeIfAbsent(playerId, k -> new HashMap());
        playerCooldowns.put(commandHash, currentTime);
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity == null || entity.m_9236_().f_46443_) {
            return;
        }
        ResourceLocation entityType = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        if (entityType == null) {
            return;
        }
        String entityIdStr = entityType.toString();
        boolean isHostile = entity instanceof Enemy;
        boolean playerKilled = event.getSource().m_7639_() instanceof Player;
        Player player = playerKilled ? (Player)event.getSource().m_7639_() : null;
        LootEventHandler.logDebug("Processing drops for {} (hostile: {}, player killed: {})", entityIdStr, isHostile, playerKilled);
        LootEventHandler.handleVanillaDropModifications(event, entityIdStr, isHostile, player, playerKilled);
        if (playerKilled && player != null) {
            LootEventHandler.applyDropEvents(event);
        }
        LootEventHandler.processExtraVanillaDrops(event, entity, player, entityIdStr, isHostile);
        LootEventHandler.processCustomDrops(event, entityIdStr, isHostile, player, playerKilled);
    }

    private static void handleVanillaDropModifications(LivingDropsEvent event, String entityIdStr, boolean isHostile, Player player, boolean playerKilled) {
        Object applicableHostileDrops;
        boolean shouldCancelVanillaDrops = false;
        HashSet<String> allowedModIDs = new HashSet<String>();
        for (EntityDropEntry entityDropEntry : LootConfig.getNormalDrops()) {
            if (!entityDropEntry.getEntityId().equals(entityIdStr)) continue;
            if (!entityDropEntry.isAllowDefaultDrops()) {
                shouldCancelVanillaDrops = true;
            }
            if (entityDropEntry.getAllowModIDs() == null || entityDropEntry.getAllowModIDs().isEmpty()) continue;
            allowedModIDs.addAll(entityDropEntry.getAllowModIDs());
        }
        if (isHostile && !(applicableHostileDrops = LootEventHandler.getApplicableHostileDrops(player, playerKilled)).isEmpty()) {
            Iterator iterator = applicableHostileDrops.iterator();
            while (iterator.hasNext()) {
                CustomDropEntry drop2 = (CustomDropEntry)iterator.next();
                if (!drop2.isAllowDefaultDrops()) {
                    shouldCancelVanillaDrops = true;
                }
                if (drop2.getAllowModIDs() == null || drop2.getAllowModIDs().isEmpty()) continue;
                allowedModIDs.addAll(drop2.getAllowModIDs());
            }
        }
        for (String string : LootConfig.getActiveEvents()) {
            List<CustomDropEntry> applicableEventHostileDrops;
            String matchingEventName = LootEventHandler.findMatchingEventName(string);
            if (matchingEventName == null) continue;
            List<EntityDropEntry> eventDropList = LootConfig.getEventDrops().get(matchingEventName);
            if (eventDropList != null) {
                for (EntityDropEntry entityDropEntry : eventDropList) {
                    if (!entityDropEntry.getEntityId().equals(entityIdStr)) continue;
                    if (!entityDropEntry.isAllowDefaultDrops()) {
                        shouldCancelVanillaDrops = true;
                    }
                    if (entityDropEntry.getAllowModIDs() == null || entityDropEntry.getAllowModIDs().isEmpty()) continue;
                    allowedModIDs.addAll(entityDropEntry.getAllowModIDs());
                }
            }
            if (!isHostile || (applicableEventHostileDrops = LootEventHandler.getApplicableEventHostileDrops(matchingEventName, player, playerKilled)).isEmpty()) continue;
            for (CustomDropEntry drop4 : applicableEventHostileDrops) {
                if (!drop4.isAllowDefaultDrops()) {
                    shouldCancelVanillaDrops = true;
                }
                if (drop4.getAllowModIDs() == null || drop4.getAllowModIDs().isEmpty()) continue;
                allowedModIDs.addAll(drop4.getAllowModIDs());
            }
        }
        if (!shouldCancelVanillaDrops && allowedModIDs.isEmpty()) {
            return;
        }
        ArrayList<ItemEntity> filteredDrops = new ArrayList<ItemEntity>();
        for (ItemEntity itemEntity : event.getDrops()) {
            ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)itemEntity.m_32055_().m_41720_());
            if (itemId == null) continue;
            String modId = itemId.m_135827_();
            boolean bl = false;
            if (!shouldCancelVanillaDrops) {
                bl = true;
            } else if (!allowedModIDs.isEmpty() && allowedModIDs.contains(modId)) {
                bl = true;
            }
            if (!bl) continue;
            filteredDrops.add(itemEntity);
        }
        event.getDrops().clear();
        event.getDrops().addAll(filteredDrops);
        LootEventHandler.logDebug("Filtered vanilla drops: cancelled={}, allowed mods={}", shouldCancelVanillaDrops, allowedModIDs);
    }

    private static List<CustomDropEntry> getApplicableHostileDrops(Player player, boolean playerKilled) {
        ArrayList<CustomDropEntry> applicableDrops = new ArrayList<CustomDropEntry>();
        for (CustomDropEntry drop : LootConfig.getNormalHostileDrops()) {
            if (!LootEventHandler.checkDropRequirements(drop, player, playerKilled)) continue;
            applicableDrops.add(drop);
        }
        return applicableDrops;
    }

    private static List<CustomDropEntry> getApplicableEventHostileDrops(String eventName, Player player, boolean playerKilled) {
        ArrayList<CustomDropEntry> applicableDrops = new ArrayList<CustomDropEntry>();
        for (CustomDropEntry drop : LootConfig.getEventHostileDrops(eventName)) {
            if (!LootEventHandler.checkDropRequirements(drop, player, playerKilled)) continue;
            applicableDrops.add(drop);
        }
        return applicableDrops;
    }

    private static void applyDropEvents(LivingDropsEvent event) {
        if (LootConfig.isDoubleDropsActive()) {
            double multiplier = EventConfig.getDoubleDropChanceMultiplier();
            if (multiplier <= 1.0) {
                return;
            }
            ArrayList additionalDrops = new ArrayList();
            event.getDrops().forEach(itemEntity -> {
                ItemStack originalStack = itemEntity.m_32055_();
                ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)originalStack.m_41720_());
                if (itemId != null && EventConfig.shouldAffectMod(itemId.m_135827_())) {
                    int additionalCopies = (int)(multiplier - 1.0);
                    for (int i = 0; i < additionalCopies; ++i) {
                        ItemStack duplicateStack = new ItemStack((ItemLike)originalStack.m_41720_(), originalStack.m_41613_());
                        if (originalStack.m_41783_() != null) {
                            duplicateStack.m_41751_(originalStack.m_41783_().m_6426_());
                        }
                        ItemEntity duplicateEntity = new ItemEntity(itemEntity.m_9236_(), itemEntity.m_20185_(), itemEntity.m_20186_(), itemEntity.m_20189_(), duplicateStack);
                        duplicateEntity.m_20256_(itemEntity.m_20184_());
                        additionalDrops.add(duplicateEntity);
                    }
                }
            });
            event.getDrops().addAll(additionalDrops);
        }
    }

    private static void processExtraVanillaDrops(LivingDropsEvent event, LivingEntity entity, Player player, String entityIdStr, boolean isHostile) {
        for (EntityDropEntry entityDropEntry : LootConfig.getNormalDrops()) {
            if (!entityDropEntry.getEntityId().equals(entityIdStr)) continue;
            LootEventHandler.addExtraVanillaDrops(event, entityDropEntry, player, entity);
        }
        if (isHostile) {
            for (CustomDropEntry customDropEntry : LootConfig.getNormalHostileDrops()) {
                LootEventHandler.addExtraVanillaDrops(event, customDropEntry, player, entity);
            }
        }
        for (String string : LootConfig.getActiveEvents()) {
            String matchingEventName = LootEventHandler.findMatchingEventName(string);
            if (matchingEventName == null) continue;
            LootEventHandler.processEventExtraDrops(event, entityIdStr, matchingEventName, player, entity, isHostile);
        }
    }

    private static void processEventExtraDrops(LivingDropsEvent event, String entityIdStr, String eventName, Player player, LivingEntity entity, boolean isHostile) {
        List<EntityDropEntry> eventDropList = LootConfig.getEventDrops().get(eventName);
        if (eventDropList != null) {
            for (EntityDropEntry entityDropEntry : eventDropList) {
                if (!entityDropEntry.getEntityId().equals(entityIdStr)) continue;
                LootEventHandler.addExtraVanillaDrops(event, entityDropEntry, player, entity);
            }
        }
        if (isHostile) {
            for (CustomDropEntry customDropEntry : LootConfig.getEventHostileDrops(eventName)) {
                LootEventHandler.addExtraVanillaDrops(event, customDropEntry, player, entity);
            }
        }
    }

    private static void addExtraVanillaDrops(LivingDropsEvent event, CustomDropEntry drop, Player player, LivingEntity entity) {
        if (drop.getExtraDropChance() <= 0.0f || !LootEventHandler.checkDropRequirements(drop, player)) {
            return;
        }
        float extraDropRoll = RANDOM.nextFloat() * 100.0f;
        if (extraDropRoll <= drop.getExtraDropChance()) {
            int extraMultiplier = LootEventHandler.calculateAmount(drop.getExtraAmountMin(), drop.getExtraAmountMax());
            List<ItemEntity> extraDrops = LootEventHandler.duplicateVanillaDrops(event, extraMultiplier);
            event.getDrops().addAll(extraDrops);
            LootEventHandler.logDebug("Added {} extra vanilla drops ({}x multiplier)", extraDrops.size(), extraMultiplier);
        }
    }

    private static List<ItemEntity> duplicateVanillaDrops(LivingDropsEvent event, int multiplier) {
        ArrayList<ItemEntity> duplicates = new ArrayList<ItemEntity>();
        for (ItemEntity itemEntity : event.getDrops()) {
            for (int i = 0; i < multiplier; ++i) {
                ItemEntity duplicate = LootEventHandler.createDuplicateItemEntity(itemEntity);
                duplicates.add(duplicate);
            }
        }
        return duplicates;
    }

    private static ItemEntity createDuplicateItemEntity(ItemEntity original) {
        ItemStack originalStack = original.m_32055_();
        ItemStack duplicateStack = new ItemStack((ItemLike)originalStack.m_41720_(), originalStack.m_41613_());
        if (originalStack.m_41782_()) {
            duplicateStack.m_41751_(originalStack.m_41783_().m_6426_());
        }
        ItemEntity duplicate = new ItemEntity(original.m_9236_(), original.m_20185_(), original.m_20186_(), original.m_20189_(), duplicateStack);
        duplicate.m_20256_(original.m_20184_());
        return duplicate;
    }

    private static void processCustomDrops(LivingDropsEvent event, String entityIdStr, boolean isHostile, Player player, boolean playerKilled) {
        LootEventHandler.processEntityDrops(event, entityIdStr, LootConfig.getNormalDrops(), player, playerKilled, "Normal");
        if (isHostile) {
            LootEventHandler.processDrops(event, LootConfig.getNormalHostileDrops(), player, playerKilled, "Normal");
        }
        for (String eventName : LootConfig.getActiveEvents()) {
            String matchingEventName = LootEventHandler.findMatchingEventName(eventName);
            if (matchingEventName == null) continue;
            LootEventHandler.processEventDrops(event, entityIdStr, matchingEventName, player, playerKilled, isHostile);
        }
    }

    private static void processEventDrops(LivingDropsEvent event, String entityIdStr, String eventName, Player player, boolean playerKilled, boolean isHostile) {
        List<EntityDropEntry> eventDropList = LootConfig.getEventDrops().get(eventName);
        if (eventDropList != null) {
            LootEventHandler.processEntityDrops(event, entityIdStr, eventDropList, player, playerKilled, eventName);
        }
        if (isHostile) {
            LootEventHandler.processDrops(event, LootConfig.getEventHostileDrops(eventName), player, playerKilled, eventName);
        }
    }

    private static String findMatchingEventName(String eventName) {
        for (String key : LootConfig.getEventDrops().keySet()) {
            if (!key.equalsIgnoreCase(eventName)) continue;
            return key;
        }
        return null;
    }

    private static void processEntityDrops(LivingDropsEvent event, String entityIdStr, List<EntityDropEntry> dropsList, Player player, boolean playerKilled, String eventName) {
        for (EntityDropEntry drop : dropsList) {
            if (!drop.getEntityId().equals(entityIdStr)) continue;
            LootEventHandler.processDropEntry(event, drop, player, playerKilled, eventName);
        }
    }

    private static void processDrops(LivingDropsEvent event, List<CustomDropEntry> drops, Player player, boolean playerKilled, String eventName) {
        for (CustomDropEntry drop : drops) {
            LootEventHandler.processDropEntry(event, drop, player, playerKilled, eventName);
        }
    }

    private static void processDropEntry(LivingDropsEvent event, CustomDropEntry drop, Player player, boolean playerKilled, String eventName) {
        try {
            if (!NBTDropHandler.checkNBTConditions(drop, event.getEntity())) {
                return;
            }
            if (!LootEventHandler.checkDropRequirements(drop, player, playerKilled)) {
                return;
            }
            LootEventHandler.executeDropCommand(drop, player, event.getEntity());
            if (drop.hasNbtEntityCondition() && drop.getNbtEntityDrop() != null) {
                NBTDropHandler.processNBTDrop(event, drop, player, eventName);
            } else {
                LootEventHandler.handleItemDrop(event, drop, player, eventName);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error processing drop {}: {}", (Object)drop.getItemId(), (Object)e.getMessage());
        }
    }

    private static void executeDropCommand(CustomDropEntry drop, Player player, LivingEntity entity) {
        if (drop.hasCommand() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LootEventHandler.logDebug("Checking cooldown for command: {} (cooldown: {})", drop.getCommand(), drop.getCommandCoolDown());
            if (LootEventHandler.isCommandOnCooldown(player, drop.getCommand(), drop.getCommandCoolDown())) {
                LootEventHandler.logDebug("Command on cooldown for player {}: {}", player.m_7755_().getString(), drop.getCommand());
                return;
            }
            float commandChance = drop.getCommandChance();
            if (commandChance > 0.0f && RANDOM.nextFloat() * 100.0f <= commandChance) {
                LootEventHandler.logDebug("Executing command: {}", drop.getCommand());
                LootEventHandler.executeCommand(drop.getCommand(), serverPlayer, entity);
                if (drop.getCommandCoolDown() > 0) {
                    LootEventHandler.logDebug("Setting cooldown for {} seconds", drop.getCommandCoolDown());
                    LootEventHandler.setCommandCooldown(player, drop.getCommand());
                    LootEventHandler.logDebug("Cooldown set for player {}", player.m_7755_().getString());
                }
            }
        }
    }

    private static void handleItemDrop(LivingDropsEvent event, CustomDropEntry drop, Player player, String eventName) {
        int amount;
        ItemStack stack;
        if (drop.getItemId() == null || drop.getItemId().isEmpty()) {
            return;
        }
        float dropChance = drop.getDropChance();
        if (LootConfig.isDropChanceEventActive() && event.getSource().m_7639_() instanceof Player) {
            dropChance *= 2.0f;
        }
        if (RANDOM.nextFloat() * 100.0f <= dropChance && (stack = LootEventHandler.createItemStack(drop, amount = LootEventHandler.calculateAmount(drop.getMinAmount(), drop.getMaxAmount()))) != null) {
            event.getEntity().m_19983_(stack);
            LootEventHandler.logDebug("Dropped {} x{} from {}", drop.getItemId(), amount, ForgeRegistries.ENTITY_TYPES.getKey((Object)event.getEntity().m_6095_()));
            LootEventHandler.recordDropCountEnabledItems(player, eventName, drop, drop.getItemId(), amount);
            LootEventHandler.executeDropCommandOnDrop(drop, player, event.getEntity(), amount);
        }
    }

    private static void executeDropCommandOnDrop(CustomDropEntry drop, Player player, LivingEntity entity, int amount) {
        if (drop.hasDropCommand() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            int cooldownSeconds = 0;
            float dropCommandChance = drop.getDropCommandChance();
            if (dropCommandChance > 0.0f && RANDOM.nextFloat() * 100.0f <= dropCommandChance) {
                LootEventHandler.logDebug("Executing drop command: {}", drop.getDropCommand());
                LootEventHandler.executeCommand(drop.getDropCommand(), serverPlayer, entity);
                if (cooldownSeconds > 0) {
                    LootEventHandler.setCommandCooldown(player, drop.getDropCommand());
                }
            }
        }
    }

    private static void executeCommand(String command, ServerPlayer player, LivingEntity entity) {
        try {
            MinecraftServer server = player.m_20194_();
            if (server == null) {
                return;
            }
            String processedCommand = LootEventHandler.replacePlaceholders(command, player, entity);
            CommandSourceStack commandSource = server.m_129893_().m_81329_((Entity)player).m_81327_((ServerLevel)player.m_9236_()).m_81348_(player.m_20182_()).m_81346_(player.m_20155_()).m_81325_(2);
            server.m_129892_().m_230957_(commandSource, processedCommand);
        }
        catch (Exception e) {
            LOGGER.error("Error executing command '{}': {}", (Object)command, (Object)e.getMessage());
        }
    }

    private static int calculateAmount(int min, int max) {
        if (max <= min) {
            return min;
        }
        return min + RANDOM.nextInt(max - min + 1);
    }

    private static ItemStack createItemStack(CustomDropEntry drop, int amount) {
        try {
            ResourceLocation itemId = new ResourceLocation(drop.getItemId());
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (item == null) {
                LOGGER.warn("Unknown item: {}", (Object)drop.getItemId());
                return null;
            }
            ItemStack stack = new ItemStack((ItemLike)item, amount);
            if (drop.getNbtData() != null && !drop.getNbtData().isEmpty()) {
                try {
                    CompoundTag nbt = TagParser.m_129359_((String)drop.getNbtData());
                    stack.m_41751_(nbt);
                }
                catch (CommandSyntaxException e) {
                    LOGGER.error("Invalid NBT for item {}: {}", (Object)drop.getItemId(), (Object)e.getMessage());
                }
            }
            return stack;
        }
        catch (Exception e) {
            LOGGER.error("Error creating item stack for {}: {}", (Object)drop.getItemId(), (Object)e.getMessage());
            return null;
        }
    }

    private static boolean checkDropRequirements(CustomDropEntry drop, Player player, boolean playerKilled) {
        if (drop.isRequirePlayerKill() && !playerKilled) {
            return false;
        }
        if (!drop.isRequirePlayerKill() && player == null) {
            return true;
        }
        return LootEventHandler.checkDropRequirements(drop, player);
    }

    private static boolean checkDropRequirements(CustomDropEntry drop, Player player) {
        if (player == null) {
            return false;
        }
        if (drop.getRequiredAdvancement() != null && !drop.getRequiredAdvancement().isEmpty() && !LootEventHandler.hasAdvancement(player, drop.getRequiredAdvancement())) {
            return false;
        }
        if (drop.getRequiredEffect() != null && !drop.getRequiredEffect().isEmpty() && !LootEventHandler.hasEffect(player, drop.getRequiredEffect())) {
            return false;
        }
        if (drop.getRequiredEquipment() != null && !drop.getRequiredEquipment().isEmpty() && !LootEventHandler.hasEquipment(player, drop.getRequiredEquipment())) {
            return false;
        }
        if (drop.getRequiredWeather() != null && !drop.getRequiredWeather().isEmpty() && !LootEventHandler.checkWeather(player, drop.getRequiredWeather())) {
            return false;
        }
        if (drop.getRequiredTime() != null && !drop.getRequiredTime().isEmpty() && !LootEventHandler.checkTime(player, drop.getRequiredTime())) {
            return false;
        }
        if (drop.getRequiredDimension() != null && !drop.getRequiredDimension().isEmpty() && !LootEventHandler.checkDimension(player, drop.getRequiredDimension())) {
            return false;
        }
        return drop.getRequiredBiome() == null || drop.getRequiredBiome().isEmpty() || LootEventHandler.checkBiome(player, drop.getRequiredBiome());
    }

    private static boolean hasAdvancement(Player player, String advancementId) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ResourceLocation advancementLocation = new ResourceLocation(advancementId);
        Advancement advancement = serverPlayer.m_20194_().m_129889_().m_136041_(advancementLocation);
        return advancement != null && serverPlayer.m_8960_().m_135996_(advancement).m_8193_();
    }

    private static boolean hasEffect(Player player, String effectId) {
        ResourceLocation effectLocation = new ResourceLocation(effectId);
        Holder effectHolder = ForgeRegistries.MOB_EFFECTS.getHolder(effectLocation).orElse(null);
        return effectHolder != null && player.m_21023_((MobEffect)effectHolder.m_203334_());
    }

    private static boolean hasEquipment(Player player, String equipmentId) {
        ResourceLocation itemLocation = new ResourceLocation(equipmentId);
        Item requiredItem = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
        if (requiredItem == null) {
            return false;
        }
        if (player.m_21205_().m_41720_() == requiredItem) {
            return true;
        }
        if (player.m_21206_().m_41720_() == requiredItem) {
            return true;
        }
        for (ItemStack armorStack : player.m_6168_()) {
            if (armorStack.m_41720_() != requiredItem) continue;
            return true;
        }
        return false;
    }

    private static boolean checkWeather(Player player, String weatherCondition) {
        if (player.m_9236_().f_46443_) {
            return false;
        }
        switch (weatherCondition.toLowerCase()) {
            case "clear": {
                return !player.m_9236_().m_46471_() && !player.m_9236_().m_46470_();
            }
            case "rain": {
                return player.m_9236_().m_46471_() && !player.m_9236_().m_46470_();
            }
            case "thunder": {
                return player.m_9236_().m_46470_();
            }
        }
        return false;
    }

    private static boolean checkTime(Player player, String timeRequirement) {
        long time = player.m_9236_().m_46468_() % 24000L;
        switch (timeRequirement.toLowerCase()) {
            case "day": {
                return time >= 0L && time < 12000L;
            }
            case "night": {
                return time >= 12000L && time < 24000L;
            }
            case "dawn": {
                return time >= 23000L || time < 1000L;
            }
            case "dusk": {
                return time >= 11000L && time < 13000L;
            }
        }
        return false;
    }

    private static boolean checkDimension(Player player, String dimensionId) {
        ResourceLocation currentDimension = player.m_9236_().m_46472_().m_135782_();
        ResourceLocation requiredDimension = new ResourceLocation(dimensionId);
        return currentDimension.equals((Object)requiredDimension);
    }

    private static boolean checkBiome(Player player, String biomeId) {
        ResourceLocation requiredBiome = new ResourceLocation(biomeId);
        Holder currentBiome = player.m_9236_().m_204166_(player.m_20183_());
        return currentBiome.m_203373_(requiredBiome);
    }

    private static String replacePlaceholders(String command, ServerPlayer player, LivingEntity entity) {
        String result = command;
        result = result.replace("{player}", player.m_7755_().getString());
        result = result.replace("{player_x}", String.valueOf((int)player.m_20185_()));
        result = result.replace("{player_y}", String.valueOf((int)player.m_20186_()));
        result = result.replace("{player_z}", String.valueOf((int)player.m_20189_()));
        result = result.replace("{player_uuid}", player.m_20148_().toString());
        result = result.replace("{entity_x}", String.valueOf((int)entity.m_20185_()));
        result = result.replace("{entity_y}", String.valueOf((int)entity.m_20186_()));
        result = result.replace("{entity_z}", String.valueOf((int)entity.m_20189_()));
        result = result.replace("{entity_type}", ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_()).toString());
        result = result.replace("{entity_uuid}", entity.m_20148_().toString());
        result = result.replace("@killer", player.m_7755_().getString());
        result = result.replace("@player", player.m_7755_().getString());
        return result;
    }

    private static void recordDropCountEnabledItems(Player player, String eventKey, CustomDropEntry entry, String itemId, int actualAmount) {
        if (player == null || !entry.isEnableDropCount()) {
            return;
        }
        if ("Normal".equals(eventKey)) {
            return;
        }
        try {
            EventDropCountManager.recordEventDrop(eventKey, player, itemId, actualAmount);
            LootEventHandler.logDebug("Recorded drop count for event {}: player={}, item={}, amount={}", eventKey, player.m_7755_().getString(), itemId, actualAmount);
        }
        catch (Exception e) {
            LOGGER.error("Failed to record drop count for event: " + eventKey, (Throwable)e);
        }
    }
}

