/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops.lootdrops.events;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventDropCountManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CONFIG_DIR = "config/EntityLootDrops";
    private static final String LOOT_DROPS_DIR = "Loot Drops";
    private static final String EVENT_DROPS_DIR = "Event Drops";
    private static final String DROP_COUNT_FILE = "Drop_Count.json";

    public static void recordEventDrop(String eventName, Player player, String itemId, int amount) {
        if (player == null || eventName == null || itemId == null) {
            return;
        }
        try {
            Path eventDir = Paths.get(CONFIG_DIR, LOOT_DROPS_DIR, EVENT_DROPS_DIR, eventName);
            Path dropCountFile = eventDir.resolve(DROP_COUNT_FILE);
            Map<String, EventPlayerDropCount> playerData = EventDropCountManager.loadEventDropData(dropCountFile);
            String playerId = player.m_20148_().toString();
            EventPlayerDropCount playerDropCount = playerData.computeIfAbsent(playerId, k -> new EventPlayerDropCount(player.m_7755_().getString()));
            playerDropCount.setPlayerName(player.m_7755_().getString());
            playerDropCount.addDrop(itemId, amount);
            EventDropCountManager.saveEventDropData(dropCountFile, playerData);
            LOGGER.debug("Recorded event drop for {}: {} x{} in event {}", (Object)player.m_7755_().getString(), (Object)itemId, (Object)amount, (Object)eventName);
        }
        catch (Exception e) {
            LOGGER.error("Failed to record event drop for event: " + eventName, (Throwable)e);
        }
    }

    public static List<EventPlayerDropCount> getEventTopPlayers(String eventName, int count) {
        Path dropCountFile = EventDropCountManager.getEventDropCountFile(eventName);
        Map<String, EventPlayerDropCount> playerData = EventDropCountManager.loadEventDropData(dropCountFile);
        return playerData.values().stream().sorted((a, b) -> Integer.compare(b.getTotalEventDrops(), a.getTotalEventDrops())).limit(count).collect(Collectors.toList());
    }

    public static List<CombinedPlayerDropCount> getCombinedTopPlayers(int count) {
        HashMap combinedTotals = new HashMap();
        try {
            Path eventsDir = Paths.get(CONFIG_DIR, LOOT_DROPS_DIR, EVENT_DROPS_DIR);
            if (!Files.exists(eventsDir, new LinkOption[0])) {
                return new ArrayList<CombinedPlayerDropCount>();
            }
            Files.list(eventsDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(eventDir -> {
                String eventName = eventDir.getFileName().toString();
                Path dropCountFile = eventDir.resolve(DROP_COUNT_FILE);
                if (Files.exists(dropCountFile, new LinkOption[0])) {
                    Map<String, EventPlayerDropCount> eventData = EventDropCountManager.loadEventDropData(dropCountFile);
                    eventData.values().forEach(playerCount -> {
                        String playerName = playerCount.getPlayerName();
                        CombinedPlayerDropCount combined = combinedTotals.computeIfAbsent(playerName, CombinedPlayerDropCount::new);
                        combined.addEventDrops(eventName, playerCount.getTotalEventDrops());
                    });
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to get combined top players", (Throwable)e);
        }
        return combinedTotals.values().stream().sorted((a, b) -> Integer.compare(b.getTotalDrops(), a.getTotalDrops())).limit(count).collect(Collectors.toList());
    }

    public static EventPlayerDropCount getPlayerEventDropCount(String eventName, String playerName) {
        Path dropCountFile = EventDropCountManager.getEventDropCountFile(eventName);
        Map<String, EventPlayerDropCount> playerData = EventDropCountManager.loadEventDropData(dropCountFile);
        return playerData.values().stream().filter(count -> count.getPlayerName().equals(playerName)).findFirst().orElse(null);
    }

    public static List<String> getEventsWithDropCounts() {
        ArrayList<String> events = new ArrayList<String>();
        try {
            Path eventsDir = Paths.get(CONFIG_DIR, LOOT_DROPS_DIR, EVENT_DROPS_DIR);
            if (!Files.exists(eventsDir, new LinkOption[0])) {
                return events;
            }
            Files.list(eventsDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(eventDir -> {
                Path dropCountFile = eventDir.resolve(DROP_COUNT_FILE);
                if (Files.exists(dropCountFile, new LinkOption[0])) {
                    events.add(eventDir.getFileName().toString());
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to get events with drop counts", (Throwable)e);
        }
        return events;
    }

    private static Path getEventDropCountFile(String eventName) {
        Path eventDir = Paths.get(CONFIG_DIR, LOOT_DROPS_DIR, EVENT_DROPS_DIR, eventName);
        return eventDir.resolve(DROP_COUNT_FILE);
    }

    private static Map<String, EventPlayerDropCount> loadEventDropData(Path dropCountFile) {
        HashMap<String, EventPlayerDropCount> playerData = new HashMap<String, EventPlayerDropCount>();
        try {
            if (!Files.exists(dropCountFile, new LinkOption[0])) {
                return playerData;
            }
            String json = Files.readString(dropCountFile);
            if (json.trim().isEmpty()) {
                return playerData;
            }
            Gson gson = new Gson();
            Type mapType = new TypeToken<Map<String, Object>>(){}.getType();
            Map data = (Map)gson.fromJson(json, mapType);
            if (data.containsKey("playerDropCounts")) {
                Type playerCountsType = new TypeToken<Map<String, EventPlayerDropCount>>(){}.getType();
                Map counts = (Map)gson.fromJson(gson.toJson(data.get("playerDropCounts")), playerCountsType);
                if (counts != null) {
                    playerData.putAll(counts);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load event drop data from: " + String.valueOf(dropCountFile), (Throwable)e);
        }
        return playerData;
    }

    private static void saveEventDropData(Path dropCountFile, Map<String, EventPlayerDropCount> playerData) {
        try {
            Files.createDirectories(dropCountFile.getParent(), new FileAttribute[0]);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("eventName", dropCountFile.getParent().getFileName().toString());
            data.put("playerDropCounts", playerData);
            data.put("lastUpdated", System.currentTimeMillis());
            data.put("comment", "Tracks custom item drops per player for this specific event. Only items with enableDropCount=true are tracked.");
            HashMap<String, Integer> itemTotals = new HashMap<String, Integer>();
            int totalPlayers = playerData.size();
            int totalDrops = 0;
            for (EventPlayerDropCount playerCount : playerData.values()) {
                totalDrops += playerCount.getTotalEventDrops();
                for (Map.Entry<String, Integer> itemEntry : playerCount.getItemCounts().entrySet()) {
                    itemTotals.put(itemEntry.getKey(), itemTotals.getOrDefault(itemEntry.getKey(), 0) + itemEntry.getValue());
                }
            }
            data.put("summary", Map.of("totalPlayers", totalPlayers, "totalDrops", totalDrops, "itemTotals", itemTotals));
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            Files.writeString(dropCountFile, (CharSequence)gson.toJson(data), new OpenOption[0]);
        }
        catch (Exception e) {
            LOGGER.error("Failed to save event drop data to: " + String.valueOf(dropCountFile), (Throwable)e);
        }
    }

    public static void resetEventDropCounts(String eventName) {
        try {
            Path eventDir = Paths.get(CONFIG_DIR, LOOT_DROPS_DIR, EVENT_DROPS_DIR, eventName);
            Path dropCountFile = eventDir.resolve(DROP_COUNT_FILE);
            if (Files.exists(dropCountFile, new LinkOption[0])) {
                Files.delete(dropCountFile);
                LOGGER.info("Reset drop counts for event: {}", (Object)eventName);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to reset drop counts for event: " + eventName, (Throwable)e);
        }
    }

    public static void resetAllEventDropCounts() {
        try {
            Path eventsDir = Paths.get(CONFIG_DIR, LOOT_DROPS_DIR, EVENT_DROPS_DIR);
            if (!Files.exists(eventsDir, new LinkOption[0])) {
                return;
            }
            Files.list(eventsDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(eventDir -> {
                Path dropCountFile = eventDir.resolve(DROP_COUNT_FILE);
                if (Files.exists(dropCountFile, new LinkOption[0])) {
                    try {
                        Files.delete(dropCountFile);
                        LOGGER.info("Reset drop counts for event: {}", (Object)eventDir.getFileName());
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to reset drop counts for event: " + String.valueOf(eventDir.getFileName()), (Throwable)e);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Failed to reset all event drop counts", (Throwable)e);
        }
    }

    public static class EventPlayerDropCount {
        private String playerName;
        private Map<String, Integer> itemCounts = new HashMap<String, Integer>();
        private int totalEventDrops = 0;
        private long lastUpdated = System.currentTimeMillis();

        public EventPlayerDropCount() {
        }

        public EventPlayerDropCount(String playerName) {
            this.playerName = playerName;
        }

        public void addDrop(String itemId, int amount) {
            this.itemCounts.put(itemId, this.itemCounts.getOrDefault(itemId, 0) + amount);
            this.totalEventDrops += amount;
            this.lastUpdated = System.currentTimeMillis();
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public void setPlayerName(String playerName) {
            this.playerName = playerName;
        }

        public Map<String, Integer> getItemCounts() {
            return this.itemCounts;
        }

        public void setItemCounts(Map<String, Integer> itemCounts) {
            this.itemCounts = itemCounts;
        }

        public int getTotalEventDrops() {
            return this.totalEventDrops;
        }

        public void setTotalEventDrops(int totalEventDrops) {
            this.totalEventDrops = totalEventDrops;
        }

        public long getLastUpdated() {
            return this.lastUpdated;
        }

        public void setLastUpdated(long lastUpdated) {
            this.lastUpdated = lastUpdated;
        }
    }

    public static class CombinedPlayerDropCount {
        private String playerName;
        private int totalDrops = 0;
        private Map<String, Integer> eventTotals = new HashMap<String, Integer>();

        public CombinedPlayerDropCount(String playerName) {
            this.playerName = playerName;
        }

        public void addEventDrops(String eventName, int drops) {
            this.eventTotals.put(eventName, drops);
            this.totalDrops += drops;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public int getTotalDrops() {
            return this.totalDrops;
        }

        public Map<String, Integer> getEventTotals() {
            return this.eventTotals;
        }
    }
}

