/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops.lootdrops.config;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.poe.entitylootdrops.lootdrops.model.CustomDropEntry;
import net.poe.entitylootdrops.lootdrops.model.EntityDropEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootConfigManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CONFIG_DIR = "config/EntityLootDrops";
    private static final String LOOT_DROPS_DIR = "Loot Drops";
    private static final String NORMAL_DROPS_DIR = "Normal Drops";
    private static final String EVENT_DROPS_DIR = "Event Drops";
    private Map<String, List<EntityDropEntry>> entityDrops = new HashMap<String, List<EntityDropEntry>>();
    private Map<String, List<CustomDropEntry>> hostileDrops = new HashMap<String, List<CustomDropEntry>>();
    private Map<String, String> customMessages = new HashMap<String, String>();

    public void clearConfigurations() {
        this.entityDrops.clear();
        this.hostileDrops.clear();
        this.customMessages.clear();
    }

    public void setEntityDrops(String dirKey, List<EntityDropEntry> drops) {
        if (drops != null && !drops.isEmpty()) {
            this.entityDrops.put(dirKey, drops);
        }
    }

    public void setHostileDrops(String dirKey, List<CustomDropEntry> drops) {
        if (drops != null && !drops.isEmpty()) {
            this.hostileDrops.put(dirKey, drops);
        }
    }

    public void setCustomMessages(Map<String, String> messages) {
        if (messages != null) {
            this.customMessages.clear();
            this.customMessages.putAll(messages);
        }
    }

    public Map<String, String> getCustomMessages() {
        return new HashMap<String, String>(this.customMessages);
    }

    public String getCustomMessage(String key) {
        return this.customMessages.get(key);
    }

    public List<EntityDropEntry> getNormalDrops() {
        return this.entityDrops.getOrDefault(NORMAL_DROPS_DIR, Collections.emptyList());
    }

    public List<CustomDropEntry> getNormalHostileDrops() {
        return this.hostileDrops.getOrDefault(NORMAL_DROPS_DIR, Collections.emptyList());
    }

    public Map<String, List<EntityDropEntry>> getEventDrops() {
        return this.entityDrops.entrySet().stream().filter(e -> !((String)e.getKey()).equals(NORMAL_DROPS_DIR)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public List<CustomDropEntry> getEventHostileDrops(String eventName) {
        return this.hostileDrops.getOrDefault(eventName, Collections.emptyList());
    }

    public List<EntityDropEntry> getEventEntityDrops(String eventName) {
        return this.entityDrops.getOrDefault(eventName, Collections.emptyList());
    }

    public Set<String> getAllEventNames() {
        HashSet<String> eventNames = new HashSet<String>();
        eventNames.addAll(this.getEventDrops().keySet());
        try {
            Path eventsDir = Paths.get(CONFIG_DIR, LOOT_DROPS_DIR, EVENT_DROPS_DIR);
            if (Files.exists(eventsDir, new LinkOption[0]) && Files.isDirectory(eventsDir, new LinkOption[0])) {
                try {
                    Files.list(eventsDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(eventDir -> eventNames.add(eventDir.getFileName().toString()));
                }
                catch (IOException e) {
                    LOGGER.warn("Failed to list event directories: {}", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to get event names from directories", (Throwable)e);
        }
        return eventNames;
    }

    public Set<String> getAvailableEvents() {
        return this.getAllEventNames();
    }

    public int getEntityDropsCount() {
        return this.entityDrops.values().stream().mapToInt(List::size).sum();
    }

    public int getHostileDropsCount() {
        return this.hostileDrops.values().stream().mapToInt(List::size).sum();
    }
}

