/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops.lootdrops.config;

import com.google.gson.Gson;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EventConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CONFIG_DIR = "config/EntityLootDrops";
    private static final String EVENT_CONFIG_FILE = "EventConfig.json";
    private static EventConfigData config = new EventConfigData();

    public static void loadConfig() {
        Path configDir = Paths.get(CONFIG_DIR, new String[0]);
        Path configFile = configDir.resolve(EVENT_CONFIG_FILE);
        try {
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
                LOGGER.info("Created config directory: {}", (Object)configDir);
            }
            if (!Files.exists(configFile, new LinkOption[0])) {
                EventConfig.createDefaultConfig(configFile);
                LOGGER.info("Created default event configuration: {}", (Object)configFile);
            } else {
                Gson gson = new Gson();
                String json = Files.readString(configFile);
                config = (EventConfigData)gson.fromJson(json, EventConfigData.class);
                if (config == null) {
                    LOGGER.warn("Failed to parse event configuration, creating new default");
                    config = new EventConfigData();
                    EventConfig.createDefaultConfig(configFile);
                } else {
                    LOGGER.info("Loaded event configuration from: {}", (Object)configFile);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load event configuration, using defaults", (Throwable)e);
            config = new EventConfigData();
            try {
                EventConfig.createDefaultConfig(configFile);
            }
            catch (IOException ioException) {
                LOGGER.error("Failed to create default event configuration", (Throwable)ioException);
            }
        }
    }

    private static void createDefaultConfig(Path configFile) throws IOException {
        Files.createDirectories(configFile.getParent(), new FileAttribute[0]);
        String enhancedJson = "{\n  \"comment\": \"Event configuration for EntityLootDrops mod\",\n  \"enableDropChanceEvent\": true,\n  \"enableDoubleDropsEvent\": true,\n  \"affectVanillaDrops\": true,\n  \"affectModdedDrops\": true,\n  \"dropChanceMultiplier\": 0.5,\n  \"doubleDropChanceMultiplier\": 2.0,\n  \"allowedMods\": [\n    \"minecraft\",\n    \"mmorpg\",\n    \"age_of_exile\",\n    \"mine_and_slash\",\n    \"dungeons_gear\",\n    \"reliquary\"\n  ],\n  \"blockedMods\": [\n    \"create\",\n    \"immersiveengineering\"\n  ]\n}\n";
        Files.writeString(configFile, (CharSequence)enhancedJson, new OpenOption[0]);
        LOGGER.info("Created EventConfig.json with comprehensive documentation");
    }

    public static boolean isDropChanceEventEnabled() {
        return config.isEnableDropChanceEvent();
    }

    public static boolean isDoubleDropsEventEnabled() {
        return config.isEnableDoubleDropsEvent();
    }

    public static boolean shouldAffectMod(String modId) {
        if ("minecraft".equals(modId) && !config.isAffectVanillaDrops()) {
            return false;
        }
        if (!"minecraft".equals(modId) && !config.isAffectModdedDrops()) {
            return false;
        }
        if (config.getBlockedMods().contains(modId)) {
            return false;
        }
        if (config.getAllowedMods().isEmpty()) {
            return true;
        }
        return config.getAllowedMods().contains(modId);
    }

    public static double getDropChanceMultiplier() {
        return config.getDropChanceMultiplier();
    }

    public static double getDoubleDropChanceMultiplier() {
        return config.getDoubleDropChanceMultiplier();
    }

    public static EventConfigData getConfig() {
        return config;
    }

    public static boolean isModAllowedForDropEvents(String modId) {
        return EventConfig.shouldAffectMod(modId);
    }

    public static class EventConfigData {
        private boolean enableDropChanceEvent = true;
        private boolean enableDoubleDropsEvent = true;
        private boolean affectVanillaDrops = true;
        private boolean affectModdedDrops = true;
        private List<String> allowedMods = new ArrayList<String>();
        private List<String> blockedMods = new ArrayList<String>();
        private double dropChanceMultiplier = 0.5;
        private double doubleDropChanceMultiplier = 2.0;
        private String comment = "Event configuration for EntityLootDrops mod";

        public EventConfigData() {
            this.allowedMods.add("minecraft");
            this.allowedMods.add("mmorpg");
            this.allowedMods.add("age_of_exile");
            this.allowedMods.add("mine_and_slash");
            this.allowedMods.add("dungeons_gear");
            this.allowedMods.add("reliquary");
            this.blockedMods.add("create");
            this.blockedMods.add("immersiveengineering");
        }

        public boolean isEnableDropChanceEvent() {
            return this.enableDropChanceEvent;
        }

        public void setEnableDropChanceEvent(boolean enableDropChanceEvent) {
            this.enableDropChanceEvent = enableDropChanceEvent;
        }

        public boolean isEnableDoubleDropsEvent() {
            return this.enableDoubleDropsEvent;
        }

        public void setEnableDoubleDropsEvent(boolean enableDoubleDropsEvent) {
            this.enableDoubleDropsEvent = enableDoubleDropsEvent;
        }

        public boolean isAffectVanillaDrops() {
            return this.affectVanillaDrops;
        }

        public void setAffectVanillaDrops(boolean affectVanillaDrops) {
            this.affectVanillaDrops = affectVanillaDrops;
        }

        public boolean isAffectModdedDrops() {
            return this.affectModdedDrops;
        }

        public void setAffectModdedDrops(boolean affectModdedDrops) {
            this.affectModdedDrops = affectModdedDrops;
        }

        public List<String> getAllowedMods() {
            return this.allowedMods;
        }

        public void setAllowedMods(List<String> allowedMods) {
            this.allowedMods = allowedMods;
        }

        public List<String> getBlockedMods() {
            return this.blockedMods;
        }

        public void setBlockedMods(List<String> blockedMods) {
            this.blockedMods = blockedMods;
        }

        public double getDropChanceMultiplier() {
            return this.dropChanceMultiplier;
        }

        public void setDropChanceMultiplier(double dropChanceMultiplier) {
            this.dropChanceMultiplier = dropChanceMultiplier;
        }

        public double getDoubleDropChanceMultiplier() {
            return this.doubleDropChanceMultiplier;
        }

        public void setDoubleDropChanceMultiplier(double doubleDropChanceMultiplier) {
            this.doubleDropChanceMultiplier = doubleDropChanceMultiplier;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }
    }
}

