/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops.lootdrops;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;
import net.poe.entitylootdrops.lootdrops.config.LootConfigLoader;
import net.poe.entitylootdrops.lootdrops.config.LootConfigManager;
import net.poe.entitylootdrops.lootdrops.events.LootEventManager;
import net.poe.entitylootdrops.lootdrops.model.CustomDropEntry;
import net.poe.entitylootdrops.lootdrops.model.EntityDropEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    private static LootConfigManager configManager = new LootConfigManager();
    private static LootEventManager eventManager = new LootEventManager();
    private static LootConfigLoader configLoader = new LootConfigLoader(configManager, eventManager);

    public static void loadConfig() {
        configLoader.loadConfig();
        LOGGER.info("Reloaded configuration: {} entity drop types, {} hostile drop types, {} active events", (Object)configManager.getEntityDropsCount(), (Object)configManager.getHostileDropsCount(), (Object)eventManager.getActiveEventsCount());
    }

    public static List<EntityDropEntry> getNormalDrops() {
        return configManager.getNormalDrops();
    }

    public static List<CustomDropEntry> getNormalHostileDrops() {
        return configManager.getNormalHostileDrops();
    }

    public static Map<String, List<EntityDropEntry>> getEventDrops() {
        return configManager.getEventDrops();
    }

    public static List<CustomDropEntry> getEventHostileDrops(String eventName) {
        return configManager.getEventHostileDrops(eventName);
    }

    public static boolean isEventActive(String eventName) {
        return eventManager.isEventActive(eventName);
    }

    public static void toggleEvent(String eventName, boolean active) {
        eventManager.toggleEvent(eventName, active, configManager.getAvailableEvents());
    }

    public static void toggleDropChanceEvent(boolean active) {
        eventManager.toggleDropChanceEvent(active);
    }

    public static void toggleDoubleDrops(boolean active) {
        eventManager.toggleDoubleDrops(active);
    }

    public static void clearActiveEvents() {
        eventManager.clearActiveEvents();
    }

    public static Set<String> getActiveEvents() {
        return eventManager.getActiveEvents();
    }

    public static Set<String> getAllEventNames() {
        return configManager.getAllEventNames();
    }

    public static boolean isDropChanceEventActive() {
        return eventManager.isDropChanceEventActive();
    }

    public static boolean isDoubleDropsActive() {
        return eventManager.isDoubleDropsActive();
    }

    public static boolean isDebugLoggingEnabled() {
        return eventManager.isDebugLoggingEnabled();
    }

    public static void setDebugLogging(boolean enabled) {
        eventManager.setDebugLogging(enabled);
    }

    public static void saveActiveEventsState() {
        eventManager.saveActiveEventsState();
    }

    public static void setEventEnableMessage(String eventName, String message) {
        eventManager.setEventEnableMessage(eventName, message);
    }

    public static void setEventDisableMessage(String eventName, String message) {
        eventManager.setEventDisableMessage(eventName, message);
    }

    public static String getEventEnableMessage(String eventName) {
        return eventManager.getEventEnableMessage(eventName);
    }

    public static String getEventDisableMessage(String eventName) {
        return eventManager.getEventDisableMessage(eventName);
    }

    public static void setDropChanceEnableMessage(String message) {
        eventManager.setDropChanceEnableMessage(message);
    }

    public static void setDropChanceDisableMessage(String message) {
        eventManager.setDropChanceDisableMessage(message);
    }

    public static String getDropChanceEnableMessage() {
        return eventManager.getDropChanceEnableMessage();
    }

    public static String getDropChanceDisableMessage() {
        return eventManager.getDropChanceDisableMessage();
    }

    public static void setDoubleDropsEnableMessage(String message) {
        eventManager.setDoubleDropsEnableMessage(message);
    }

    public static void setDoubleDropsDisableMessage(String message) {
        eventManager.setDoubleDropsDisableMessage(message);
    }

    public static String getDoubleDropsEnableMessage() {
        return eventManager.getDoubleDropsEnableMessage();
    }

    public static String getDoubleDropsDisableMessage() {
        return eventManager.getDoubleDropsDisableMessage();
    }

    public static void enableDropCount(boolean enabled) {
        eventManager.enableDropCount(enabled);
    }

    public static boolean isDropCountEnabled() {
        return eventManager.isDropCountEnabled();
    }

    public static void recordDrop(Player player, String itemId, int amount) {
        eventManager.recordDrop(player, itemId, amount);
    }

    public static Optional<LootEventManager.PlayerDropCount> getPlayerDropCount(UUID playerId) {
        return eventManager.getPlayerDropCount(playerId);
    }

    public static Optional<LootEventManager.PlayerDropCount> getPlayerDropCount(String playerName) {
        return eventManager.getPlayerDropCount(playerName);
    }

    public static List<Map.Entry<UUID, LootEventManager.PlayerDropCount>> getTopDropCounts() {
        return eventManager.getTopDropCounts();
    }

    public static void resetDropCounts() {
        eventManager.resetDropCounts();
    }

    public static void saveDropCountData() {
        eventManager.saveDropCountData();
    }

    public static void loadDropCountData() {
        eventManager.loadDropCountData();
    }
}

