/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.fml.ModLoadingContext;
import net.poe.entitylootdrops.lootdrops.LootConfig;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends Screen {
    private final Screen parentScreen;
    private Button reloadButton;
    private String currentDirectory = "config/EntityLootDrops";
    private List<String> fileList = new ArrayList<String>();
    private int fileScrollOffset = 0;
    private static final int FILES_PER_PAGE = 8;
    private UIState currentState = UIState.MAIN_MENU;
    private String currentFile = null;
    private MultilineEditBox fileContentBox;
    private EditBox fileNameBox;
    private String errorMessage = null;
    private static final ResourceLocation LOGO = new ResourceLocation("entitylootdrops", "textures/logo.png");

    public ConfigScreen(Screen parentScreen) {
        super((Component)Component.m_237113_((String)"Entity Loot Drops Configuration"));
        this.parentScreen = parentScreen;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        if (!this.hasEditPermission() && this.currentState == UIState.CREATE_FILE) {
            this.currentState = UIState.FILE_BROWSER;
            this.errorMessage = "You don't have permission to create files. Required permission level: 2";
        }
        switch (this.currentState) {
            case MAIN_MENU: {
                this.initMainMenu();
                break;
            }
            case FILE_BROWSER: {
                this.initFileBrowser();
                break;
            }
            case FILE_EDITOR: {
                this.initFileEditor();
                break;
            }
            case CREATE_FILE: {
                this.initCreateFile();
            }
        }
    }

    private boolean hasEditPermission() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.m_257720_()) {
            return true;
        }
        return minecraft.f_91074_ != null && minecraft.f_91074_.m_20310_(2);
    }

    private void initMainMenu() {
        int y = 50;
        boolean canEdit = this.hasEditPermission();
        Button fileBrowserButton = Button.m_253074_((Component)Component.m_237113_((String)"Browse Configuration Files"), btn -> {
            this.currentState = UIState.FILE_BROWSER;
            this.loadFileList();
            this.m_7856_();
        }).m_252794_(this.f_96543_ / 2 - 100, y += 10).m_253046_(200, 20).m_253136_();
        this.m_142416_((GuiEventListener)fileBrowserButton);
        this.reloadButton = Button.m_253074_((Component)Component.m_237113_((String)"Reload Configuration"), btn -> {
            LootConfig.loadConfig();
            Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen(this.parentScreen));
        }).m_252794_(this.f_96543_ / 2 - 100, y += 24).m_253046_(200, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.reloadButton);
        Button doneButton = Button.m_253074_((Component)Component.m_237113_((String)"Done"), btn -> Minecraft.m_91087_().m_91152_(this.parentScreen)).m_252794_(this.f_96543_ / 2 - 100, y += 24).m_253046_(200, 20).m_253136_();
        this.m_142416_((GuiEventListener)doneButton);
        if (!canEdit) {
            this.errorMessage = "View-only mode. You need permission level 2 to make changes.";
        }
    }

    private void initFileBrowser() {
        Button backButton = Button.m_253074_((Component)Component.m_237113_((String)"Back to Main Menu"), btn -> {
            this.currentState = UIState.MAIN_MENU;
            this.m_7856_();
        }).m_252794_(10, 10).m_253046_(120, 20).m_253136_();
        this.m_142416_((GuiEventListener)backButton);
        if (!this.currentDirectory.equals("config/EntityLootDrops")) {
            Button parentDirButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2191 Parent Directory"), btn -> {
                Path current = Paths.get(this.currentDirectory, new String[0]);
                Path parent = current.getParent();
                if (parent != null && parent.toString().contains("EntityLootDrops")) {
                    this.currentDirectory = parent.toString();
                    this.loadFileList();
                    this.m_7856_();
                }
            }).m_252794_(140, 10).m_253046_(120, 20).m_253136_();
            this.m_142416_((GuiEventListener)parentDirButton);
        }
        if (this.hasEditPermission()) {
            Button createFileButton = Button.m_253074_((Component)Component.m_237113_((String)"Create New File"), btn -> {
                this.currentState = UIState.CREATE_FILE;
                this.m_7856_();
            }).m_252794_(this.f_96543_ - 130, 10).m_253046_(120, 20).m_253136_();
            this.m_142416_((GuiEventListener)createFileButton);
        }
        int y = 50;
        if (this.fileScrollOffset > 0) {
            Button scrollUpButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2191"), btn -> {
                this.fileScrollOffset = Math.max(0, this.fileScrollOffset - 8);
                this.m_7856_();
            }).m_252794_(this.f_96543_ / 2 - 100, y).m_253046_(200, 20).m_253136_();
            this.m_142416_((GuiEventListener)scrollUpButton);
            y += 24;
        }
        int endIndex = Math.min(this.fileList.size(), this.fileScrollOffset + 8);
        for (int i = this.fileScrollOffset; i < endIndex; ++i) {
            Button fileButton;
            String fileName = this.fileList.get(i);
            Path filePath = Paths.get(this.currentDirectory, fileName);
            if (Files.isDirectory(filePath, new LinkOption[0])) {
                fileButton = Button.m_253074_((Component)Component.m_237113_((String)("[DIR] " + fileName)), btn -> {
                    this.currentDirectory = filePath.toString();
                    this.loadFileList();
                    this.m_7856_();
                }).m_252794_(this.f_96543_ / 2 - 150, y).m_253046_(300, 20).m_253136_();
            } else {
                fileButton = Button.m_253074_((Component)Component.m_237113_((String)("\ud83d\udcc4 " + fileName)), btn -> {
                    this.currentFile = filePath.toString();
                    this.currentState = UIState.FILE_EDITOR;
                    this.m_7856_();
                }).m_252794_(this.f_96543_ / 2 - 150, y).m_253046_(240, 20).m_253136_();
                if (this.hasEditPermission()) {
                    Button deleteButton = Button.m_253074_((Component)Component.m_237113_((String)"[DEL]"), btn -> {
                        try {
                            Files.delete(filePath);
                            this.loadFileList();
                            this.m_7856_();
                        }
                        catch (IOException e) {
                            this.errorMessage = "Failed to delete file: " + e.getMessage();
                        }
                    }).m_252794_(this.f_96543_ / 2 + 100, y).m_253046_(50, 20).m_253136_();
                    deleteButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"Delete file")));
                    this.m_142416_((GuiEventListener)deleteButton);
                }
            }
            this.m_142416_((GuiEventListener)fileButton);
            y += 24;
        }
        if (endIndex < this.fileList.size()) {
            Button scrollDownButton = Button.m_253074_((Component)Component.m_237113_((String)"\u2193"), btn -> {
                this.fileScrollOffset += 8;
                this.m_7856_();
            }).m_252794_(this.f_96543_ / 2 - 100, y).m_253046_(200, 20).m_253136_();
            this.m_142416_((GuiEventListener)scrollDownButton);
        }
    }

    private void initFileEditor() {
        Button backButton = Button.m_253074_((Component)Component.m_237113_((String)"Back to File Browser"), btn -> {
            this.currentState = UIState.FILE_BROWSER;
            this.m_7856_();
        }).m_252794_(10, 10).m_253046_(150, 20).m_253136_();
        this.m_142416_((GuiEventListener)backButton);
        if (this.hasEditPermission()) {
            Button saveButton = Button.m_253074_((Component)Component.m_237113_((String)"Save File"), btn -> {
                try {
                    String content = this.fileContentBox.m_94155_();
                    try {
                        JsonElement jsonElement = JsonParser.parseString((String)content);
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        content = gson.toJson(jsonElement);
                        this.fileContentBox.m_94144_(content);
                    }
                    catch (Exception e) {
                        this.errorMessage = "Warning: Invalid JSON format! File saved as-is.";
                    }
                    Files.write(Paths.get(this.currentFile, new String[0]), content.getBytes(), new OpenOption[0]);
                    this.errorMessage = "File saved successfully!";
                }
                catch (IOException e) {
                    this.errorMessage = "Failed to save file: " + e.getMessage();
                }
            }).m_252794_(this.f_96543_ - 160, 10).m_253046_(150, 20).m_253136_();
            this.m_142416_((GuiEventListener)saveButton);
            Button formatButton = Button.m_253074_((Component)Component.m_237113_((String)"Format JSON"), btn -> {
                try {
                    String content = this.fileContentBox.m_94155_();
                    JsonElement jsonElement = JsonParser.parseString((String)content);
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    content = gson.toJson(jsonElement);
                    this.fileContentBox.m_94144_(content);
                    this.errorMessage = "JSON formatted successfully!";
                }
                catch (Exception e) {
                    this.errorMessage = "Invalid JSON format: " + e.getMessage();
                }
            }).m_252794_(this.f_96543_ - 320, 10).m_253046_(150, 20).m_253136_();
            this.m_142416_((GuiEventListener)formatButton);
        }
        this.fileContentBox = new MultilineEditBox(this.f_96547_, this.f_96543_ / 2 - 200, 50, 400, this.f_96544_ - 100, (Component)Component.m_237113_((String)"File Content"));
        this.fileContentBox.m_94199_(100000);
        this.fileContentBox.m_94186_(this.hasEditPermission());
        try {
            String content = new String(Files.readAllBytes(Paths.get(this.currentFile, new String[0])));
            try {
                JsonElement jsonElement = JsonParser.parseString((String)content);
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                content = gson.toJson(jsonElement);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.fileContentBox.m_94144_(content);
        }
        catch (IOException e) {
            this.fileContentBox.m_94144_("Error loading file: " + e.getMessage());
        }
        this.m_142416_((GuiEventListener)this.fileContentBox);
        if (!this.hasEditPermission()) {
            this.errorMessage = "View-only mode. You need permission level 2 to edit files.";
        }
    }

    private void initCreateFile() {
        Button backButton = Button.m_253074_((Component)Component.m_237113_((String)"Back to File Browser"), btn -> {
            this.currentState = UIState.FILE_BROWSER;
            this.m_7856_();
        }).m_252794_(10, 10).m_253046_(150, 20).m_253136_();
        this.m_142416_((GuiEventListener)backButton);
        this.fileNameBox = new EditBox(this.f_96547_, this.f_96543_ / 2 - 100, 50, 200, 20, (Component)Component.m_237113_((String)"File Name"));
        this.fileNameBox.m_94199_(100);
        this.fileNameBox.m_94186_(true);
        this.fileNameBox.m_94144_("new_file.json");
        this.m_142416_((GuiEventListener)this.fileNameBox);
        this.fileContentBox = new MultilineEditBox(this.f_96547_, this.f_96543_ / 2 - 200, 100, 400, this.f_96544_ - 150, (Component)Component.m_237113_((String)"File Content"));
        this.fileContentBox.m_94199_(100000);
        this.fileContentBox.m_94186_(true);
        this.fileContentBox.m_94144_("{\n  \"_comment\": \"New configuration file\",\n  \"itemId\": \"minecraft:diamond\",\n  \"dropChance\": 10.0,\n  \"minAmount\": 1,\n  \"maxAmount\": 3\n}");
        this.m_142416_((GuiEventListener)this.fileContentBox);
        Button createButton = Button.m_253074_((Component)Component.m_237113_((String)"Create File"), btn -> {
            try {
                Path filePath;
                Object fileName = this.fileNameBox.m_94155_();
                if (!((String)fileName).endsWith(".json")) {
                    fileName = (String)fileName + ".json";
                }
                if (Files.exists(filePath = Paths.get(this.currentDirectory, new String[]{fileName}), new LinkOption[0])) {
                    this.errorMessage = "File already exists!";
                    return;
                }
                String content = this.fileContentBox.m_94155_();
                try {
                    JsonElement jsonElement = JsonParser.parseString((String)content);
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    content = gson.toJson(jsonElement);
                }
                catch (Exception e) {
                    this.errorMessage = "Invalid JSON format!";
                    return;
                }
                Files.write(filePath, content.getBytes(), new OpenOption[0]);
                this.currentState = UIState.FILE_BROWSER;
                this.loadFileList();
                this.m_7856_();
            }
            catch (IOException e) {
                this.errorMessage = "Failed to create file: " + e.getMessage();
            }
        }).m_252794_(this.f_96543_ / 2 - 100, this.f_96544_ - 40).m_253046_(200, 20).m_253136_();
        this.m_142416_((GuiEventListener)createButton);
    }

    private void loadFileList() {
        this.fileList.clear();
        File dir = new File(this.currentDirectory);
        try {
            if (!dir.exists()) {
                dir.mkdirs();
                this.errorMessage = "Created directory: " + this.currentDirectory;
                return;
            }
            if (!dir.isDirectory()) {
                this.errorMessage = "Path is not a directory: " + this.currentDirectory;
                return;
            }
            File[] files = dir.listFiles();
            if (files == null) {
                this.errorMessage = "Cannot read directory: " + this.currentDirectory;
                return;
            }
            Arrays.stream(files).filter(File::isDirectory).filter(file -> !file.getName().startsWith(".")).map(File::getName).sorted().forEach(this.fileList::add);
            Arrays.stream(files).filter(file -> file.isFile()).filter(file -> file.getName().toLowerCase().endsWith(".json")).filter(file -> file.canRead()).map(File::getName).sorted().forEach(this.fileList::add);
        }
        catch (Exception e) {
            this.errorMessage = "Error loading directory: " + e.getMessage();
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
        if (this.currentState == UIState.FILE_BROWSER) {
            guiGraphics.m_280488_(this.f_96547_, "Current Directory: " + this.currentDirectory, this.f_96543_ / 2 - 200, 35, 0xCCCCCC);
        }
        if (this.currentState == UIState.FILE_EDITOR && this.currentFile != null) {
            guiGraphics.m_280488_(this.f_96547_, "Editing: " + this.currentFile, this.f_96543_ / 2 - 200, 35, 0xCCCCCC);
            if (!this.hasEditPermission()) {
                guiGraphics.m_280488_(this.f_96547_, "[READ ONLY]", this.f_96543_ / 2 + 100, 35, 0xFF5555);
            }
        }
        if (this.errorMessage != null) {
            guiGraphics.m_280137_(this.f_96547_, this.errorMessage, this.f_96543_ / 2, this.f_96544_ - 20, 0xFF5555);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6913_() {
        if (this.fileContentBox != null && this.fileContentBox.m_93696_() || this.fileNameBox != null && this.fileNameBox.m_93696_()) {
            return false;
        }
        if (this.currentState != UIState.MAIN_MENU) {
            this.currentState = this.currentState == UIState.FILE_BROWSER ? UIState.MAIN_MENU : UIState.FILE_BROWSER;
            this.f_96541_.m_91152_((Screen)this);
            return false;
        }
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            if (this.fileContentBox != null && this.fileContentBox.m_93696_()) {
                this.fileContentBox.m_93692_(false);
                return true;
            }
            if (this.fileNameBox != null && this.fileNameBox.m_93696_()) {
                this.fileNameBox.m_93692_(false);
                return true;
            }
        }
        if (this.m_7222_() != null && this.m_7222_().m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public static void register() {
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new ConfigScreen((Screen)screen)));
    }

    private static enum UIState {
        MAIN_MENU,
        FILE_BROWSER,
        FILE_EDITOR,
        CREATE_FILE;

    }

    private class MultilineEditBox
    extends EditBox {
        private int scrollOffset;
        private final int lineHeight = 12;
        private List<String> lines;
        private String fullText;
        private boolean editable;
        private Font fontRenderer;
        private int maxLineWidth;
        private int cursorPos;
        private int cursorLine;
        private int cursorColumn;
        private long lastCursorBlink;
        private boolean cursorVisible;

        public MultilineEditBox(Font font, int x, int y, int width, int height, Component message) {
            super(font, x, y, width, height, message);
            this.scrollOffset = 0;
            this.lineHeight = 12;
            this.lines = new ArrayList<String>();
            this.fullText = "";
            this.editable = true;
            this.cursorPos = 0;
            this.cursorLine = 0;
            this.cursorColumn = 0;
            this.lastCursorBlink = 0L;
            this.cursorVisible = true;
            this.fontRenderer = font;
            this.maxLineWidth = width - 10;
            this.lastCursorBlink = System.currentTimeMillis();
        }

        public void m_94144_(String text) {
            super.m_94144_(text);
            this.fullText = text;
            this.cursorPos = text.length();
            this.updateLines();
            this.updateCursorPosition();
        }

        public String m_94155_() {
            return this.fullText;
        }

        public void m_94186_(boolean editable) {
            super.m_94186_(editable);
            this.editable = editable;
        }

        private boolean isEditableCustom() {
            return this.editable;
        }

        private void updateLines() {
            String[] rawLines = this.fullText.split("\n", -1);
            this.lines = new ArrayList<String>();
            for (String rawLine : rawLines) {
                if (rawLine.isEmpty()) {
                    this.lines.add("");
                    continue;
                }
                Object indentation = "";
                for (int i = 0; i < rawLine.length() && Character.isWhitespace(rawLine.charAt(i)); ++i) {
                    indentation = (String)indentation + rawLine.charAt(i);
                }
                Object remaining = rawLine;
                while (!((String)remaining).isEmpty()) {
                    int endIndex = this.findBreakPoint((String)remaining, this.maxLineWidth);
                    if (endIndex == 0) {
                        endIndex = Math.min(((String)remaining).length(), 1);
                    }
                    String part = ((String)remaining).substring(0, endIndex);
                    this.lines.add(part);
                    if (((String)(remaining = ((String)remaining).substring(endIndex))).isEmpty() || ((String)indentation).isEmpty()) continue;
                    remaining = (String)indentation + "  " + (String)remaining;
                }
            }
            this.updateCursorPosition();
        }

        private void updateCursorPosition() {
            int pos = 0;
            this.cursorLine = 0;
            this.cursorColumn = 0;
            for (int i = 0; i < this.lines.size(); ++i) {
                String line = this.lines.get(i);
                if (pos + line.length() >= this.cursorPos) {
                    this.cursorLine = i;
                    this.cursorColumn = this.cursorPos - pos;
                    break;
                }
                pos += line.length();
                if (i >= this.lines.size() - 1) continue;
                ++pos;
            }
            this.ensureCursorVisible();
        }

        private void ensureCursorVisible() {
            int visibleLines = this.f_93619_ / 12;
            if (this.cursorLine < this.scrollOffset) {
                this.scrollOffset = this.cursorLine;
            } else if (this.cursorLine >= this.scrollOffset + visibleLines) {
                this.scrollOffset = this.cursorLine - visibleLines + 1;
            }
        }

        private int findBreakPoint(String text, int maxWidth) {
            if (this.fontRenderer.m_92895_(text) <= maxWidth) {
                return text.length();
            }
            int width = 0;
            int lastSpace = -1;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                int charWidth = this.fontRenderer.m_92895_(String.valueOf(c));
                if (c == ' ' || c == ',' || c == ':' || c == ';') {
                    lastSpace = i;
                }
                if ((width += charWidth) <= maxWidth) continue;
                if (lastSpace != -1) {
                    return lastSpace + 1;
                }
                return i;
            }
            return text.length();
        }

        public boolean m_5534_(char c, int modifiers) {
            if (this.m_94213_() && this.m_93696_() && this.isEditableCustom()) {
                if (c == '\n' || c == '\r') {
                    this.m_94164_("\n");
                } else {
                    this.m_94164_(String.valueOf(c));
                }
                return true;
            }
            return false;
        }

        public void m_94164_(String text) {
            if (this.cursorPos < 0) {
                this.cursorPos = 0;
            }
            if (this.cursorPos > this.fullText.length()) {
                this.cursorPos = this.fullText.length();
            }
            this.fullText = this.fullText.substring(0, this.cursorPos) + text + this.fullText.substring(this.cursorPos);
            this.cursorPos += text.length();
            this.updateLines();
        }

        private void m_94217_(int count) {
            if (this.cursorPos <= 0 || this.fullText.isEmpty()) {
                return;
            }
            int start = Math.max(0, this.cursorPos - count);
            this.fullText = this.fullText.substring(0, start) + this.fullText.substring(this.cursorPos);
            this.cursorPos = start;
            this.updateLines();
        }

        public void m_94188_(int amount) {
            this.cursorPos = Math.max(0, Math.min(this.fullText.length(), this.cursorPos + amount));
            this.updateCursorPosition();
            this.lastCursorBlink = System.currentTimeMillis();
            this.cursorVisible = true;
        }

        private void moveCursorToLineStart() {
            int pos = 0;
            for (int i = 0; i < this.cursorLine; ++i) {
                pos += this.lines.get(i).length();
                if (i >= this.lines.size() - 1) continue;
                ++pos;
            }
            this.cursorPos = pos;
            this.cursorColumn = 0;
            this.lastCursorBlink = System.currentTimeMillis();
            this.cursorVisible = true;
        }

        private void moveCursorToLineEnd() {
            int pos = 0;
            for (int i = 0; i <= this.cursorLine; ++i) {
                pos += this.lines.get(i).length();
                if (i >= this.cursorLine) continue;
                ++pos;
            }
            this.cursorPos = pos;
            this.cursorColumn = this.lines.get(this.cursorLine).length();
            this.lastCursorBlink = System.currentTimeMillis();
            this.cursorVisible = true;
        }

        private void moveCursorVertical(int lineDelta) {
            int targetLine = Math.max(0, Math.min(this.lines.size() - 1, this.cursorLine + lineDelta));
            if (targetLine != this.cursorLine) {
                int startOfCurrentLine = 0;
                for (int i = 0; i < this.cursorLine; ++i) {
                    startOfCurrentLine += this.lines.get(i).length();
                    if (i >= this.lines.size() - 1) continue;
                    ++startOfCurrentLine;
                }
                int startOfTargetLine = 0;
                for (int i = 0; i < targetLine; ++i) {
                    startOfTargetLine += this.lines.get(i).length();
                    if (i >= this.lines.size() - 1) continue;
                    ++startOfTargetLine;
                }
                int targetColumn = Math.min(this.cursorColumn, this.lines.get(targetLine).length());
                this.cursorPos = startOfTargetLine + targetColumn;
                this.cursorLine = targetLine;
                this.cursorColumn = targetColumn;
                this.ensureCursorVisible();
                this.lastCursorBlink = System.currentTimeMillis();
                this.cursorVisible = true;
            }
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.m_94213_() && this.m_93696_()) {
                if (keyCode == 256) {
                    return false;
                }
                if (this.isEditableCustom()) {
                    if (keyCode == 257 || keyCode == 335) {
                        this.m_94164_("\n");
                        return true;
                    }
                    if (keyCode == 259) {
                        this.m_94217_(1);
                        return true;
                    }
                    if (keyCode == 261) {
                        if (this.cursorPos < this.fullText.length()) {
                            this.fullText = this.fullText.substring(0, this.cursorPos) + this.fullText.substring(this.cursorPos + 1);
                            this.updateLines();
                        }
                        return true;
                    }
                    if (keyCode == 258) {
                        this.m_94164_("    ");
                        return true;
                    }
                    if (keyCode == 263) {
                        this.m_94188_(-1);
                        return true;
                    }
                    if (keyCode == 262) {
                        this.m_94188_(1);
                        return true;
                    }
                    if (keyCode == 268) {
                        this.moveCursorToLineStart();
                        return true;
                    }
                    if (keyCode == 269) {
                        this.moveCursorToLineEnd();
                        return true;
                    }
                }
                if (keyCode == 265) {
                    this.moveCursorVertical(-1);
                    return true;
                }
                if (keyCode == 264) {
                    this.moveCursorVertical(1);
                    return true;
                }
                if (keyCode == 266) {
                    int visibleLines = this.f_93619_ / 12;
                    this.scrollOffset = Math.max(0, this.scrollOffset - visibleLines);
                    this.moveCursorVertical(-visibleLines);
                    return true;
                }
                if (keyCode == 267) {
                    int visibleLines = this.f_93619_ / 12;
                    this.scrollOffset = Math.min(Math.max(0, this.lines.size() - visibleLines), this.scrollOffset + visibleLines);
                    this.moveCursorVertical(visibleLines);
                    return true;
                }
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            boolean result = super.m_6375_(mouseX, mouseY, button);
            if (this.m_5953_(mouseX, mouseY)) {
                int clickedLine;
                this.m_93692_(true);
                if (this.isEditableCustom() && (clickedLine = this.scrollOffset + (int)((mouseY - (double)this.m_252907_()) / 12.0)) >= 0 && clickedLine < this.lines.size()) {
                    int startOfLine = 0;
                    for (int i = 0; i < clickedLine; ++i) {
                        startOfLine += this.lines.get(i).length();
                        if (i >= this.lines.size() - 1) continue;
                        ++startOfLine;
                    }
                    String line = this.lines.get(clickedLine);
                    int bestPos = 0;
                    int bestDist = Integer.MAX_VALUE;
                    for (int i = 0; i <= line.length(); ++i) {
                        int charX = this.m_252754_() + 4 + this.fontRenderer.m_92895_(line.substring(0, i));
                        int dist = (int)Math.abs(mouseX - (double)charX);
                        if (dist >= bestDist) continue;
                        bestDist = dist;
                        bestPos = i;
                    }
                    this.cursorPos = startOfLine + bestPos;
                    this.updateCursorPosition();
                    this.lastCursorBlink = System.currentTimeMillis();
                    this.cursorVisible = true;
                }
                return true;
            }
            return result;
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            if (this.m_5953_(mouseX, mouseY)) {
                this.scrollOffset = delta > 0.0 ? Math.max(0, this.scrollOffset - 3) : Math.min(this.scrollOffset + 3, Math.max(0, this.lines.size() - this.m_93694_() / 12));
                return true;
            }
            return false;
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (this.m_94213_()) {
                Object jsonError;
                boolean isValidJson;
                block21: {
                    guiGraphics.m_280509_(this.m_252754_() - 1, this.m_252907_() - 1, this.m_252754_() + this.f_93618_ + 1, this.m_252907_() + this.f_93619_ + 1, -6250336);
                    guiGraphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -16777216);
                    isValidJson = true;
                    jsonError = null;
                    try {
                        JsonParser.parseString((String)this.fullText);
                    }
                    catch (Exception e) {
                        isValidJson = false;
                        jsonError = e.getMessage();
                        if (jsonError == null || ((String)jsonError).length() <= 50) break block21;
                        jsonError = ((String)jsonError).substring(0, 47) + "...";
                    }
                }
                if (this.fullText.trim().startsWith("{") || this.fullText.trim().startsWith("[")) {
                    String validationText = isValidJson ? "\u2713 Valid JSON" : "\u2717 Invalid JSON";
                    int validationColor = isValidJson ? 0x55FF55 : 0xFF5555;
                    guiGraphics.m_280488_(this.fontRenderer, validationText, this.m_252754_() + this.f_93618_ - this.fontRenderer.m_92895_(validationText) - 10, this.m_252907_() + 5, validationColor);
                    if (!isValidJson && jsonError != null) {
                        guiGraphics.m_280488_(this.fontRenderer, (String)jsonError, this.m_252754_() + 5, this.m_252907_() + this.f_93619_ - 15, 0xFF5555);
                    }
                }
                int visibleLines = this.f_93619_ / 12;
                int endLine = Math.min(this.lines.size(), this.scrollOffset + visibleLines);
                for (int i = this.scrollOffset; i < endLine; ++i) {
                    String line = this.lines.get(i);
                    int yPos = this.m_252907_() + (i - this.scrollOffset) * 12 + 5;
                    if (line.trim().isEmpty()) continue;
                    if (line.contains(":")) {
                        int colonIndex = line.indexOf(":");
                        String key = line.substring(0, colonIndex + 1);
                        String value = colonIndex + 1 < line.length() ? line.substring(colonIndex + 1) : "";
                        guiGraphics.m_280488_(this.fontRenderer, key, this.m_252754_() + 4, yPos, 0x55FFFF);
                        if (value.trim().startsWith("\"")) {
                            guiGraphics.m_280488_(this.fontRenderer, value, this.m_252754_() + 4 + this.fontRenderer.m_92895_(key), yPos, 0x55FF55);
                            continue;
                        }
                        if (value.trim().matches("\\s*\\d+(\\.\\d+)?\\s*,?")) {
                            guiGraphics.m_280488_(this.fontRenderer, value, this.m_252754_() + 4 + this.fontRenderer.m_92895_(key), yPos, 0xFFFF55);
                            continue;
                        }
                        if (value.trim().matches("\\s*(true|false)\\s*,?")) {
                            guiGraphics.m_280488_(this.fontRenderer, value, this.m_252754_() + 4 + this.fontRenderer.m_92895_(key), yPos, 0xFF55FF);
                            continue;
                        }
                        if (value.trim().matches("\\s*(null)\\s*,?")) {
                            guiGraphics.m_280488_(this.fontRenderer, value, this.m_252754_() + 4 + this.fontRenderer.m_92895_(key), yPos, 0xAAAAAA);
                            continue;
                        }
                        guiGraphics.m_280488_(this.fontRenderer, value, this.m_252754_() + 4 + this.fontRenderer.m_92895_(key), yPos, 0xFFFFFF);
                        continue;
                    }
                    String trimmed = line.trim();
                    if (trimmed.matches("[{}]")) {
                        guiGraphics.m_280488_(this.fontRenderer, line, this.m_252754_() + 4, yPos, 0xFFAA00);
                        continue;
                    }
                    if (trimmed.matches("[\\[\\]]")) {
                        guiGraphics.m_280488_(this.fontRenderer, line, this.m_252754_() + 4, yPos, 43775);
                        continue;
                    }
                    if (trimmed.equals(",")) {
                        guiGraphics.m_280488_(this.fontRenderer, line, this.m_252754_() + 4, yPos, 0xAAAAAA);
                        continue;
                    }
                    if (trimmed.startsWith("\"") && trimmed.endsWith("\",")) {
                        guiGraphics.m_280488_(this.fontRenderer, line, this.m_252754_() + 4, yPos, 0x55FF55);
                        continue;
                    }
                    if (trimmed.matches("\\d+(\\.\\d+)?,?")) {
                        guiGraphics.m_280488_(this.fontRenderer, line, this.m_252754_() + 4, yPos, 0xFFFF55);
                        continue;
                    }
                    if (trimmed.matches("(true|false),?")) {
                        guiGraphics.m_280488_(this.fontRenderer, line, this.m_252754_() + 4, yPos, 0xFF55FF);
                        continue;
                    }
                    guiGraphics.m_280488_(this.fontRenderer, line, this.m_252754_() + 4, yPos, 0xFFFFFF);
                }
                if (this.lines.size() > visibleLines) {
                    int scrollBarHeight = Math.max(20, visibleLines * this.f_93619_ / this.lines.size());
                    int scrollBarY = this.m_252907_() + this.scrollOffset * (this.f_93619_ - scrollBarHeight) / Math.max(1, this.lines.size() - visibleLines);
                    guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ - 6, this.m_252907_(), this.m_252754_() + this.f_93618_, this.m_252907_() + this.f_93619_, -7303024);
                    guiGraphics.m_280509_(this.m_252754_() + this.f_93618_ - 5, scrollBarY, this.m_252754_() + this.f_93618_ - 1, scrollBarY + scrollBarHeight, -3092272);
                }
                if (this.m_93696_() && this.isEditableCustom()) {
                    if (System.currentTimeMillis() - this.lastCursorBlink > 500L) {
                        this.cursorVisible = !this.cursorVisible;
                        this.lastCursorBlink = System.currentTimeMillis();
                    }
                    if (this.cursorVisible && this.cursorLine >= this.scrollOffset && this.cursorLine < endLine) {
                        String lineBeforeCursor = this.lines.get(this.cursorLine).substring(0, this.cursorColumn);
                        int cursorX = this.m_252754_() + 4 + this.fontRenderer.m_92895_(lineBeforeCursor);
                        int cursorY = this.m_252907_() + (this.cursorLine - this.scrollOffset) * 12 + 5;
                        guiGraphics.m_280509_(cursorX, cursorY, cursorX + 1, cursorY + 10, -3092272);
                    }
                }
            }
        }
    }
}

