/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.poe.entitylootdrops.config.ModConfig;
import net.poe.entitylootdrops.lootdrops.LootConfig;
import net.poe.entitylootdrops.lootdrops.events.EventDropCountManager;

@Mod.EventBusSubscriber(modid="entitylootdrops")
public class LootCommands {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"lootdrops").then(((LiteralArgumentBuilder)Commands.m_82127_((String)"alltop").executes(context -> LootCommands.showAllEventsTopPlayers((CommandContext<CommandSourceStack>)context, 5))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)50)).executes(context -> {
            int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
            return LootCommands.showAllEventsTopPlayers((CommandContext<CommandSourceStack>)context, count);
        })))).then(Commands.m_82127_((String)"eventtop").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"eventName", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (String eventName : EventDropCountManager.getEventsWithDropCounts()) {
                builder.suggest(eventName);
            }
            return builder.buildFuture();
        }).executes(context -> {
            String eventName = StringArgumentType.getString((CommandContext)context, (String)"eventName");
            return LootCommands.showEventTopPlayers((CommandContext<CommandSourceStack>)context, eventName, 5);
        })).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)50)).executes(context -> {
            String eventName = StringArgumentType.getString((CommandContext)context, (String)"eventName");
            int count = IntegerArgumentType.getInteger((CommandContext)context, (String)"count");
            return LootCommands.showEventTopPlayers((CommandContext<CommandSourceStack>)context, eventName, count);
        })))));
        LiteralArgumentBuilder rootCommand = (LiteralArgumentBuilder)Commands.m_82127_((String)"lootdrops").requires(source -> source.m_6761_(2));
        rootCommand.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"event").then(Commands.m_82129_((String)"eventName", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            for (String eventName : LootConfig.getAllEventNames()) {
                builder.suggest(eventName);
            }
            return builder.buildFuture();
        }).then(Commands.m_82129_((String)"active", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            String eventName = StringArgumentType.getString((CommandContext)context, (String)"eventName");
            boolean active = BoolArgumentType.getBool((CommandContext)context, (String)"active");
            boolean eventExists = false;
            for (String availableEvent : LootConfig.getAllEventNames()) {
                if (!availableEvent.equalsIgnoreCase(eventName)) continue;
                eventExists = true;
                break;
            }
            if (!eventExists) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown event: " + eventName)));
                return 0;
            }
            LootConfig.toggleEvent(eventName, active);
            boolean syncSuccess = ModConfig.syncFromLootConfig();
            if (!syncSuccess && ModConfig.isConfigLoaded()) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Warning: Config sync failed. Changes may not persist after restart."));
            }
            String statusMessage = active ? "\u00a7aEnabled" : "\u00a7cDisabled";
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)(statusMessage + " event: \u00a7e" + eventName)), true);
            return 1;
        })))).then(Commands.m_82127_((String)"dropchance").then(Commands.m_82129_((String)"active", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean active = BoolArgumentType.getBool((CommandContext)context, (String)"active");
            LootConfig.toggleDropChanceEvent(active);
            boolean syncSuccess = ModConfig.syncFromLootConfig();
            if (!syncSuccess) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Warning: Config sync failed. Changes may not persist after restart."));
            }
            String statusMessage = active ? "\u00a7aEnabled" : "\u00a7cDisabled";
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)(statusMessage + " drop chance event (2x drop rates)")), true);
            return 1;
        })))).then(Commands.m_82127_((String)"doubledrops").then(Commands.m_82129_((String)"active", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean active = BoolArgumentType.getBool((CommandContext)context, (String)"active");
            LootConfig.toggleDoubleDrops(active);
            boolean syncSuccess = ModConfig.syncFromLootConfig();
            if (!syncSuccess) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Warning: Config sync failed. Changes may not persist after restart."));
            }
            String statusMessage = active ? "\u00a7aEnabled" : "\u00a7cDisabled";
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)(statusMessage + " double drops event (2x amounts)")), true);
            return 1;
        }))));
        rootCommand.then(Commands.m_82127_((String)"debug").then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean enabled = BoolArgumentType.getBool((CommandContext)context, (String)"enabled");
            LootConfig.setDebugLogging(enabled);
            boolean syncSuccess = ModConfig.syncFromLootConfig();
            if (!syncSuccess) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Warning: Config sync failed. Changes may not persist after restart."));
            }
            if (enabled) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7aEnabled debug logging - \u00a7eDetailed drop information will be logged"), true);
            } else {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7cDisabled debug logging - Only errors will be logged"), true);
            }
            return 1;
        })));
        rootCommand.then(Commands.m_82127_((String)"playerstats").then(Commands.m_82129_((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            if (((CommandSourceStack)context.getSource()).m_81377_() != null) {
                for (ServerPlayer player : ((CommandSourceStack)context.getSource()).m_81377_().m_6846_().m_11314_()) {
                    builder.suggest(player.m_7755_().getString());
                }
            }
            return builder.buildFuture();
        }).executes(context -> {
            String playerName = StringArgumentType.getString((CommandContext)context, (String)"player");
            return LootCommands.showPlayerStats((CommandContext<CommandSourceStack>)context, playerName);
        })));
        rootCommand.then(Commands.m_82127_((String)"reset_counts").executes(context -> {
            EventDropCountManager.resetAllEventDropCounts();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7aReset all drop counts for all events!"), true);
            return 1;
        }));
        rootCommand.then(Commands.m_82127_((String)"debuginfo").executes(context -> {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a76=== Drop Count Debug Info ==="), false);
            boolean enabled = LootConfig.isDropCountEnabled();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7eGlobal Drop Counting: " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"))), false);
            Set<String> activeEvents = LootConfig.getActiveEvents();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7eActive Events: \u00a7f" + String.join((CharSequence)", ", activeEvents))), false);
            List<String> eventsWithCounts = EventDropCountManager.getEventsWithDropCounts();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7eEvents with Drop_Count.json: \u00a7f" + String.join((CharSequence)", ", eventsWithCounts))), false);
            return 1;
        }));
        rootCommand.then(Commands.m_82127_((String)"active_events").executes(context -> {
            Set<String> activeEvents = LootConfig.getActiveEvents();
            boolean dropChanceActive = LootConfig.isDropChanceEventActive();
            boolean doubleDropsActive = LootConfig.isDoubleDropsActive();
            boolean debugLoggingActive = LootConfig.isDebugLoggingEnabled();
            boolean dropCountActive = LootConfig.isDropCountEnabled();
            if (!(!activeEvents.isEmpty() || dropChanceActive || doubleDropsActive || debugLoggingActive || dropCountActive)) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7cNo active events or features"), false);
            } else {
                StringBuilder sb = new StringBuilder("\u00a76Active events and features: ");
                if (!activeEvents.isEmpty()) {
                    sb.append("\u00a7a").append(String.join((CharSequence)"\u00a76, \u00a7a", activeEvents));
                }
                if (dropChanceActive) {
                    if (!activeEvents.isEmpty()) {
                        sb.append("\u00a76, ");
                    }
                    sb.append("\u00a7e\u00a7ldropchance (2x drop rates)\u00a7r");
                }
                if (doubleDropsActive) {
                    if (!activeEvents.isEmpty() || dropChanceActive) {
                        sb.append("\u00a76, ");
                    }
                    sb.append("\u00a7e\u00a7ldoubledrops (2x amounts)\u00a7r");
                }
                if (debugLoggingActive) {
                    if (!activeEvents.isEmpty() || dropChanceActive || doubleDropsActive) {
                        sb.append("\u00a76, ");
                    }
                    sb.append("\u00a7b\u00a7ldebug logging\u00a7r");
                }
                if (dropCountActive) {
                    if (!activeEvents.isEmpty() || dropChanceActive || doubleDropsActive || debugLoggingActive) {
                        sb.append("\u00a76, ");
                    }
                    sb.append("\u00a7d\u00a7ldrop counting\u00a7r");
                }
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)sb.toString()), false);
            }
            return 1;
        }));
        rootCommand.then(Commands.m_82127_((String)"listall").executes(context -> {
            Set<String> availableEvents = LootConfig.getAllEventNames();
            if (availableEvents.isEmpty()) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7cNo events available"), false);
            } else {
                StringBuilder sb = new StringBuilder("\u00a76Available events: \u00a7a");
                sb.append(String.join((CharSequence)"\u00a76, \u00a7a", availableEvents));
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)sb.toString()), false);
            }
            return 1;
        }));
        rootCommand.then(Commands.m_82127_((String)"openconfig").executes(context -> {
            if (!(((CommandSourceStack)context.getSource()).m_81373_() instanceof ServerPlayer)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"This command can only be used by a player"));
                return 0;
            }
            ServerPlayer player = (ServerPlayer)((CommandSourceStack)context.getSource()).m_81373_();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7aOpening configuration screen..."), false);
            player.m_213846_((Component)Component.m_237113_((String)"\u00a7a[EntityLootDrops] \u00a7eClick here to open config").m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lootdrops_openconfig_client")).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to open configuration screen"))).m_131162_(Boolean.valueOf(true)).m_131140_(ChatFormatting.GREEN)));
            return 1;
        }));
        rootCommand.then(Commands.m_82127_((String)"reload").executes(context -> {
            LootConfig.loadConfig();
            boolean syncSuccess = ModConfig.syncFromLootConfig();
            if (!syncSuccess) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Warning: Config sync failed. Changes may not persist after restart."));
            }
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a7aReloaded Entity Loot Drops configuration"), true);
            return 1;
        }));
        dispatcher.register(rootCommand);
    }

    private static int showAllEventsTopPlayers(CommandContext<CommandSourceStack> context, int count) {
        List<EventDropCountManager.CombinedPlayerDropCount> topPlayers = EventDropCountManager.getCombinedTopPlayers(count);
        if (topPlayers.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7cNo drop count data available across any events"));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a76=== Top " + Math.min(count, topPlayers.size()) + " Players (All Events) ===")), false);
        int rank = 1;
        for (EventDropCountManager.CombinedPlayerDropCount player : topPlayers) {
            MutableComponent playerNameComponent = ((CommandSourceStack)context.getSource()).m_6761_(2) ? Component.m_237113_((String)("\u00a7a" + player.getPlayerName())).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lootdrops playerstats " + player.getPlayerName())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Click to view " + player.getPlayerName() + "'s detailed stats")))).m_131162_(Boolean.valueOf(true))) : Component.m_237113_((String)("\u00a7a" + player.getPlayerName()));
            MutableComponent message = Component.m_237113_((String)String.format("\u00a7e%d. ", rank)).m_7220_((Component)playerNameComponent).m_7220_((Component)Component.m_237113_((String)String.format("\u00a7f: \u00a7b%d \u00a77total drops", player.getTotalDrops())));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> LootCommands.lambda$showAllEventsTopPlayers$38((Component)message), false);
            ++rank;
        }
        if (((CommandSourceStack)context.getSource()).m_6761_(2)) {
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"\u00a77\u00a7o(Click player names for detailed stats)"), false);
        }
        return 1;
    }

    private static int showEventTopPlayers(CommandContext<CommandSourceStack> context, String eventName, int count) {
        List<EventDropCountManager.EventPlayerDropCount> topPlayers = EventDropCountManager.getEventTopPlayers(eventName, count);
        if (topPlayers.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7cNo drop count data for event: " + eventName)));
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a76=== Top " + Math.min(count, topPlayers.size()) + " Players (" + eventName + ") ===")), false);
        for (int i = 0; i < topPlayers.size(); ++i) {
            EventDropCountManager.EventPlayerDropCount player = topPlayers.get(i);
            MutableComponent playerNameComponent = ((CommandSourceStack)context.getSource()).m_6761_(2) ? Component.m_237113_((String)("\u00a7a" + player.getPlayerName())).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/lootdrops playerstats " + player.getPlayerName())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)("Click to view " + player.getPlayerName() + "'s stats for " + eventName)))).m_131162_(Boolean.valueOf(true))) : Component.m_237113_((String)("\u00a7a" + player.getPlayerName()));
            MutableComponent message = Component.m_237113_((String)String.format("\u00a7e%d. ", i + 1)).m_7220_((Component)playerNameComponent).m_7220_((Component)Component.m_237113_((String)String.format("\u00a7f: \u00a7b%d \u00a77drops", player.getTotalEventDrops())));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> LootCommands.lambda$showEventTopPlayers$42((Component)message), false);
        }
        return 1;
    }

    private static int showPlayerStats(CommandContext<CommandSourceStack> context, String playerName) {
        List<String> events = EventDropCountManager.getEventsWithDropCounts();
        if (events.isEmpty()) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"\u00a7cNo events with drop counting found"));
            return 0;
        }
        boolean foundData = false;
        int totalDropsAcrossEvents = 0;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a76=== " + playerName + " Drop Stats ===")), false);
        for (String eventName : events) {
            EventDropCountManager.EventPlayerDropCount playerData = EventDropCountManager.getPlayerEventDropCount(eventName, playerName);
            if (playerData == null || playerData.getTotalEventDrops() <= 0) continue;
            foundData = true;
            totalDropsAcrossEvents += playerData.getTotalEventDrops();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a7e" + eventName + "\u00a7f: \u00a7b" + playerData.getTotalEventDrops() + " \u00a77drops")), false);
            playerData.getItemCounts().entrySet().stream().sorted((a, b) -> Integer.compare((Integer)b.getValue(), (Integer)a.getValue())).limit(3L).forEach(entry -> ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("  \u00a77\u2022 \u00a7a" + (String)entry.getKey() + "\u00a7f: \u00a7b" + String.valueOf(entry.getValue()))), false));
        }
        if (!foundData) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("\u00a7cNo drop count data found for player: " + playerName)));
            return 0;
        }
        int finalTotalDropsAcrossEvents = totalDropsAcrossEvents;
        ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("\u00a76Total Across All Events: \u00a7b" + finalTotalDropsAcrossEvents + " \u00a77drops")), false);
        return 1;
    }

    private static /* synthetic */ Component lambda$showEventTopPlayers$42(Component message) {
        return message;
    }

    private static /* synthetic */ Component lambda$showAllEventsTopPlayers$38(Component message) {
        return message;
    }
}

