/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import net.poe.entitylootdrops.readme.EventDropsReadme;
import net.poe.entitylootdrops.readme.MainReadme;
import net.poe.entitylootdrops.readme.NormalDropsReadme;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReadmeManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CONFIG_DIR = "config/EntityLootDrops";

    public static void createAllReadmeFiles() {
        try {
            Path configDir = Paths.get(CONFIG_DIR, new String[0]);
            Files.createDirectories(configDir, new FileAttribute[0]);
            Path lootDropsDir = configDir.resolve("Loot Drops");
            if (Files.exists(lootDropsDir, new LinkOption[0])) {
                Path eventDropsDir;
                MainReadme.create(lootDropsDir);
                Path normalDropsDir = lootDropsDir.resolve("Normal Drops");
                if (Files.exists(normalDropsDir, new LinkOption[0])) {
                    NormalDropsReadme.create(normalDropsDir);
                }
                if (Files.exists(eventDropsDir = lootDropsDir.resolve("Event Drops"), new LinkOption[0])) {
                    EventDropsReadme.create(eventDropsDir);
                }
            }
            LOGGER.info("Created all README files");
        }
        catch (IOException e) {
            LOGGER.error("Failed to create README files", (Throwable)e);
        }
    }
}

