/*
 * Decompiled with CFR 0.152.
 */
package net.poe.entitylootdrops;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.poe.entitylootdrops.config.ModConfig;
import net.poe.entitylootdrops.gui.ConfigScreen;
import net.poe.entitylootdrops.lootdrops.LootConfig;
import net.poe.entitylootdrops.lootdrops.events.LootEventHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="entitylootdrops")
public class EntityLootDrops {
    public static final String MOD_ID = "entitylootdrops";
    public static final Logger LOGGER = LogManager.getLogger();

    public static Logger getLogger() {
        return LOGGER;
    }

    public EntityLootDrops() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register(LootEventHandler.class);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        LOGGER.info("Entity Loot Drops mod initializing...");
        LootConfig.loadConfig();
        try {
            Class<?> readmeManagerClass = Class.forName("net.poe.entitylootdrops.ReadmeManager");
            readmeManagerClass.getMethod("createAllReadmeFiles", new Class[0]).invoke(null, new Object[0]);
            LOGGER.info("Created README files");
        }
        catch (ClassNotFoundException e) {
            LOGGER.debug("ReadmeManager not found - README files not created");
        }
        catch (Exception e) {
            LOGGER.warn("Failed to create README files: {}", (Object)e.getMessage());
        }
        LOGGER.info("Initial config load complete");
        ModConfig.setConfigLoaded(true);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            try {
                ConfigScreen.register();
                LOGGER.info("Registered config screen");
            }
            catch (Exception e) {
                LOGGER.warn("ConfigScreen not found or failed to register: {}", (Object)e.getMessage());
            }
        }
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Entity Loot Drops setup complete");
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("Server starting - reloading configurations...");
        LootConfig.loadConfig();
        LOGGER.info("Loaded {} normal drops", (Object)LootConfig.getNormalDrops().size());
        LOGGER.info("Loaded {} hostile drops", (Object)LootConfig.getNormalHostileDrops().size());
        LOGGER.info("Loaded {} event types", (Object)LootConfig.getEventDrops().size());
        LOGGER.info("Active events: {}", LootConfig.getActiveEvents());
    }

    @SubscribeEvent
    public void onServerStopping(ServerStoppingEvent event) {
        LOGGER.info("Server stopping - saving persistent data...");
        LOGGER.info("Server shutdown complete");
    }

    public static void forceRegenerateExamples() {
        LOGGER.info("Force regenerating all example configuration files...");
        try {
            Path configDir = Paths.get("config/EntityLootDrops", new String[0]);
            if (Files.exists(configDir, new LinkOption[0])) {
                Files.walk(configDir, new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(".tracker")).forEach(trackerFile -> {
                    try {
                        Files.deleteIfExists(trackerFile);
                        LOGGER.debug("Deleted tracker file: {}", trackerFile);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to delete tracker file {}: {}", trackerFile, (Object)e.getMessage());
                    }
                });
            }
            LootConfig.loadConfig();
            LOGGER.info("Successfully regenerated all example configuration files");
        }
        catch (Exception e) {
            LOGGER.error("Failed to force regenerate examples: {}", (Object)e.getMessage());
        }
    }

    public static void forceRegenerateAllConfigs() {
        LOGGER.info("Force regenerating ALL configuration files (including main templates)...");
        try {
            Path configDir = Paths.get("config/EntityLootDrops", new String[0]);
            if (Files.exists(configDir, new LinkOption[0])) {
                Files.walk(configDir, new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith(".tracker")).forEach(trackerFile -> {
                    try {
                        Files.deleteIfExists(trackerFile);
                        LOGGER.debug("Deleted tracker file: {}", trackerFile);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to delete tracker file {}: {}", trackerFile, (Object)e.getMessage());
                    }
                });
                Files.walk(configDir, new FileVisitOption[0]).filter(path -> path.getFileName().toString().equals("Global_Hostile_Drops.json")).forEach(templateFile -> {
                    try {
                        Files.deleteIfExists(templateFile);
                        LOGGER.debug("Deleted main template file: {}", templateFile);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to delete template file {}: {}", templateFile, (Object)e.getMessage());
                    }
                });
            }
            LootConfig.loadConfig();
            LOGGER.info("Successfully regenerated ALL configuration files");
        }
        catch (Exception e) {
            LOGGER.error("Failed to force regenerate all configs: {}", (Object)e.getMessage());
        }
    }

    public static Map<String, Boolean> checkExampleModificationStatus() {
        HashMap<String, Boolean> modificationStatus = new HashMap<String, Boolean>();
        try {
            Path configDir = Paths.get("config/EntityLootDrops", new String[0]);
            if (Files.exists(configDir, new LinkOption[0])) {
                Files.walk(configDir, new FileVisitOption[0]).filter(path -> path.getFileName().toString().endsWith("_Example.json")).forEach(exampleFile -> {
                    try {
                        String fileName = exampleFile.toString();
                        boolean isModified = EntityLootDrops.checkIfFileModified(exampleFile);
                        modificationStatus.put(fileName, isModified);
                        if (isModified) {
                            LOGGER.debug("Example file {} has been modified", (Object)fileName);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Failed to check modification status for {}: {}", exampleFile, (Object)e.getMessage());
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to check example modification status: {}", (Object)e.getMessage());
        }
        return modificationStatus;
    }

    private static boolean checkIfFileModified(Path exampleFile) {
        try {
            long fileSize;
            long lastModified;
            String currentHash;
            String fileName = exampleFile.getFileName().toString();
            String trackerName = "." + fileName + ".tracker";
            Path trackerFile = exampleFile.getParent().resolve(trackerName);
            if (!Files.exists(trackerFile, new LinkOption[0])) {
                return false;
            }
            String storedHash = new String(Files.readAllBytes(trackerFile)).trim();
            return !storedHash.equals(currentHash = String.valueOf((lastModified = Files.getLastModifiedTime(exampleFile, new LinkOption[0]).toMillis()) + (fileSize = Files.size(exampleFile))));
        }
        catch (Exception e) {
            LOGGER.debug("Failed to check modification status for {}: {}", (Object)exampleFile, (Object)e.getMessage());
            return false;
        }
    }
}

