/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.vrapi.data;

import net.blf02.vrapi.api.data.IVRPlayer;
import net.blf02.vrapi.data.VRData;
import net.minecraft.network.FriendlyByteBuf;

public class VRPlayer
implements IVRPlayer {
    protected final VRData hmd;
    protected final VRData controller0;
    protected final VRData controller1;
    protected final VRData leftEye;
    protected final VRData rightEye;

    public VRPlayer(VRData hmd, VRData controller0, VRData controller1, VRData leftEye, VRData rightEye) {
        this.hmd = hmd;
        this.controller0 = controller0;
        this.controller1 = controller1;
        this.leftEye = leftEye;
        this.rightEye = rightEye;
    }

    @Override
    public VRData getHMD() {
        return this.hmd;
    }

    @Override
    public VRData getController0() {
        return this.controller0;
    }

    @Override
    public VRData getController1() {
        return this.controller1;
    }

    @Override
    public VRData getController(int controller) {
        if (controller != 0 && controller != 1) {
            throw new IllegalArgumentException("Controller " + controller + " invalid! You can only select controllers 0 or 1.");
        }
        return controller == 0 ? this.getController0() : this.getController1();
    }

    @Override
    public VRData getLeftEye() {
        return this.leftEye;
    }

    @Override
    public VRData getRightEye() {
        return this.rightEye;
    }

    @Override
    public VRData getEye(int eye) {
        if (eye == 0) {
            return this.getLeftEye();
        }
        if (eye == 1) {
            return this.getRightEye();
        }
        throw new IllegalArgumentException("Eye " + eye + " invalid! You can only select eyes 0 or 1.");
    }

    public static void encode(VRPlayer player, FriendlyByteBuf buffer) {
        VRData.encode(player.getHMD(), buffer);
        VRData.encode(player.getController0(), buffer);
        VRData.encode(player.getController1(), buffer);
        VRData.encode(player.getLeftEye(), buffer);
        VRData.encode(player.getRightEye(), buffer);
    }

    public static VRPlayer decode(FriendlyByteBuf buffer) {
        VRData hmd = VRData.decode(buffer);
        VRData c0 = VRData.decode(buffer);
        VRData c1 = VRData.decode(buffer);
        VRData leftEye = VRData.decode(buffer);
        VRData rightEye = VRData.decode(buffer);
        return new VRPlayer(hmd, c0, c1, leftEye, rightEye);
    }
}

