/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.vrapi.common;

import java.lang.reflect.InvocationTargetException;
import net.blf02.vrapi.VRAPIMod;
import net.blf02.vrapi.api.IVRAPI;
import net.blf02.vrapi.api.data.IVRPlayer;
import net.blf02.vrapi.client.MessageClient;
import net.blf02.vrapi.client.ReflectionConstants;
import net.blf02.vrapi.client.ServerHasAPI;
import net.blf02.vrapi.client.VRDataGrabber;
import net.blf02.vrapi.common.Constants;
import net.blf02.vrapi.common.Plat;
import net.blf02.vrapi.common.network.Network;
import net.blf02.vrapi.common.network.packets.VRRumblePacket;
import net.blf02.vrapi.debug.DevModeData;
import net.blf02.vrapi.server.Tracker;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class VRAPI
implements IVRAPI {
    public static final IVRAPI VRAPIInstance = new VRAPI();

    @Override
    public String getVersionString() {
        return Constants.getVersion();
    }

    @Override
    public int[] getVersionArray() {
        return Constants.version;
    }

    @Override
    public boolean apiActive(Player player) {
        if (player.m_9236_().f_46443_) {
            VRDataGrabber.isSelf(player);
            return ServerHasAPI.serverHasAPI;
        }
        return Tracker.playerToVR.get(player.m_36316_().getName()) != null;
    }

    @Override
    @Nullable
    public IVRPlayer getVRPlayer(Player player) {
        if (player.m_9236_().f_46443_) {
            VRDataGrabber.isSelf(player);
            if (VRAPIMod.USE_DEV_FEATURES && DevModeData.devModeInVR) {
                return DevModeData.fakePlayer;
            }
            return VRDataGrabber.getVRPlayer(VRDataGrabber.PlayerType.WORLD_POST);
        }
        return Tracker.playerToVR.get(player.m_36316_().getName()).vrPlayer();
    }

    @Override
    public IVRPlayer getPreTickVRPlayer() {
        return VRDataGrabber.getVRPlayer(VRDataGrabber.PlayerType.WORLD_PRE);
    }

    @Override
    public IVRPlayer getRenderVRPlayer() {
        return VRDataGrabber.getVRPlayer(VRDataGrabber.PlayerType.WORLD_RENDER);
    }

    @Override
    public IVRPlayer getPreTickRoomVRPlayer() {
        return VRDataGrabber.getVRPlayer(VRDataGrabber.PlayerType.ROOM_PRE);
    }

    @Override
    public IVRPlayer getPostTickRoomVRPlayer() {
        return VRDataGrabber.getVRPlayer(VRDataGrabber.PlayerType.ROOM_POST);
    }

    @Override
    public boolean playerInVR(Player player) {
        if (player.m_9236_().f_46443_) {
            VRDataGrabber.isSelf(player);
            return VRDataGrabber.inVR() || VRAPIMod.USE_DEV_FEATURES && DevModeData.devModeInVR;
        }
        return Tracker.playerToVR.containsKey(player.m_36316_().getName());
    }

    @Override
    public void triggerHapticPulse(int controllerNum, float durationSeconds, @Nullable ServerPlayer player) {
        this.triggerHapticPulse(controllerNum, durationSeconds, 160.0f, 1.0f, 0.0f, player);
    }

    @Override
    public void triggerHapticPulse(int controllerNum, float durationSeconds, float frequency, float amplitude, float delaySeconds, @Nullable ServerPlayer player) {
        if (player != null) {
            Network.CHANNEL.sendToPlayer(player, new VRRumblePacket(controllerNum, durationSeconds, frequency, amplitude, delaySeconds));
        } else if (Plat.INSTANCE.isClient()) {
            if (VRAPIMod.USE_DEV_FEATURES && DevModeData.devModeInVR) {
                MessageClient.msg("Did haptic pulse for %.2f seconds on controller number %d.".formatted(Float.valueOf(durationSeconds), controllerNum));
            } else {
                try {
                    VRDataGrabber.initMinecraftVRInstanceIfNeeded();
                    VRDataGrabber.MCVR_triggerHapticPulse.invoke(VRDataGrabber.Minecraft_vr_Instance, ReflectionConstants.ControllerType_ENUMS[controllerNum], Float.valueOf(durationSeconds), Float.valueOf(frequency), Float.valueOf(amplitude), Float.valueOf(delaySeconds));
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("Could not run triggerHapticPulse function. Not sure why, though...");
                }
            }
        }
    }

    @Override
    public boolean isSeated(Player player) {
        if (player.m_9236_().f_46443_) {
            VRDataGrabber.isSelf(player);
            if (VRAPIMod.USE_DEV_FEATURES && DevModeData.devModeInVR) {
                return false;
            }
            return VRDataGrabber.isSeated();
        }
        return Tracker.playerToVR.get(player.m_36316_().getName()).isSeated();
    }

    @Override
    public boolean isLeftHanded(Player player) {
        if (player.m_9236_().f_46443_) {
            VRDataGrabber.isSelf(player);
            if (VRAPIMod.USE_DEV_FEATURES && DevModeData.devModeInVR) {
                return false;
            }
            return VRDataGrabber.isLeftHanded();
        }
        return Tracker.playerToVR.get(player.m_36316_().getName()).isLeftHanded();
    }
}

