/*
 * Decompiled with CFR 0.152.
 */
package net.blf02.vrapi.client;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.FloatBuffer;
import java.util.logging.Level;
import net.blf02.vrapi.VRAPIMod;
import net.blf02.vrapi.client.ReflectionConstants;
import net.blf02.vrapi.data.VRData;
import net.blf02.vrapi.data.VRPlayer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class VRDataGrabber {
    public static Field Minecraft_vr;
    public static Object Minecraft_vr_Instance;
    public static Object vrHolder;
    protected static Method VRPlayer_GET;
    protected static Field VRPlayer_vrdata_world_post;
    protected static Field VRPlayer_vrdata_world_pre;
    protected static Field VRPlayer_vrdata_world_render;
    protected static Field VRPlayer_vrdata_room_pre;
    protected static Field VRPlayer_vrdata_room_post;
    protected static Field VRData_hmd;
    protected static Field VRData_c0;
    protected static Field VRData_c1;
    protected static Field VRData_eye0;
    protected static Field VRData_eye1;
    protected static Method VRDevicePose_getPosition;
    protected static Method VRDevicePose_getDirection;
    protected static Method VRDevicePose_getRoll;
    protected static Method VRDevicePose_getMatrix;
    protected static Method Matrix4f_toFloatBuffer;
    public static Method MCVR_triggerHapticPulse;
    public static Method MCVR_isActive;
    public static Field Minecraft_VRSettings;
    public static Field VRSettings_seated;
    public static Field VRSettings_reverseHands;

    public static void init() {
        if (!ReflectionConstants.clientHasVivecraft()) {
            VRAPIMod.LOGGER.log(Level.INFO, "Vivecraft was not detected! Not reflecting...");
        } else {
            try {
                VRPlayer_GET = VRDataGrabber.getMethod(ReflectionConstants.VRPlayerRaw, "get", new Class[0]);
                VRPlayer_vrdata_world_post = VRDataGrabber.getField(ReflectionConstants.VRPlayerRaw, "vrdata_world_post");
                VRPlayer_vrdata_world_pre = VRDataGrabber.getField(ReflectionConstants.VRPlayerRaw, "vrdata_world_pre");
                VRPlayer_vrdata_world_render = VRDataGrabber.getField(ReflectionConstants.VRPlayerRaw, "vrdata_world_render");
                VRPlayer_vrdata_room_pre = VRDataGrabber.getField(ReflectionConstants.VRPlayerRaw, "vrdata_room_pre");
                VRPlayer_vrdata_room_post = VRDataGrabber.getField(ReflectionConstants.VRPlayerRaw, "vrdata_room_post");
                VRData_hmd = VRDataGrabber.getField(ReflectionConstants.VRDataRaw, "hmd");
                VRData_c0 = VRDataGrabber.getField(ReflectionConstants.VRDataRaw, "c0");
                VRData_c1 = VRDataGrabber.getField(ReflectionConstants.VRDataRaw, "c1");
                VRData_eye0 = VRDataGrabber.getField(ReflectionConstants.VRDataRaw, "eye0");
                VRData_eye1 = VRDataGrabber.getField(ReflectionConstants.VRDataRaw, "eye1");
                VRDevicePose_getPosition = VRDataGrabber.getMethod(ReflectionConstants.VRDevicePoseRaw, "getPosition", new Class[0]);
                VRDevicePose_getDirection = VRDataGrabber.getMethod(ReflectionConstants.VRDevicePoseRaw, "getDirection", new Class[0]);
                VRDevicePose_getRoll = VRDataGrabber.getMethod(ReflectionConstants.VRDevicePoseRaw, "getRoll", new Class[0]);
                VRDevicePose_getMatrix = VRDataGrabber.getMethod(ReflectionConstants.VRDevicePoseRaw, "getMatrix", new Class[0]);
                if (!ReflectionConstants.useJOMLClasses()) {
                    Matrix4f_toFloatBuffer = VRDataGrabber.getMethod(ReflectionConstants.Matrix4f, "toFloatBuffer", new Class[0]);
                }
                try {
                    Minecraft_vr = VRDataGrabber.getField(Minecraft.class, "vr");
                    Minecraft_VRSettings = VRDataGrabber.getField(Minecraft.class, "vrSettings");
                    vrHolder = Minecraft.m_91087_();
                }
                catch (RuntimeException e) {
                    Class<?> ClientDataHolder;
                    try {
                        ClientDataHolder = Class.forName("org.vivecraft.ClientDataHolder");
                    }
                    catch (ClassNotFoundException e2) {
                        ClientDataHolder = Class.forName("org.vivecraft.client_vr.ClientDataHolderVR");
                    }
                    Method getCDHInstance = VRDataGrabber.getMethod(ClientDataHolder, "getInstance", new Class[0]);
                    Object cdhInstance = getCDHInstance.invoke(null, new Object[0]);
                    Minecraft_vr = VRDataGrabber.getField(ClientDataHolder, "vr");
                    Minecraft_VRSettings = VRDataGrabber.getField(ClientDataHolder, "vrSettings");
                    vrHolder = cdhInstance;
                }
                Minecraft_vr_Instance = Minecraft_vr.get(vrHolder);
                VRSettings_seated = VRDataGrabber.getField(ReflectionConstants.VRSettings, "seated");
                VRSettings_reverseHands = VRDataGrabber.getField(ReflectionConstants.VRSettings, "reverseHands");
                MCVR_triggerHapticPulse = VRDataGrabber.getMethod(ReflectionConstants.MCVR, "triggerHapticPulse", ReflectionConstants.ControllerType, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
                try {
                    MCVR_isActive = VRDataGrabber.getMethod(ReflectionConstants.MCVR, "isActive", new Class[0]);
                }
                catch (RuntimeException e) {}
            }
            catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
                VRAPIMod.LOGGER.log(Level.SEVERE, "Error: " + e.getMessage());
                throw new RuntimeException("Fatal error! Could not get! Please report this, along with the error message above!");
            }
        }
    }

    public static VRPlayer getVRPlayer(PlayerType type) {
        if (!VRDataGrabber.inVR()) {
            return null;
        }
        try {
            Object vrPlayerRaw = VRPlayer_GET.invoke(null, new Object[0]);
            if (vrPlayerRaw == null) {
                return null;
            }
            Object vrDataRaw = switch (type) {
                case PlayerType.WORLD_PRE -> VRPlayer_vrdata_world_pre.get(vrPlayerRaw);
                case PlayerType.WORLD_RENDER -> VRPlayer_vrdata_world_render.get(vrPlayerRaw);
                case PlayerType.ROOM_PRE -> VRPlayer_vrdata_room_pre.get(vrPlayerRaw);
                case PlayerType.ROOM_POST -> VRPlayer_vrdata_room_post.get(vrPlayerRaw);
                default -> VRPlayer_vrdata_world_post.get(vrPlayerRaw);
            };
            if (vrDataRaw == null) {
                return null;
            }
            Object hmdDevicePoseRaw = VRData_hmd.get(vrDataRaw);
            Object c0DevicePoseRaw = VRData_c0.get(vrDataRaw);
            Object c1DevicePoseRaw = VRData_c1.get(vrDataRaw);
            Object eye0DevicePoseRaw = VRData_eye0.get(vrDataRaw);
            Object eye1DevicePoseRaw = VRData_eye1.get(vrDataRaw);
            Vec3 hmdPosition = (Vec3)VRDevicePose_getPosition.invoke(hmdDevicePoseRaw, new Object[0]);
            Vec3 hmdLookVec = VRDataGrabber.fromVivecraftVec3(VRDevicePose_getDirection.invoke(hmdDevicePoseRaw, new Object[0]));
            float hmdRoll = ((Float)VRDevicePose_getRoll.invoke(hmdDevicePoseRaw, new Object[0])).floatValue();
            Matrix4f hmdRotMatr = VRDataGrabber.fromVivecraftMatrix4f(VRDevicePose_getMatrix.invoke(hmdDevicePoseRaw, new Object[0]));
            Vec3 c0Position = (Vec3)VRDevicePose_getPosition.invoke(c0DevicePoseRaw, new Object[0]);
            Vec3 c0LookVec = VRDataGrabber.fromVivecraftVec3(VRDevicePose_getDirection.invoke(c0DevicePoseRaw, new Object[0]));
            float c0roll = ((Float)VRDevicePose_getRoll.invoke(c0DevicePoseRaw, new Object[0])).floatValue();
            Matrix4f c0RotMatr = VRDataGrabber.fromVivecraftMatrix4f(VRDevicePose_getMatrix.invoke(c0DevicePoseRaw, new Object[0]));
            Vec3 c1Position = (Vec3)VRDevicePose_getPosition.invoke(c1DevicePoseRaw, new Object[0]);
            Vec3 c1LookVec = VRDataGrabber.fromVivecraftVec3(VRDevicePose_getDirection.invoke(c1DevicePoseRaw, new Object[0]));
            float c1roll = ((Float)VRDevicePose_getRoll.invoke(c1DevicePoseRaw, new Object[0])).floatValue();
            Matrix4f c1RotMatr = VRDataGrabber.fromVivecraftMatrix4f(VRDevicePose_getMatrix.invoke(c1DevicePoseRaw, new Object[0]));
            Vec3 eye0Position = (Vec3)VRDevicePose_getPosition.invoke(eye0DevicePoseRaw, new Object[0]);
            Vec3 eye0LookVec = VRDataGrabber.fromVivecraftVec3(VRDevicePose_getDirection.invoke(eye0DevicePoseRaw, new Object[0]));
            float eye0roll = ((Float)VRDevicePose_getRoll.invoke(eye0DevicePoseRaw, new Object[0])).floatValue();
            Matrix4f eye0RotMatr = VRDataGrabber.fromVivecraftMatrix4f(VRDevicePose_getMatrix.invoke(eye0DevicePoseRaw, new Object[0]));
            Vec3 eye1Position = (Vec3)VRDevicePose_getPosition.invoke(eye1DevicePoseRaw, new Object[0]);
            Vec3 eye1LookVec = VRDataGrabber.fromVivecraftVec3(VRDevicePose_getDirection.invoke(eye1DevicePoseRaw, new Object[0]));
            float eye1roll = ((Float)VRDevicePose_getRoll.invoke(eye1DevicePoseRaw, new Object[0])).floatValue();
            Matrix4f eye1RotMatr = VRDataGrabber.fromVivecraftMatrix4f(VRDevicePose_getMatrix.invoke(eye1DevicePoseRaw, new Object[0]));
            return new VRPlayer(new VRData(hmdPosition, hmdLookVec, hmdRoll, hmdRotMatr), new VRData(c0Position, c0LookVec, c0roll, c0RotMatr), new VRData(c1Position, c1LookVec, c1roll, c1RotMatr), new VRData(eye0Position, eye0LookVec, eye0roll, eye0RotMatr), new VRData(eye1Position, eye1LookVec, eye1roll, eye1RotMatr));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Could not obtain data from Vivecraft! Something has gone horribly wrong.");
        }
        catch (NullPointerException ignored) {
            return null;
        }
    }

    private static Vec3 fromVivecraftVec3(Object vecIn) {
        if (!ReflectionConstants.useJOMLClasses()) {
            return (Vec3)vecIn;
        }
        Vector3f vec = (Vector3f)vecIn;
        return new Vec3((double)vec.x, (double)vec.y, (double)vec.z);
    }

    public static Matrix4f fromVivecraftMatrix4f(Object matrixIn) throws InvocationTargetException, IllegalAccessException {
        if (ReflectionConstants.useJOMLClasses()) {
            return (Matrix4f)matrixIn;
        }
        FloatBuffer buffer = (FloatBuffer)Matrix4f_toFloatBuffer.invoke(matrixIn, new Object[0]);
        Matrix4f matr = new Matrix4f(buffer.get(), buffer.get(), buffer.get(), buffer.get(), buffer.get(), buffer.get(), buffer.get(), buffer.get(), buffer.get(), buffer.get(), buffer.get(), buffer.get(), buffer.get(), buffer.get(), buffer.get(), buffer.get());
        return matr;
    }

    public static boolean inVR() {
        if (!ReflectionConstants.clientHasVivecraft()) {
            return false;
        }
        try {
            Object vrPlayerRaw = VRPlayer_GET.invoke(null, new Object[0]);
            return vrPlayerRaw != null && VRDataGrabber.hotswitchVRActive();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return false;
        }
    }

    public static boolean isSeated() {
        if (!ReflectionConstants.clientHasVivecraft()) {
            throw new IllegalArgumentException("Cannot retrieve seated status of player outside VR!");
        }
        try {
            Object VRSettingsInstance = Minecraft_VRSettings.get(vrHolder);
            return (Boolean)VRSettings_seated.get(VRSettingsInstance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get seated status of local player!");
        }
    }

    public static boolean isLeftHanded() {
        if (!ReflectionConstants.clientHasVivecraft()) {
            throw new IllegalArgumentException("Cannot retrieve hand status of player outside VR!");
        }
        try {
            Object VRSettingsInstance = Minecraft_VRSettings.get(vrHolder);
            return (Boolean)VRSettings_reverseHands.get(VRSettingsInstance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Could not get handedness of local player!");
        }
    }

    public static void isSelf(Player player) {
        if (player != Minecraft.m_91087_().f_91074_) {
            throw new IllegalArgumentException("Client side can only retrieve player data about themself!");
        }
    }

    public static void initMinecraftVRInstanceIfNeeded() {
        if (Minecraft_vr_Instance == null) {
            try {
                Minecraft_vr_Instance = Minecraft_vr.get(vrHolder);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static boolean hotswitchVRActive() {
        if (MCVR_isActive != null) {
            try {
                VRDataGrabber.initMinecraftVRInstanceIfNeeded();
                return (Boolean)MCVR_isActive.invoke(Minecraft_vr_Instance, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                return false;
            }
        }
        return true;
    }

    public static Field getField(Class<?> clazz, String field) {
        try {
            return clazz.getField(field);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Could not get field " + field + " from " + clazz);
        }
    }

    public static Method getMethod(Class<?> clazz, String method, Class<?> ... parameterTypes) {
        try {
            return clazz.getMethod(method, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Could not load method " + method + " from " + clazz);
        }
    }

    static {
        MCVR_isActive = null;
    }

    public static enum PlayerType {
        WORLD_POST,
        WORLD_PRE,
        WORLD_RENDER,
        ROOM_PRE,
        ROOM_POST;

    }
}

